<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants,
                 com.vmware.webcenter.util.VMODLConstants,
                 com.vmware.webcenter.view.viewhelper.VmListViewImpl,
                 com.vmware.webcenter.util.SortCriteria" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="VM_POWERED_ON" value="<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>" scope="page" />
<c:set var="VM_POWERED_OFF" value="<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>" scope="page" />
<c:set var="VM_SUSPENDED" value="<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>" scope="page" />
<c:set var="VM_STATE_CONNECTED" value="<%= VMODLConstants.VIRTUALMACHINECONNECTIONSTATE_CONNECTED %>" scope="page" />
<c:set var="VM_STATE_DISCONNECTED" value="<%= VMODLConstants.VIRTUALMACHINECONNECTIONSTATE_DISCONNECTED %>" scope="page" />
<c:set var="VM_STATE_ORPHANED" value="<%= VMODLConstants.VIRTUALMACHINECONNECTIONSTATE_ORPHANED %>" scope="page" />
<c:set var="VIEW_MANAGER_KEY" value="<%= Constants.BEAN_VIEW_MANAGER %>" scope="page" />

<c:choose>
   <c:when test="${empty sessionScope[VIEW_MANAGER_KEY]}">
      <%-- We're being logged out from under our feet --%>
      <errors heading="<fmt:message key='errors.cancel' bundle='${messageResources}' />" class="error-16x16">
         <error><![CDATA[<fmt:message key='error.system.terminate.notification' bundle='${messageResources}' />]]></error>
      </errors>
   </c:when>
   <c:otherwise>
      <c:set var="viewManager" value="${sessionScope[VIEW_MANAGER_KEY]}" scope="page" />

      <browserPane page="<c:out value='${vmListView.currentPageNumber}'/>"
         total="<c:out value='${vmListView.totalSize}'/>">

         <cols sort="<c:out value='${vmListView.primarySortCriteria.property}'/>"
            dir="<c:out value='${vmListView.primarySortCriteria.sortOrder}'/>" >

            <col name="<%= VmListViewImpl.SORT_KEY_NAME %>"
               display="<bean:message key='vmFolderDetails.tab.summary.vmachines.colHeader.name'/>"
               canSort="true"
               widest="true" />
            <col name="<%= VmListViewImpl.SORT_KEY_CPU %>"
               display="<bean:message key='vmFolderDetails.tab.summary.vmachines.colHeader.cpu'/>"
               canSort="true" />
            <col name="<%= VmListViewImpl.SORT_KEY_MEMORY %>"
               display="<bean:message key='vmFolderDetails.tab.summary.vmachines.colHeader.memory'/>"
               canSort="true" />

            <c:if test="${viewManager.multiHost == 'true'}">
               <col name="status"
                  display="<bean:message key='vmFolderDetails.tab.summary.vmachines.colHeader.status'/>"
                  canSort="false" />
            </c:if>

         </cols>
         <nodes>

            <logic:iterate id="vm" name="vmListView" property="currentPage">

               <c:choose>
                  <c:when test="${vm.question != null}">
                     <c:set var="iconClass" value="waitingForInput-16x16" scope="page" />
                  </c:when>
                  <c:otherwise>
                     <c:choose>
                        <c:when test="${vm.powerState == VM_POWERED_ON}">
                           <c:set var="iconClass" value="poweredOn-16x16" scope="page" />
                        </c:when>
                        <c:when test="${vm.powerState == VM_POWERED_OFF}">
                           <c:set var="iconClass" value="poweredOff-16x16" scope="page" />
                        </c:when>
                        <c:when test="${vm.powerState == VM_SUSPENDED}">
                           <c:set var="iconClass" value="suspended-16x16" scope="page" />
                        </c:when>
                        <c:otherwise>
                           <c:set var="iconClass" value="vm-16x16" scope="page" />
                        </c:otherwise>
                     </c:choose>
                  </c:otherwise>
               </c:choose>
               <c:choose>
                  <c:when test="${vm.connectionState == VM_STATE_CONNECTED}">
                     <c:set var="vmDisabled" value="false" scope="page" />
                     <c:set var="appendedText" value="" scope="page" />
                  </c:when>
                  <c:when test="${vm.connectionState == VM_STATE_DISCONNECTED}">
                     <c:set var="vmDisabled" value="true" scope="page" />
                     <fmt:message var="appendedText" scope="page" bundle="${messageResources}"
                        key="navigationPane.browsers.VMs.vm.disconnected" />
                  </c:when>
                  <c:when test="${vm.connectionState == VM_STATE_ORPHANED}">
                     <c:set var="vmDisabled" value="true" scope="page" />
                     <fmt:message var="appendedText" scope="page" bundle="${messageResources}"
                        key="navigationPane.browsers.VMs.vm.orphaned" />
                  </c:when>
                  <c:otherwise>
                     <c:set var="vmDisabled" value="true" scope="page" />
                     <c:set var="appendedText" value="" scope="page" />
                  </c:otherwise>
               </c:choose>



               <node id="<c:out value='${vm.ID}'/>"
                  iconClass="<c:out value='${iconClass}' />"
                  children="true">

                  <col><cell><c:if test="${vmDisabled == 'true'}"><span class="disabled"></c:if><![CDATA[<c:out value="${vm.name}" />]]> <c:out value="${appendedText}" /><c:if test="${vmDisabled == 'true'}"></span></c:if></cell></col>
                  <col>
                     <cell>
                        <c:if test="${not empty vm.cpuUsage && vm.cpuUsage != '0'}">
                           <wc:out name="vm" property="cpuUsage" unitType="Hertz" in="MHz" />
                        </c:if>
                     </cell>
                  </col>
                  <col>
                     <cell>
                        <c:if test="${not empty vm.memoryUsage && vm.memoryUsage != '0'}">
                           <wc:out name="vm" property="memoryUsage" unitType="Byte" in="MB" />
                        </c:if>
                     </cell>
                  </col>

                  <c:if test="${viewManager.multiHost == 'true'}">

                     <col><cell><img
                     <logic:equal name="vm" property="state" value="<%= VMODLConstants.MANAGEDENTITYSTATUS_GREEN %>">
                        class="alarmOkay"
                     </logic:equal>
                     <logic:equal name="vm" property="state" value="<%= VMODLConstants.MANAGEDENTITYSTATUS_YELLOW %>">
                        class="alarmWarning"
                     </logic:equal>
                     <logic:equal name="vm" property="state" value="<%= VMODLConstants.MANAGEDENTITYSTATUS_RED %>">
                        class="alarmAlert"
                     </logic:equal>
                     src="imx/spacer.png" /></cell></col>

                  </c:if>

                  <attrs>
                     <attr name="tipSelected" value="<bean:message key='vpxbrowser.node.branch.tooltip.selected'/>" />
                     <attr name="tipUnselected" value="<bean:message key='vpxbrowser.node.branch.tooltip.unselected'/>" />
                  </attrs>

               </node>

            </logic:iterate>

         </nodes>

         <attrs>
            <attr name="viewId" value="<c:out value='${vmListView.ID}'/>" />
         </attrs>

      </browserPane>

   </c:otherwise>
</c:choose>
