<%@ page import="com.vmware.webcenter.util.VMODLConstants,
                 com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>
<%@ include file="/WEB-INF/jsp/common/contextTest.jsp" %>
<c:set var="VIEW_MANAGER_KEY" value="<%= Constants.BEAN_VIEW_MANAGER %>" scope="page" />
<c:set var="viewManager" value="${sessionScope[VIEW_MANAGER_KEY]}" scope="page" />

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>

<link href="css/default.css" rel="stylesheet" type="text/css" />
<link href="css/summary.css" rel="stylesheet" type="text/css" />
<!--[if IE]>
<link href="css/default-ie.css" rel="stylesheet" type="text/css" />
<![endif]-->

<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
   <jsp:param name="packages" value="net,browser,util" />
</jsp:include>

<script type="text/javascript" src="js/common/performance.js"></script>
<script type="text/javascript" src="js/details/vmFolder/tabs/summary/vmListBrowser.js"></script>
<script type="text/javascript">

vpx.context.vmListBrowser = {
   xmlSpec                    : null,
   paginator                  : null,
   browser                    : null,
   updatesId                  : null,
   updatesRunning             : false,
   toolbarUpdatesId           : null,
   toolbarUpdatesRunning      : false,
   toolbarSelectionReq        : null,
   toolbarSelectionTimeoutId  : null,
   vmFolderId                 : "<c:out value='${vmFolderSummaryView.vmFolder.ID}'/>",
   PAGE_SIZE                  : <bean:message bundle="internalResources" key="sysPrefs.pageSize.default"/>,
   VM_NAVIGATION_BROWSER      : "<%= Constants.BROWSER_NAME_VMACHINES %>",
   POWEREDON                  : "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>",
   POWEREDOFF                 : "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>",
   SUSPENDED                  : "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>"
};

function handleBodyLoad() {
   // Sync view to persistent state
   tle.syncView();

   <c:choose>
      <c:when test="${viewManager.multiHost == 'false'}">
	 var title = "<c:out value='${vmFolderSummaryView.hostDataItem.hostname}'/>";
      </c:when>
      <c:otherwise>
	 <c:choose>
	    <c:when test="${vmFolderSummaryView.vmFolder.ID == vmFolderSummaryView.rootId}">
	       var title = "<bean:message key='navigationPane.root.displayName'/>";
	    </c:when>
	    <c:otherwise>
	       var title = "<wc:jsSafe name="vmFolderSummaryView" property="vmFolder.name"/>";
	    </c:otherwise>
	 </c:choose>
      </c:otherwise>
   </c:choose>
   window.parent.initEntityDetails('VMFOLDER', title ,'<%= Constants.TAB_VMFOLDER_SUMMARY %>');

   // Initialize the VM list browser
   initVmListBrowser();   <%-- @see ~/js/details/vmFolder/tabs/summary/vmListBrowser.js --%>
}

function handleBodyUnload() {
   // Stop any processes that the vm list browser is running
   unloadVmListBrowser(); <%-- @see ~/js/details/vmFolder/tabs/summary/vmListBrowser.js --%>
}

</script>

</head>

<body onload="handleBodyLoad();" onunload="handleBodyUnload();" style="overflow:hidden; margin:0px; padding:0px;" scroll="no">
<%-- start column0 --%>
<div id="columnX">
   <!-- Start Virtual Machines section window -->
   <div id="virtualMachines" class="dialog">
      <div id="vmTitlebar" class="titlebar">
	 <table border="0" cellspacing="0" cellpadding="0">
	    <tr>
	       <td width="100%"><span id="l10n_vmFolderDetails.tab.summary.vmachines.header" class="sectionTitle"><bean:message key="vmFolderDetails.tab.summary.vmachines.header"/></span></td>
	    </tr>
	 </table>
      </div>

      <div style="border-bottom: solid 1px #B3B3B3; padding: 0px;">
	 <div id="browserContainer" class="cntnr" style="overflow:auto;"></div>
	 <div id="paginatorContainer"></div>
      </div>
   </div>
   <!-- End Virtual Machines section window -->
</div>
<%-- end column0 --%>

<%-- start column1 --%>
<!-- div id="column1">

   <%--
   <jsp:include page="/WEB-INF/jsp/details/vmFolder/tabs/summary/sectionWindows/vmFolderCommandsSectionWindow.jsp">
   <jsp:param name="dialogId" value="commands"/>
   </jsp:include>
   --%>

</div -->
<%-- end column1 --%>
</body>
</html:html>
