<%@ page import="com.vmware.webcenter.view.viewhelper.Constants,
                com.vmware.webcenter.view.viewhelper.VmDatastoreBrowserView,
                 com.vmware.webcenter.control.action.DatastoreBrowserAction,
                 com.vmware.webcenter.control.action.DataCollectionBaseAction" %>

<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="deviceType" value="${requestScope['deviceType']}"/>

<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">
<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
  <head>
     <link href="css/default.css" rel="stylesheet" type="text/css" />
     <!--[if IE]>
     <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
     <![endif]-->

     <link rel="stylesheet" type="text/css" href="css/dialogs/datastoreBrowser.css" />

     <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
     <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
	 <jsp:param name="packages" value="xua,net,gui,browser,drag" />
     </jsp:include>

     <script type="text/javascript" src="js/dialogs/datastoreBrowser.js"></script>
     <%@ include file="/WEB-INF/jsp/common/commonValidations.jsp" %>
     <script type="text/javascript">

     vpx.context = {
        xmlSpec                : null,
        paginator              : null,
        browser                : null,
        updatesId              : null,
        updatesRunning         : false,   
        PAGE_SIZE              : <%= Constants.BROWSER_PAGE_DEFAULT_SIZE %>,
        DC_PREV_PAGE           : "<%= DataCollectionBaseAction.DC_PREV_PAGE %>",
        DC_NEXT_PAGE           : "<%= DataCollectionBaseAction.DC_NEXT_PAGE %>",
        PARAM_NAME_PAGE        : "<%= DatastoreBrowserAction.PARAM_NAME_PAGE %>",
        PARAM_NAME_SORT_COL    : "<%= DatastoreBrowserAction.PARAM_NAME_SORT_COL %>",
        PARAM_NAME_SORT_DIR    : "<%= DatastoreBrowserAction.PARAM_NAME_SORT_DIR %>",
        PARAM_NAME_NAV_ITEM    : "<%= DatastoreBrowserAction.PARAM_NAME_NAV_ITEM %>",
        viewId                 : "<c:out value='${vmDatastoreBrowserView.ID}'/>",
        viewType               : "<c:out value="${vmDatastoreBrowserView.viewType}"/>",
        DATASTORE_BROWSER      : "<%= VmDatastoreBrowserView.TYPE_DATASTORE %>",
        CDDVD_BROWSER          : "<%= VmDatastoreBrowserView.TYPE_ISOIMAGE %>",
        FLOPPY_BROWSER         : "<%= VmDatastoreBrowserView.TYPE_FLOPPYIMAGE %>",
        TYPE_OTHER             : "<%= VmDatastoreBrowserView.TYPE_OTHER %>",
        FIXED_HEIGHT           : vpx.browser.Browser.HEIGHT_POLICY.USER,
        ACTION_ITEM            : "datastoreBrowser.do?viewId=" + 
                                 "<c:out value='${vmDatastoreBrowserView.ID}'/>"
     };


     var vpxWin;
     var methods = {};

     methods.getContentDimension = function() {
        return vpx.xua.getDimension("windowPane");
     };

     function initPane(o) {
        vpxWin = o;
        var handles = $("windowTitleCell");
        if (! isArray(handles)) {
           handles = [handles];
        }

        extendObject(vpxWin, methods);

        document.onkeyup = function (e) {
           if (vpx.xua.event.getKeyCode(e) == 27) {
              vpxWin.cancel();
           }
        };

       vpx.xua.event.listen($("windowClose"), "click", vpxWin.cancel.bind(vpxWin));
       
       /* Set browser height */
       vpx.xua.setHeight("browserContainer", 230);
       
       vpxWin.ready();
     };

     function handleRespond() {
     
       var c = vpx.context;
       var fileName = document.getElementById("fileNameInput").value;
       var freespace = document.getElementById("freeSpace").value;
       var fileType = document.getElementById("fileType").value;
       var location = c.browser.getLocation();       
       var mediaType = "<c:out value="${requestScope['mediaType']}"/>";
                   
       if (!isNull(mediaType) && mediaType == "blank") {         
         vpxWin.selectedItem = getFloppyImageFileName();
       } else if (!isNull(fileName)) {
         fileName = trimAll(fileName);
         var startIndex = fileName.indexOf("[");
         var endIndex = fileName.indexOf("]");   
            
         if (startIndex == 0 &&  endIndex > 0) {
           vpxWin.selectedItem = fileName;
         } else {  
           vpxWin.selectedItem = location.getId();           
           if (fileType == "<%= VmDatastoreBrowserView.TYPE_FOLDER %>") {
             vpxWin.selectedItem += "/";
           } 
           vpxWin.selectedItem += fileName;
         }
       }
       
       if (!isNull(freespace)){
         vpxWin.freespace = freespace;
       }
       
       vpxWin.okay();
     }

     function handleCancel() {
        vpxWin.cancel();
     }
     
     /**
      * get the blank floppy image file name.
      */
     
     function getFloppyImageFileName() {
        var location = vpx.context.browser.getLocation();          
        var fileName = document.getElementById("fileNameInput").value; 
        
 
        if (fileName == null || fileName.length == 0) {
          return;
        }        
        
        // Check for if the fileName starts with datastore i.e. [datastore]
        var startIndex = fileName.indexOf("[");
        var endIndex = fileName.indexOf("]");       
        var suffix = fileName.substring(fileName.lastIndexOf("."));  
        
        if (!isNull(location)) {          
           if (suffix.toLowerCase() == ".flp") {   
             if (startIndex != 0 &&  endIndex == -1) {        
               fileName = (location.getId()).replace(']',"] ") + "/" + fileName; 
             } 
           }else {
               fileName =  (location.getId()).replace(']',"] ") + "/" + fileName + ".flp";
           }            
        }
       return fileName;  
     }
 </script>
</head>

 <body onload="handleBodyLoad();" onunload="handleBodyUnload();">
  <input type="hidden" name="freeSpace" id="freeSpace" />
  <input type="hidden" name="fileType" id="fileType" />
  <div id="windowPane" class="dialog half" style="width:350px; height:400px;
  position:absolute; top:0px; left:0px; border:solid 1px #B3B3B3; margin:0px; padding-bottom:0px;">
  <div id="windowTitleBar" class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
       <tr>
          <td class="lcol listKeyIcon" style="padding-right:6px;"><div class="folder-16x16 icon"></div></td>
          <td id="windowTitleCell" width="100%"><span id="windowTitle" class="title">  
                        
          
           <c:if test="${deviceType == 'cdDvd'}">
              <span id="vm_common_datastore_browser_title_iso">
              <bean:message key="vm.common.datastore.browser.title.iso"/></span>
           </c:if>
           <c:if test="${deviceType == 'floppy'}">
              <span id="vm_common_datastore_browser_title_flp">
              <bean:message key="vm.common.datastore.browser.title.flp"/></span>
           </c:if>
           <c:if test="${deviceType == 'serial'}">           
              <span id="vm_common_datastore_browser_title_serial_file">
              <bean:message key="vm.common.datastore.browser.title.serial.file"/></span>
           </c:if>
           <c:if test="${deviceType == 'parallel'}">           
              <span id="vm_common_datastore_browser_title_parallel_file">
              <bean:message key="vm.common.datastore.browser.title.parallel.file"/></span>
           </c:if>
           <c:if test="${deviceType == 'general'}">           
              <span id="vm_common_datastore_browser_title_general_options">
              <bean:message key="vm.common.datastore.browser.title.general.options"/></span>
           </c:if>
           <c:if test="${deviceType == 'datastore'}">           
              <span id="vm_common_datastore_browser_title_datastore">
              <bean:message key="vm.common.datastore.browser.title.datastore"/></span>
           </c:if>            
                
          </span></td>
          <td id="windowCloseCell"><div id="windowClose" class="close-12x12 icon" /></td>
       </tr>
    </table>
  </div>
      <div style="margin:6px 6px 2px 6px;">
         <span id="vm_common_datastore_browser_folder_desc">
           <bean:message key="vm.common.datastore.browser.folder.desc"/>
         </span>
      </div>
      <div class="dialog" style="margin-top:0px; overflow: hidden; border: solid 1px #B3B3B3; padding: 0px;">
         <div id="navigatorContainer"></div>
         <div id="browserContainer"></div>
         <div id="paginatorContainer"></div>
      </div>
      <div style="margin:6px 2px 6px 2px;">
         <table width="335px" cellpadding="0" cellspacing="3" border="0">
            <tr>
               <td><span id="vm_common_datastore_browser_fileName">
                      <bean:message key="vm.common.datastore.browser.fileName"/>
                   </span>           
               </td>
               <td width="75%"><input id="fileNameInput" type="text" style="width:97%;" /></td>
            </tr>
            <tr>
               <td><span id="vm_common_datastore_browser_fileTypes">
                      <bean:message key="vm.common.datastore.browser.fileTypes"/>
                   </span>
               </td>
               <td width="75%">
           
               <c:if test="${deviceType == 'cdDvd'}">
                  <span id="vm_common_datastore_browser_isoImages">
                  <bean:message key="vm.common.datastore.browser.isoImages"/></span>
               </c:if>
               <c:if test="${deviceType == 'floppy'}">
                  <span id="vm_common_datastore_browser_flpImages">
                  <bean:message key="vm.common.datastore.browser.flpImages"/></span>
               </c:if>
               <c:if test="${deviceType == 'serial' || deviceType == 'parallel'}">           
                  <span id="vm_common_datastore_browser_outputFile">
                  <bean:message key="vm.common.datastore.browser.outputFile"/></span>
               </c:if>
               <c:if test="${deviceType == 'general'}">           
                  <span id="vm_common_datastore_browser_workingDir">
                  <bean:message key="vm.common.datastore.browser.workingDir"/></span>
               </c:if>
               <c:if test="${deviceType == ('datastore' or 'newDiskDatastoreBrowser')}">           
                  <span id="vm_common_datastore_browser_datastores">
                  <bean:message key="vm.common.datastore.browser.datastores"/></span>
               </c:if> 
                 </td>
            </tr>
         </table>
      </div>

       <div id="windowControls" style="margin: 0px 8px 0px 8px;">
          <div class="commandButtons">
             <input class="buttonCtrl" style="width: 80px;" type="button" id="OK" value="<bean:message key="common.label.ok"/>" onclick="handleRespond();" />
             <input class="buttonCtrl" style="width: 80px;" type="button" id="Cancel" value="<bean:message key="common.label.cancel"/>" onclick="handleCancel();" />
          </div>
       </div>
    </div>
</body>
</html:html>
