<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<html>
   <head>
      <title>Generic Errors</title>
      <link href="css/default.css" rel="stylesheet" type="text/css" />
      <!--[if IE]>
      <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
      <![endif]-->
      <style type="text/css">
         body { margin: 0px; padding: 0px; border: none; overflow: hidden; }
         .titlebar .title { margin-left: 0px; }
         div.commandButtons {
            border-top: solid 1px #e6e6e6;
            margin: 8px;
            margin-top: 0px;
            padding-top: 8px;
         }
      </style>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,drag" />
      </jsp:include>
      
      <script language="javascript" src="js/util/string.js"></script>

      <script type="text/javascript">
         var vpxWin;
         var methods = {};
         methods.getContentDimension = function() {
            return vpx.xua.getDimension("windowPane");
         };

         methods.getIcon = function () {
            return this.icon;
         };

         methods.setIcon = function (icon) {
            vpx.xua.setAttribute($("windowIcon"), "class", "icon " + icon.source);
            return this.icon = icon;
         };

         function initPane(o) {
            vpxWin = o;
            var handles = $("windowTitleCell");
            if (! isArray(handles)) {
               handles = [handles];
            }

            extendObject(vpxWin, methods);

            document.onkeyup = function (e) {
               if (vpx.xua.event.getKeyCode(e) == 27) {
                  vpxWin.cancel();
               }
            };

            vpx.xua.event.listen($("windowClose"), "click", close);

            vpxWin.ready();
         };

         function close() {
            loadDefaultPage();
         }


         function handleOK() {
            loadDefaultPage();
         }

         function handleLogout() {
            if (tle.getTopBarPane().logout != null) {
              tle.getTopBarPane().logout('logout.do');
            } else {
              tle.replaceAll('logout.do');
            }
         }

         function loadDefaultPage() {
            var exceptionHandler = "<c:out value="${param['exceptionHandler']}" />"; 
            if (exceptionHandler == "<%= Constants.SNAPSHOTOPS_EXCEPTION_HANDLER %>") {
              vpxWin.cancel();
              return;
            }
            if (exceptionHandler == "<%= Constants.POWEROPS_EXCEPTION_HANDLER %>") {
              vpxWin.cancel();
              return;
            }
            if (exceptionHandler == "<%= Constants.RUNTIME_EXCEPTION_HANDLER %>") {
               tle.location.href = "<c:out value='${pageContext.request.contextPath}/parentSelection.do' />";
               return;
            } 
            
            if (exceptionHandler != "<%= Constants.DEFAULT_EXCEPTION_HANDLER %>"  ||                             
                exceptionHandler == "<%= Constants.RUNTIME_FAULT_EXCEPTION_HANDLER %>") {                
               tle.location.href = "<c:out value='${pageContext.request.contextPath}/vManage.do' />";
            } else if (exceptionHandler == "<%= Constants.WIZARD_EXCEPTION_HANDLER %>") { 
               tle.getWorkspacePane().onTabSelect("<%= Constants.TAB_VM_SUMMARY %>");              
               vpxWin.cancel();  
            } else {              
               tle.syncView();
               vpxWin.cancel();
            }
         }
        
         
         function setCommandButtons() {
        
            var exceptionHandler = <c:out value="${param['exceptionHandler']}" />            
            if (exceptionHandler == "<%= Constants.FATAL_EXCEPTION_HANDLER %>") {
               document.getElementById("OK").style.display = "none";
               document.getElementById("windowClose").style.display = "none";
            }  else if (exceptionHandler == "<%= Constants.RUNTIME_EXCEPTION_HANDLER %>"||
                exceptionHandler == "<%= Constants.RUNTIME_FAULT_EXCEPTION_HANDLER %>" ) {
               document.getElementById("OK").value = "<bean:message key="errors.generic.button.ignore"/>";               
            } else if (exceptionHandler == "<%= Constants.POWEROPS_EXCEPTION_HANDLER %>") {
               document.getElementById("logout").style.display = "none";
            } else if (exceptionHandler == "<%= Constants.SNAPSHOTOPS_EXCEPTION_HANDLER %>") {
               document.getElementById("logout").style.display = "none";
            }
           
         }
         
      </script>
   </head>

   <body onload="setCommandButtons();">
      <div id="windowPane" class="dialog half" style="position:absolute; top:0px; left:0px; border-bottom:solid 1px #b3b3b3; margin:0px; padding-bottom:0px;">
         <div id="windowTitleBar" class="titlebar">
            <table border="0" cellspacing="0" cellpadding="0">
               <tr>
                  <td id="windowTitleCell" width="100%"><span id="l10n_wizard_add_hardware_validation_windowTitle" class="title">
                  <bean:message key="errors.vm.generic.dialog.windowTitle" /></span></td>
                  <td id="windowCloseCell"><div id="windowClose" class="close-12x12 icon" /></td>
               </tr>
            </table>
         </div>
         <!-- div style="width:100%; height:120px; background-color:#c00;" / -->
         <div style="margin: 8px;">
            <table style="border-collapse: collapse;" border="0" cellpadding="0" cellspacing="0">
               <tr>
                  <td valign="top"><div id="windowIcon" class="icon warning-32x32" /></td>
                  <td>
                     <div id="windowMessage" style="margin-left:8px;">

                     <span id="l10n_errors_vm_generic_dialog_windowDesc" class="title">
                         <bean:message key="errors.vm.generic.dialog.windowDesc" /></span>
                           <ul><li>
                             <script type="text/javascript">
                               <c:set var="item" value="${param['errors']}"/>
                               var msg = "<wc:jsSafe name="item" />";
                               document.write(insertWordBreak(msg.escapeElement()));
                             </script>
                           </li></ul>              
                    </div>
                  </td>
               </tr>
            </table>
         </div>

       <div id="windowControls">
          <div class="commandButtons">
               <input class="buttonCtrl" style="width: 80px;" type="button" id="logout" 
               value="<bean:message key="errors.generic.button.logout"/>" onclick="handleLogout();"/>
               <input class="buttonCtrl" style="width: 80px;" type="button" id="OK" 
               value="<bean:message key="errors.generic.button.OK"/>" onclick="handleOK();" />
          </div>
       </div>

      </div>
   </body>
</html>
