<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<c:set var="GENERIC_ERROR_KEY" value="<%= Constants.GENERIC_ERROR_KEY %>" scope="page"/>
<c:set var="errorsVO" value="${sessionScope[GENERIC_ERROR_KEY]}" scope="page"/>

<script type="text/javascript">
  function getXmlData() {
     var xmlData = null;
     <c:if test = "${errorsVO != null}">
        <c:choose>
           <%-- send it to the redirect URL --%>
           <c:when test="${errorsVO.redirectUrl != null}">
              xmlData='<errors redirect="<c:out value='${errorsVO.redirectUrl}'/>"/>';
           </c:when>
           <c:otherwise>
              xmlData = '<errors class="error-16x16">';
              <%-- Retrive localized messages and prepare the XML --%>
              <c:set var="messageList" value="${errorsVO.messages}"/>
              <c:if test="${messageList != null}">
                 <c:forEach var="item" items="${messageList}">
                    xmlData += '<error><![CDATA[<wc:jsSafe name="item" />]]></error>';
                 </c:forEach>
              </c:if>

              <%-- Retrive resouce keys and prepare the XML --%>
              <c:set var="resourceList" value="${errorsVO.resources}"/>
              <c:if test="${resourceList != null}">
                 <c:forEach var="item" items="${resourceList}">
                    xmlData += '<error><![CDATA[<bean:message key='${item}'/>]]></error>';
                 </c:forEach>
              </c:if>
              xmlData += "</errors>";
           </c:otherwise>
        </c:choose>
     </c:if>
     return xmlData;
  }
</script>