<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<c:set var="GENERIC_ERROR_KEY" value="<%= Constants.GENERIC_ERROR_KEY %>" scope="page"/>
<c:set var="errorsVO" value="${sessionScope[GENERIC_ERROR_KEY]}" scope="page"/>


<c:choose>

   <c:when test="${errorsVO != null}">
      <c:choose>

         <c:when test="${errorsVO.redirectUrl != null}">
            <%-- send it to the redirect URL --%>
            <errors redirect="<c:out value='${errorsVO.redirectUrl}'/>"/>
         </c:when>

         <c:otherwise>
            <errors
             heading="<fmt:message key='errors.vm.generic.dialog.windowTitle'
                       bundle='${messageResources}' />"
             class="error-16x16">
               <%-- Retrive localized messages and prepare the XML --%>
               <c:set var="msgs" value="${errorsVO.messages}"/>
               <c:if test="${msgs != null}">
                  <c:forEach var="msg" items="${msgs}">
                     <error><![CDATA[<c:out value='${msg}'/>]]></error>
                  </c:forEach>
               </c:if>

               <%-- Retrive resouce keys and prepare the XML --%>
               <c:set var="resources" value="${errorsVO.resources}"/>
               <c:if test="${resources != null}">
                  <c:forEach var="msgKey" items="${resources}">
                     <error><![CDATA[<bean:message key='${msgKey}'/>]]></error>
                  </c:forEach>
               </c:if>
               <handler type="<c:out value='${errorsVO.exceptionHandler}'/>"
                        fatal="<%= Constants.FATAL_EXCEPTION_HANDLER %>"/>
               
            </errors>
         </c:otherwise>

      </c:choose>
     
      <%-- TODO:Remove hardcoded value --%>
      <c:if test="${errorsVO.exceptionHandler != 3}">
        <c:remove var="com.vmware.webcenter.genericError" scope="session" />
      </c:if>

        

            
   </c:when>

   <c:otherwise>
      <errors/>
   </c:otherwise>

</c:choose>
