<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, 
                 com.vmware.webcenter.control.action.HelpAction,
                 com.vmware.webcenter.context.VmDirectVO" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="LOGIN_PROPERTIES_KEY" value="<%= com.vmware.webcenter.control.action.WelcomeAction.LOGIN_PROPERTIES_KEY %>" scope="page" />
<c:set var="loginProps" value="${applicationScope[LOGIN_PROPERTIES_KEY]}" scope="page" />
<c:set var="BEAN_CONTEXT_VMDIRECT" value="<%= Constants.BEAN_CONTEXT_VMDIRECT %>" scope="page" />
<c:set var="vmDirect" value="${sessionScope[BEAN_CONTEXT_VMDIRECT]}" scope="page" />
<c:set var="GENERIC_ERROR_KEY" value ="<%= Constants.GENERIC_ERROR_KEY %>"  scope="page"/>
<c:choose>
  <c:when test="${!empty requestScope[GENERIC_ERROR_KEY]}">
     <c:set var="errorsVO" value="${requestScope[GENERIC_ERROR_KEY]}" scope="page"/>
  </c:when>
  <c:otherwise>
     <c:set var="errorsVO" value="${sessionScope[GENERIC_ERROR_KEY]}" scope="page"/>
  </c:otherwise>
</c:choose>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<%-- Note that the local attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
   <head>

      <META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE">
      <META HTTP-EQUIV="PRAGMA" CONTENT="NO-CACHE">
      <META HTTP-EQUIV="EXPIRES" CONTENT="0">

      <title><bean:message key="login.title"/></title>
      
      <link rel="stylesheet" type="text/css" href="css/login.css">
      <!--[if IE]>
         <link href="css/login-ie.css" rel="stylesheet" type="text/css" />
      <![endif]-->

      <script src="js/validation/loginForm.js"></script>
      <script language="JavaScript" type="text/javascript">

         <%-- Struts validator will use window.alert 
         	  Override with method used to display other errors on screen
         --%>
         window.alert = displayClientError;
	
         //for Error types
         var ERROR = 0;
         var WARNING = 1;
         
         function isPopUpBlockerEnabled() {
            <%--  Bug 145366 - IE 7 does not allow the temporary window
                  to be closed, so we skip the pop up blocker test --%>
            if(navigator.userAgent.indexOf("MSIE 7") != -1) {
               return false;
            } 
            var vmwareTestAuxiliaryWindow = window.open("javascript:window.close();", "vmwareTestAuxiliaryWindow", "width=100,height=100");
            if (!vmwareTestAuxiliaryWindow) {
               return true;
            } else {
               <%-- Currently (Nov 10, 2005) .close() causes exceptions to be thrown in Firefox
                * This is a known Firefox issue and is being tracked:
                * https://bugzilla.mozilla.org/show_bug.cgi?id=291261
                --%>
               return false;
            }
         }

         function isCookieEnabled() {
            if (document.cookie.indexOf("wc_ping=") != -1) {
               // Session cookie found; already verified cookie acceptance
               return true;
            }
            document.cookie = "wc_ping=ack";
            return (document.cookie.indexOf("wc_ping=") != -1);
         }
         
         function isBrowserSupported() {
            if(((navigator.userAgent.indexOf('Linux') != -1) && (navigator.userAgent.indexOf('86') != -1)) 
               || navigator.userAgent.indexOf('Windows NT 5') != -1){
               if((navigator.userAgent.indexOf("Firefox") != -1) 
                  && ((((parseFloat(navigator.userAgent.substr((navigator.userAgent.indexOf("Firefox") + 8), 3))) == 1.0)
                     && ((parseFloat(navigator.userAgent.substr((navigator.userAgent.indexOf("Firefox") + 12), 1))) >= 8))
                  || (parseFloat(navigator.userAgent.substr((navigator.userAgent.indexOf("Firefox") + 8), 3)) == 1.5)
                  || (parseFloat(navigator.userAgent.substr((navigator.userAgent.indexOf("Firefox") + 8), 3)) == 2.0))) {
                  return true;
               } else if (navigator.appVersion.indexOf("MSIE") != -1 && navigator.userAgent.indexOf('Opera') == -1) {
                  var temp = navigator.appVersion.split("MSIE");
                  if (parseFloat(temp[1]) >= 6.0) {
                     return true;
                  }
               }
            }
            return false;
         }
         
         function launchHelp(helpFile) {
           window.open("help.do?<%= HelpAction.PARAM_NAME_HELP_FILE %>=" + helpFile, 
                       "helpWindow","menubar=1,toolbar=1,status=1,scrollbars=1");
         }
         
         function verifyClientCaps(){
            if(!isCookieEnabled()){
               //These are blocking errors and the user will not be allowed to procede with login
               displayClientError('<bean:message key="login.warning.enableCookies"/>', '<bean:message key="login.warning.clickToTryAgain"/>', ERROR);
            } else {
               //These are non-blocking errors so the user will be allowed to login, but with possibly limited capabilities
               if(!isBrowserSupported()){
                  displayClientError('<bean:message key="login.warning.browserCheck.notSupported"/>',
                                     '<bean:message key="login.warning.browserCheck.notCertified"/>' +
                                     ' <p><a href="javascript:launchHelp(\'<bean:message bundle="helpFiles" key="help.browserCheck.details"/>\');">' + 
                                     '<bean:message key="login.warning.browserCheck.seeDetails"/></a>', WARNING);
               }
               if(isPopUpBlockerEnabled()){
                  displayClientError('<bean:message key="login.warning.popupBlocker.detected"/>', '<bean:message key="login.warning.popupBlocker.explanation"/>', WARNING);
               }
               enableLoginForm();
            }
         }

         function enableLoginForm(){
            document.loginForm.wsUrl.disabled = false;
            document.loginForm.userName.disabled = false;
            document.loginForm.userPassword.disabled = false;
            document.loginForm.btnSubmit.disabled = false; //enable the Login button. Since this is in JavaScript, this means script is enabled as well.
            document.loginForm.btnSubmit.className = ""; //sets the style for enabled login button
            turnAutoCompleteOff();
         }

         function turnAutoCompleteOff() {
            document.loginForm.setAttribute('autocomplete','off');
         }

         function displayClientError (errorHeader, errorMsg, errorType) {
            var errHeader = "";
            var errMsg = "";
            var errType = ERROR;
            
            if (arguments.length == 1) {
               errMsg = errorHeader;
            } else if (arguments.length >= 2) {
               errHeader = errorHeader;
               errMsg = errorMsg;
            } 
            
            if (errorType != null) {
               errType = errorType;
            }
            
            var formattedMsg = "";
            
            document.getElementById("clientError").style.display = '';
            formattedMsg = '<table cellspacing="4" cellpadding="0"><tr valign="top"><td>';

            if (errType == WARNING) {
               formattedMsg += '<img src="imx/warning-12x12.png">';
            } else {
               formattedMsg += '<img src="imx/error-12x12.png">';
            }
            formattedMsg += '</td>'; 
            formattedMsg += '<td>';
            formattedMsg += '<span class="errorHeader">' + errHeader + '</span>';
            formattedMsg += '<p class="errorExplanation"><span>' + errMsg + '</span></p>';
            formattedMsg += '</td>';
            formattedMsg += '</tr></table>';
            
            if (errType == ERROR){
               document.getElementById("errorSection").innerHTML = "";
            }
            document.getElementById("errorSection").innerHTML += formattedMsg;
         }
         
         function initPage(){
            verifyClientCaps();
         }

      </script>
   </head>

   <body onload="initPage();">
      <html:form action="login" method="post" focus="wsUrl" onsubmit="return submitLoginForm(this)">
         
<%-- START LOGIN SECTION WINDOW --%>
<table class="loginSectionWindow" cellpadding="0" cellspacing="0" align="center">
   <tr class="header">
      <td class="headerIcon"><img src="imx/vmwareLogo-16x16.png"></td>
      <td class="headerLabel"><headerLabel><span id="l10n_login_loginSectionWindow_header_label"
            name="l10n_login_loginSectionWindow_header_label"><bean:message key="login.loginSectionWindow.header.label"/></span></headerLabel></td>
   </tr>
   <tr>
      <td colspan="2">
         <table cellpadding="0" cellspacing="0" width="100%" height="100%">
            <tr>
               <td class="sideBar">&nbsp;</td>
               <td>
                  <table cellspacing="0" cellpadding="0" class="inputsSection">

                     <%-- BEGIN ERRORS SECTION --%>
                     <c:if test = "${errorsVO != null}">
                        <c:choose>
                           <%-- send it to the redirect URL --%>
                           <c:when test="${errorsVO.redirectUrl != null}">
                              <script type="text/javascript">
                                 window.location.href = "<c:out value='${errorsVO.redirectUrl}'/>";
                              </script>
                           </c:when>
                           <c:otherwise>
                              <tr>
                                 <td colspan="2" class="errorSection">
                                    <table cellspacing="4" cellpadding="0">
                                       <%-- Display localized messages --%>
                                       <c:set var="messageList" value="${errorsVO.messages}"/>
                                       <c:if test="${messageList != null}">
                                          <c:forEach var="msg" items="${messageList}">
                                             <tr valign="top">
                                                <td><img src="imx/error-12x12.png"></td>
                                                <td><span class="errorHeader"><c:out value="${msg}"/></span></td>
                                             </tr>
                                          </c:forEach>
                                       </c:if>

                                       <%-- Display resource messages --%>
                                       <c:set var="resourceList" value="${errorsVO.resources}"/>
                                       <c:if test="${resourceList != null}">
                                          <c:forEach var="msgKey" items="${resourceList}">
                                             <tr valign="top">
                                                <td><img src="imx/error-12x12.png"></td>
                                                <td><span class="errorHeader"><bean:message key="${msgKey}"/></span></td>
                                             </tr>
                                          </c:forEach>
                                       </c:if>
                                    </table>
                                 </td>
                              </tr>
                           </c:otherwise>
                        </c:choose>
                        <c:remove var="com.vmware.webcenter.genericError" scope="session" />
                     </c:if>

                     <%-- the following is displayed if scripting is not enabled/supported --%>
                     <noscript>
                        <tr>
                           <td colspan="2" class="errorSection">
                              <table cellspacing="4" cellpadding="0">
                                    <tr valign="top">
                                       <td><img src="imx/error-12x12.png"></td>
                                       <td> 
                                          <span id="login_warning_enableScripting" name="login_warning_enableScripting"><span class="errorHeader">
                                             <bean:message key="login.warning.enableScripting"/>
                                          </span><p class="errorExplanation" id="login_warning_clickToTryAgain_1" name="login_warning_clickToTryAgain_1">
                                             <bean:message key="login.warning.clickToTryAgain"/>  
                                          </span>                                       
                                       </td>
                                    </tr>
                              </table>
                           </td>
                        </tr>
                     </noscript>

                     <%--
                        The following messages are hidden unless some capabilities are not met.
                        verifyClientCaps is called in the body's onLoad method, which can only work
                        if scripting is enabled. This means that the following div will stay hidden
                        if scripting is disabled.
                     --%>


                        <tr id="clientError" name="clientErr" style="display:none">
                           <td colspan="2" class="errorSection" id="errorSection"></td>
                        </tr>


                     <%-- END ERRORS SECTION --%>

                     <tr class="catDivider">
                        <td colspan="2">
                           <table width="100%" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td class="catLabel">
                                    <span name="l10n_login_catHeader_credentials" id="l10n_login_catHeader_credentials">
                                       <bean:message key="login.catHeader.credentials"/>
                                    </span>
                                 </td>
                                 <td class="catHr"><img src="imx/spacer.png" class="hr" align="middle"></td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                     <c:choose>
                        <c:when test="${loginProps['login.webServiceUrl.enabled'] == 'true'}">
                           <tr class="inputRow">
                              <td nowrap="nowrap" class="inputLabel">
                                 <span id="l10n_login_label_wsUrl" name="l10n_login_label_wsUrl">
                                    <bean:message key="login.label.wsUrl"/>:
                                 </span>
                              </td>
                              <td class="inputField">
                                 <c:choose>
                                    <c:when test="${vmDirect != null}">
                                       <% VmDirectVO vmDirect = (VmDirectVO) session.getAttribute(Constants.BEAN_CONTEXT_VMDIRECT); %>
                                       <input type="text" value="<c:out value='${vmDirect.wsUrl}' />" disabled="disabled" />
                                       <html:hidden property="wsUrl" value="${vmDirect.wsUrl}" />
                                    </c:when>
                                    <c:otherwise>
                                       <c:choose>
                                          <c:when test="${loginProps['login.webServiceUrl.input'] == 'list'}">
                                             <html:select property="wsUrl" disabled="true">
                                                <c:catch var="ex">
                                                   <c:forEach items="${loginProps['login.webServiceUrl.values']}" var="url" varStatus="status">
                                                      <html:option value="${url}"><c:out value="${loginProps['login.webServiceUrl.names'][status.index]}" /></html:option>
                                                   </c:forEach>
                                                </c:catch>
                                                <c:if test="${ex != null}">
                                                   <html:option value="${loginProps['login.webServiceUrl.values']}">${loginProps['login.webServiceUrl.names']}</html:option>
                                                </c:if>
                                             </html:select>
                                          </c:when>
                                          <c:otherwise>
                                             <html:text property="wsUrl" value="${loginProps['login.webServiceUrl.defaultValue']}" disabled="true"/>
                                          </c:otherwise>
                                       </c:choose>
                                    </c:otherwise>
                                 </c:choose>
                              </td>
                           </tr>
                        </c:when>
                        <c:otherwise>
                           <logic:present name="<%= Constants.BEAN_CONTEXT_VMDIRECT %>" scope="session">
                              <% VmDirectVO vmDirect = (VmDirectVO) session.getAttribute(Constants.BEAN_CONTEXT_VMDIRECT); %>
                              <html:hidden property="wsUrl" value="${vmDirect.wsUrl}" />
                           </logic:present>
                           <logic:notPresent name="<%= Constants.BEAN_CONTEXT_VMDIRECT %>" scope="session">
                              <html:hidden property="wsUrl" value="${loginProps['login.webServiceUrl.defaultValue']}" />
                           </logic:notPresent>
                        </c:otherwise>
                     </c:choose>
                     <tr class="inputRow">
                        <td nowrap="nowrap" class="inputLabel">
                           <span id="l10n_login_label_userName" id="l10n_login_label_userName">
                              <bean:message key="login.label.userName"/>:
                           </span>
                        </td>
                        <td class="inputField">
                           <c:choose>
                              <c:when test="${vmDirect != null}">
                                 <c:choose>
                                    <c:when test="${vmDirect.user != ''}">
                                       <input type="text" value="<c:out value='${vmDirect.user}' />" disabled="disabled" />
                                       <html:hidden property="userName" value="${vmDirect.user}" />
                                    </c:when>
                                    <c:otherwise>
                                       <html:text property="userName" value="${loginProps['login.userName.defaultValue']}" disabled="true"/>
                                    </c:otherwise>
                                 </c:choose>
                              </c:when>
                              <c:otherwise>
                                 <html:text property="userName" value="${loginProps['login.userName.defaultValue']}" disabled="true"/>
                              </c:otherwise>
                           </c:choose>
                        </td>
                     </tr>
                     <tr class="inputRow">
                        <td nowrap="nowrap" class="inputLabel">
                           <span id="l10n_login_label_userPassword" name="l10n_login_label_userPassword">
                              <bean:message key="login.label.userPassword"/>:
                           </span>
                        </td>
                        <td class="inputField">
                           <html:password property="userPassword" value="" disabled="true"/>
                        </td>
                     </tr>
                     <tr class="divider">
                        <td colspan="2"><img src="imx/spacer.png" class="hr"></td>
                     </tr>
                     <tr height="100%" class="buttonsRow">
                        <td colspan="2" align="right" valign="top" class="loginButton">
                           <html:submit property="btnSubmit" disabled="true" styleClass="disabled">
                              <bean:message key="login.button.login"/>
                           </html:submit>
                        </td>
                     <tr>
                  </table>
               </td>
            </tr>
         </table>
      </td>
   </tr>
</table>
<%-- END LOGIN SECTION WINDOW --%>


<%-- The following are filled by the fillBrowserCaps javascript method which is
         called just prior to the form submission after all field values have been
         validated. See js module linked to at the top of this page.
--%>

<html:hidden property="clientCaps.appCodeName"/>
<html:hidden property="clientCaps.appMinorVersion"/>
<html:hidden property="clientCaps.appName"/>
<html:hidden property="clientCaps.appVersion"/>
<html:hidden property="clientCaps.platform"/>
<html:hidden property="clientCaps.userAgent"/>
</html:form>

<%-- Including the javascript validator methods for this form --%>
<html:javascript formName="loginForm"/>

</body>
</html:html>

<logic:present name="<%= Constants.BEAN_CONTEXT_VMDIRECT %>" scope="session">
   <logic:equal name="<%= Constants.BEAN_CONTEXT_VMDIRECT %>" property="invalidateSession" value="true">
      <% session.invalidate(); %>
   </logic:equal>
</logic:present>
<logic:notPresent name="<%= Constants.BEAN_CONTEXT_VMDIRECT %>" scope="session">
   <% session.invalidate(); %>
</logic:notPresent>

<%--  We invalidate the session every time we meet the login page.
         This way there's no invalidation decision in the events that need to
         redirect to the login page, and such events can be chained knowing that
         the last one will reach the login page and the session will be invalidated.
--%>
