<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp" %>
<%@ page import="com.vmware.webcenter.util.VMODLConstants,
                 com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="VM_POWERED_ON" value="<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>" scope="page" />
<c:set var="VM_POWERED_OFF" value="<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>" scope="page" />
<c:set var="VM_SUSPENDED" value="<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>" scope="page" />
<c:set var="VM_STATE_CONNECTED" value="<%= VMODLConstants.VIRTUALMACHINECONNECTIONSTATE_CONNECTED %>" scope="page" />
<c:set var="VM_STATE_DISCONNECTED" value="<%= VMODLConstants.VIRTUALMACHINECONNECTIONSTATE_DISCONNECTED %>" scope="page" />
<c:set var="VM_STATE_ORPHANED" value="<%= VMODLConstants.VIRTUALMACHINECONNECTIONSTATE_ORPHANED %>" scope="page" />
<c:set var="TYPE_FOLDER" value="<%= Constants.TYPE_FOLDER %>" scope="page" />
<c:set var="TYPE_VM_FOLDER" value="<%= Constants.TYPE_VM_FOLDER %>" scope="page" />
<c:set var="TYPE_HOST_FOLDER" value="<%= Constants.TYPE_HOST_FOLDER %>" scope="page" />
<c:set var="TYPE_DATACENTER_FOLDER" value="<%= Constants.TYPE_DATACENTER_FOLDER %>" scope="page" />
<c:set var="TYPE_VM" value="<%= Constants.TYPE_VM %>" scope="page" />
<c:set var="TYPE_HOST" value="<%= Constants.TYPE_HOST %>" scope="page" />
<c:set var="TYPE_DATACENTER" value="<%= Constants.TYPE_DATACENTER %>" scope="page" />
<c:set var="VIEW_MANAGER_KEY" value="<%= Constants.BEAN_VIEW_MANAGER %>" scope="page" />

<c:choose>
   <c:when test="${empty sessionScope[VIEW_MANAGER_KEY]}">
      <%-- We're being logged out from under our feet --%>
      <errors heading="<fmt:message key='errors.cancel' bundle='${messageResources}' />" class="error-16x16">
         <error><![CDATA[<fmt:message key='error.system.terminate.notification' bundle='${messageResources}' />]]></error>
      </errors>
   </c:when>
   <c:otherwise>
      <c:set var="viewManager" value="${sessionScope[VIEW_MANAGER_KEY]}" scope="page" />

      <browserPane page="<c:out value='${navigationView.currentPageNumber}' />" total="<c:out value='${navigationView.totalSize}' />">
         <locations>
            <c:if test="${viewManager.multiHost == 'true'}">
               <c:forEach items="${navigationView.parentDataItems}" var="location">
                  <c:choose>
                     <c:when test="${location.type == TYPE_FOLDER || location.type == TYPE_VM_FOLDER || location.type == TYPE_DATACENTER_FOLDER}">
                        <c:set var="iconClass" value="folder-16x16" scope="page" />
                     </c:when>
                     <c:when test="${location.type == TYPE_DATACENTER}">
                        <c:set var="iconClass" value="datacenter-16x16" scope="page" />
                     </c:when>
                     <c:otherwise>
                        <c:set var="iconClass" value="vmwareLogo-16x16" scope="page" />
                     </c:otherwise>
                  </c:choose>
                  <location id="<c:out value='${location.ID}' />" iconClass="<c:out value='${iconClass}' />">
                     <c:choose>
                        <c:when test="${location.ID == navigationView.rootId}">
                           <display><bean:message key="navigationPane.root.displayName"/></display>
                        </c:when>
                        <c:otherwise>
                           <display><c:out value="${location.name}" /></display>
                        </c:otherwise>
                     </c:choose>
                     <attrs>
                        <attr name="entityType" value="<c:out value='${location.type}' />" />
                     </attrs>
                  </location>
               </c:forEach>
            </c:if>
            <c:choose>
               <c:when test="${viewManager.multiHost == 'false'}">
                  <%-- If single host env, always show host icon --%>
                  <c:set var="iconClass" value="host-16x16" scope="page" />
               </c:when>
               <c:when test="${navigationView.baseDataItem.type == TYPE_FOLDER || navigationView.baseDataItem.type == TYPE_VM_FOLDER || navigationView.baseDataItem.type == TYPE_DATACENTER_FOLDER}">
                  <c:set var="iconClass" value="folder-16x16" scope="page" />
               </c:when>
               <c:when test="${navigationView.baseDataItem.type == TYPE_DATACENTER}">
                  <c:set var="iconClass" value="datacenter-16x16" scope="page" />
               </c:when>
               <c:otherwise>
                  <c:set var="iconClass" value="vmwareLogo-16x16" scope="page" />
               </c:otherwise>
            </c:choose>
            <location id="<c:out value='${navigationView.baseDataItem.ID}' />" iconClass="<c:out value='${iconClass}' />">
               <c:choose>
                  <c:when test="${viewManager.multiHost == 'false'}">
                     <display><c:out value="${navigationView.hostDataItem.hostname}" /></display>
                  </c:when>
                  <c:otherwise>
                     <c:choose>
                        <c:when test="${navigationView.baseDataItem.ID == navigationView.rootId}">
                           <display><bean:message key="navigationPane.root.displayName"/></display>
                        </c:when>
                        <c:otherwise>
                           <display><c:out value="${navigationView.baseDataItem.name}" /></display>
                        </c:otherwise>
                     </c:choose>
                  </c:otherwise>
               </c:choose>
               <attrs>
                  <attr name="entityType" value="<c:out value='${navigationView.baseDataItem.type}' />" />
               </attrs>
            </location>
         </locations>
         <cols sort="" dir="">
            <col name="name"
               display="<fmt:message key='navigationPane.browsers.colHeader.name' bundle='${messageResources}' />"
               canSort="false"
               widest="true" />
         </cols>
         <nodes>
            <c:forEach items="${navigationView.currentPage}" var="entity">
               <%-- Determine properties of node and set into page-scoped vars --%>
               <c:set var="hasChildren" value="false" scope="page" />
               <c:choose>
                  <c:when test="${entity.type == TYPE_VM}">
                     <c:choose>
                        <c:when test="${entity.question != null}">
                           <c:set var="iconClass" value="waitingForInput-16x16" scope="page" />
                        </c:when>
                        <c:otherwise>
                           <c:choose>
                              <c:when test="${entity.powerState == VM_POWERED_ON}"><c:set var="iconClass" value="poweredOn-16x16" scope="page" /></c:when>
                              <c:when test="${entity.powerState == VM_POWERED_OFF}"><c:set var="iconClass" value="poweredOff-16x16" scope="page" /></c:when>
                              <c:when test="${entity.powerState == VM_SUSPENDED}"><c:set var="iconClass" value="suspended-16x16" scope="page" /></c:when>
                              <c:otherwise><c:set var="iconClass" value="vm-16x16" scope="page" /></c:otherwise>
                           </c:choose>
                        </c:otherwise>
                     </c:choose>
                     <c:choose>
                        <c:when test="${entity.connectionState == VM_STATE_CONNECTED}">
                           <c:set var="entityDisabled" value="false" scope="page" />
                           <c:set var="appendedText" value="" scope="page" />
                        </c:when>
                        <c:when test="${entity.connectionState == VM_STATE_DISCONNECTED}">
                           <c:set var="entityDisabled" value="true" scope="page" />
                              <bean:define id="navigationPane_browsers_VMs_vm_disconnected">
                                 <bean:message key="navigationPane.browsers.VMs.vm.disconnected"/>
                              </bean:define>
                           <c:set var="appendedText" value="${navigationPane_browsers_VMs_vm_disconnected}" scope="page" />
                        </c:when>
                        <c:when test="${entity.connectionState == VM_STATE_ORPHANED}">
                           <c:set var="entityDisabled" value="true" scope="page" />
                              <bean:define id="navigationPane_browsers_VMs_vm_orphaned">
                                 <bean:message key="navigationPane.browsers.VMs.vm.orphaned"/>
                              </bean:define>
                           <c:set var="appendedText" value="${navigationPane_browsers_VMs_vm_orphaned}" scope="page" />
                        </c:when>
                        <c:otherwise>
                           <c:set var="entityDisabled" value="true" scope="page" />
                           <c:set var="appendedText" value="" />
                        </c:otherwise>
                     </c:choose>
                  </c:when>
                  <c:when test="${entity.type == TYPE_FOLDER || entity.type == TYPE_VM_FOLDER || entity.type == TYPE_DATACENTER_FOLDER}">
                     <c:set var="hasChildren" value="true" scope="page" />
                     <c:set var="iconClass" value="folder-16x16" scope="page" />
                     <c:set var="entityDisabled" value="false" scope="page" />
                     <c:set var="appendedText" value="" scope="page" />
                  </c:when>
                  <c:when test="${entity.type == TYPE_DATACENTER}">
                     <c:set var="hasChildren" value="true" scope="page" />
                     <c:set var="iconClass" value="datacenter-16x16" scope="page" />
                     <c:set var="entityDisabled" value="false" scope="page" />
                     <c:set var="appendedText" value="" scope="page" />
                  </c:when>
                  <c:otherwise>
                     <c:set var="iconClass" value="vmwareLogo-16x16" scope="page" />
                     <c:set var="entityDisabled" value="false" scope="page" />
                     <c:set var="appendedText" value="" scope="page" />
                  </c:otherwise>
               </c:choose>

               <%-- Render node XML using vars that we set up --%>
               <node id="<c:out value='${entity.ID}' />" children="<c:out value='${hasChildren}' />" iconClass="<c:out value='${iconClass}' />">
                  <col><cell><c:if test="${entityDisabled == 'true'}"><span class="disabled"></c:if><![CDATA[<bean:write name="entity" property="name"/>]]> <c:out value="${appendedText}" /><c:if test="${entityDisabled == 'true'}"></span></c:if></cell></col>
                  <attrs>
                     <attr name="entityType" value="<c:out value='${entity.type}' />" />
                     <attr name="entityName" value="<c:out value='${entity.name}' />" />
                     <attr name="tipSelected" value="<bean:message key='vpxbrowser.node.branch.tooltip.selected'/>" />
                     <attr name="tipUnselected" value="<bean:message key='vpxbrowser.node.branch.tooltip.unselected'/>" />
                  </attrs>
               </node>
            </c:forEach>
         </nodes>
         <attrs>
            <attr name="viewId" value="<c:out value='${navigationView.ID}' />" />
         </attrs>
         <c:if test="${navigationView.selectedItem != null}">
            <selections>
               <selection id="<c:out value='${navigationView.selectedItem.ID}' />" />
            </selections>
         </c:if>
      </browserPane>

   </c:otherwise>
</c:choose>
