<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="GENERIC_ERROR_KEY" value ="<%= Constants.GENERIC_ERROR_KEY %>"  scope="page"/>
<c:set var="errorsVO" value="${sessionScope[GENERIC_ERROR_KEY]}" scope="page"/>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<%-- Note that the local attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
   <head>

      <META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE">
      <META HTTP-EQUIV="PRAGMA" CONTENT="NO-CACHE">
      <META HTTP-EQUIV="EXPIRES" CONTENT="0">

      <title><bean:message bundle="siResources" key="scriptedInstall.login.title"/></title>

      <link rel="stylesheet" type="text/css" href="css/login.css">
      <!--[if IE]>
         <link href="css/login-ie.css" rel="stylesheet" type="text/css" />
      <![endif]-->

      <script src="js/validation/loginForm.js"></script>
      <script language="JavaScript" type="text/javascript">
         function isCookieEnabled() {
            if (document.cookie.indexOf("wc_ping=") != -1) {
               // Session cookie found; already verified cookie acceptance
               return true;
            }
            document.cookie = "wc_ping=ack";
            return (document.cookie.indexOf("wc_ping=") != -1);
         }

         function verifyClientCaps(){
            if(!isCookieEnabled()){
               //These are blocking errors and the user will not be allowed to procede with login
               displayClientError('<bean:message bundle="siResources" key="scriptedInstall.login.warning.enableCookies"/> <p> <bean:message bundle="siResources" key="scriptedInstall.login.warning.clickToTryAgain"/>');
            } else {
               //These are non-blocking errors so the user will be allowed to login, but with possibly limited capabilities
               enableLoginForm();
            }
         }

         function enableLoginForm(){
            document.loginForm.wsUrl.disabled = false;
            document.loginForm.userName.disabled = false;
            document.loginForm.userPassword.disabled = false;
            document.loginForm.btnSubmit.disabled = false; //enable the Login button. Since this is in JavaScript, this means script is enabled as well.
            document.loginForm.btnSubmit.className = ""; //sets the style for enabled login button
         }

         function initPage(){
            verifyClientCaps();
         }

      </script>
   </head>

   <body onload="initPage();">
      <html:form action="scriptedInstallLogin" method="post" focus="userName" onsubmit="return submitLoginForm(this)">
         <table cellpadding="0" cellspacing="4" align="center">
            <tr>
               <td valign="top">
<%-- START LOGIN SECTION WINDOW --%>
<table class="loginSectionWindow" cellpadding="0" cellspacing="0">
   <tr class="header">
      <td class="headerIcon"><img src="imx/vmwareLogo-16x16.png"></td>
      <td class="headerLabel"><headerLabel><span id="l10n_login_loginSectionWindow_header_label"
            name="l10n_login_loginSectionWindow_header_label"><bean:message bundle="siResources" key="scriptedInstall.login.loginSectionWindow.header.label"/></span></headerLabel></td>
   </tr>
   <tr>
      <td colspan="2">
         <table cellpadding="0" cellspacing="0" width="100%" height="100%">
            <tr>
               <td class="sideBar">&nbsp;</td>
               <td>
                  <table cellspacing="0" cellpadding="0" class="inputsSection">

                     <%-- BEGIN ERRORS SECTION --%>
                     <c:if test = "${errorsVO != null}">
                        <c:choose>
                           <%-- send it to the redirect URL --%>
                           <c:when test="${errorsVO.redirectUrl != null}">
                              <script type="text/javascript">
                                 window.location.href = "<c:out value='${errorsVO.redirectUrl}'/>";
                              </script>
                           </c:when>
                           <c:otherwise>
                              <tr>
                                 <td colspan="2" class="errorSection">
                                    <table cellspacing="4" cellpadding="0">
                                       <%-- Display localized messages --%>
                                       <c:set var="messageList" value="${errorsVO.messages}"/>
                                       <c:if test="${messageList != null}">
                                          <c:forEach var="msg" items="${messageList}">
                                             <tr valign="top">
                                                <td><img src="imx/error-12x12.png"></td>
                                                <td><span><c:out value="${msg}"/></span></td>
                                             </tr>
                                          </c:forEach>
                                       </c:if>

                                       <%-- Display resource messages --%>
                                       <c:set var="resourceList" value="${errorsVO.resources}"/>
                                       <c:if test="${resourceList != null}">
                                          <c:forEach var="msgKey" items="${resourceList}">
                                             <tr valign="top">
                                                <td><img src="imx/error-12x12.png"></td>
                                                <td><span><bean:message key="${msgKey}"/></span></td>
                                             </tr>
                                          </c:forEach>
                                       </c:if>
                                    </table>
                                 </td>
                              </tr>
                           </c:otherwise>
                        </c:choose>
                        <c:remove var="com.vmware.webcenter.genericError" scope="session" />
                     </c:if>
                     <c:if test="${param['terminateMessage'] != null}">
                        <tr>
                           <td colspan="2" class="errorSection">
                              <table cellspacing="4" cellpadding="0">
                                 <tr valign="top">
                                    <td><img src="imx/error-12x12.png"></td>
                                    <td><span><bean:message key="${param['terminateMessage']}"/></span></td>
                                 </tr>
                              </table>
                           </td>
                        </tr>
                     </c:if>

                     <%-- the following is displayed if scripting is not enabled/supported --%>
                     <noscript>
                        <tr>
                           <td colspan="2" class="errorSection">
                              <table cellspacing="4" cellpadding="0">
                                    <tr valign="top">
                                       <td><img src="imx/error-12x12.png"></td>
                                       <td>
                                          <span id="login_warning_enableScripting" name="login_warning_enableScripting">
                                             <bean:message bundle="siResources" key="scriptedInstall.login.warning.enableScripting"/>
                                          </span>
                                          <p>
                                          <span id="login_warning_clickToTryAgain_1" name="login_warning_clickToTryAgain_1">
                                             <bean:message bundle="siResources" key="scriptedInstall.login.warning.clickToTryAgain"/>
                                          </span>
                                       </td>
                                    </tr>
                              </table>
                           </td>
                        </tr>
                     </noscript>

                     <%--
                        The following messages are hidden unless some capabilities are not met.
                        verifyClientCaps is called in the body's onLoad method, which can only work
                        if scripting is enabled. This means that the following div will stay hidden
                        if scripting is disabled.
                     --%>


                        <tr id="clientError" name="clientErr" style="display:none">
                           <td colspan="2" class="errorSection">
                              <table cellspacing="4" cellpadding="0">
                                    <tr valign="top">
                                       <td><img src="imx/error-12x12.png"></td>
                                       <td>
                                          <span id="clientErrorMsg">
                                          </span>
                                       </td>
                                    </tr>
                              </table>
                           </td>
                        </tr>


                     <%-- END ERRORS SECTION --%>

                     <tr class="catDivider">
                        <td colspan="2">
                           <table width="100%" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td class="catLabel">
                                    <span name="l10n_login_catHeader_credentials" id="l10n_login_catHeader_credentials">
                                       <bean:message bundle="siResources" key="scriptedInstall.login.catHeader.credentials"/>
                                    </span>
                                 </td>
                                 <td class="catHr"><img src="imx/spacer.png" class="hr" align="middle"></td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                     <tr class="inputRow">
                        <td nowrap="nowrap" class="inputLabel">
                           <html:hidden property="wsUrl" value="http://localhost:8085" />
                           <span id="l10n_login_label_userName" id="l10n_login_label_userName">
                              <bean:message bundle="siResources" key="scriptedInstall.login.label.userName"/>:
                           </span>
                        </td>
                        <td class="inputField">
                           <html:text property="userName" disabled="true"/>
                        </td>
                     </tr>
                     <tr class="inputRow">
                        <td nowrap="nowrap" class="inputLabel">
                           <span id="l10n_login_label_userPassword" name="l10n_login_label_userPassword">
                              <bean:message bundle="siResources" key="scriptedInstall.login.label.userPassword"/>:
                           </span>
                        </td>
                        <td class="inputField">
                           <html:password property="userPassword" value="" disabled="true"/>
                        </td>
                     </tr>
                     <tr class="divider">
                        <td colspan="2"><img src="imx/spacer.png" class="hr"></td>
                     </tr>
                     <tr height="100%" class="buttonsRow">
                        <td colspan="2" align="right" valign="top" class="loginButton">
                           <html:submit property="btnSubmit" disabled="true" styleClass="disabled" >
                              <bean:message bundle="siResources" key="scriptedInstall.login.button.login"/>
                           </html:submit>
                        </td>
                     <tr>
                  </table>
               </td>
            </tr>
         </table>
      </td>
   </tr>
</table>
<%-- END LOGIN SECTION WINDOW --%>
</td>
</tr>
</table>

<%-- The following are filled by the fillBrowserCaps javascript method which is
         called just prior to the form submission after all field values have been
         validated. See js module linked to at the top of this page.
--%>

<html:hidden property="clientCaps.appCodeName"/>
<html:hidden property="clientCaps.appMinorVersion"/>
<html:hidden property="clientCaps.appName"/>
<html:hidden property="clientCaps.appVersion"/>
<html:hidden property="clientCaps.platform"/>
<html:hidden property="clientCaps.userAgent"/>
</html:form>

<%-- Including the javascript validator methods for this form --%>
<html:javascript formName="loginForm"/>

</body>
</html:html>
