<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/contextTest.jsp" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<c:set var="contextPath" value="<%= request.getContextPath() %>" scope="page" />
<c:set var="WEBSERVICE_IP_ADDRESS" value="<%= Constants.WEBSERVICE_IP_ADDRESS %>" scope="page" />

<%-- Note that the local attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>
<link href="css/default.css" rel="stylesheet" type="text/css" />
<!--[if IE]>
<link href="css/default-ie.css" rel="stylesheet" type="text/css" />
<![endif]-->

<title></title>

<script src="js/tle/tle.js"></script>

<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
<%-- packages "ext,logging,net" implicitly loaded by commonJs.jsp --%>
<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
   <jsp:param name="packages" value="xua,core,gui,updates,win,drag" />
</jsp:include>

<script language="JavaScript" type="text/javascript">
function initSessionContextVariables() {
   setMultiHost(<bean:write name="<%= Constants.BEAN_VIEW_MANAGER %>" property="multiHost"/>);
}

function setTitleBar() {
   var titleBar = "<bean:write name="context_user" property="userName"/>@";
   var webServiceIP =  "<c:out value='${sessionScope[WEBSERVICE_IP_ADDRESS]}' />";
   if (webServiceIP == "127.0.0.1") {
      titleBar = titleBar + tle.getLocationHostName();
   } else {
      titleBar = titleBar + "<bean:write name="context_user" property="wsUrl.host"/>";
   }
   titleBar = titleBar + ": <bean:message key="title.main"/>";
   document.title = titleBar;
}
</script>
</head>

<body style="background-color: #fff; margin:2px; padding:0px; overflow:hidden;" onload="setTitleBar();" onunload="notifyAppUnload()"> <%-- notifyAppUnload is found in tle.js--%>
<script type="text/javascript">
   tle.setContextPath("<c:out value='${contextPath}'/>");
   tle.setServerName("<c:out value="${pageContext.request.serverName}"/>");

   <%-- This code should be run on body.onload, but the onload isn't
   getting fired because one of the iframes is spinning --%>
   initSessionContextVariables();

   <%-- TODO Move hard coded interval to properties file --%>
   updatesAgent = new vpx.updates.Agent(<fmt:message key="sysPrefs.refreshRate.updatesAgent" bundle="${internalResources}" />);
   updatesAgent.start();

   <%-- Instantiate the shared vpx-lib HttpRequestPool --%>
   requestPool = vpx.net.HttpRequestPool.getInstance(vpx.net.HttpRequestPool.DEFAULT_POOL_KEY,
       <fmt:message key="sysPrefs.threadCount.httpRequestPool" bundle="${internalResources}" />);

   <c:set var="VIEW_SETTINGS" value="<%= Constants.BEAN_CONTEXT_VIEWSETTINGS %>" scope="page" />
   <c:set var="viewSettings" value="${sessionScope[VIEW_SETTINGS]}" scope="page" />
   tle.viewSettings.toolbarVisible = <c:out value="${viewSettings.toolbarVisible}" />;
   tle.viewSettings.tabsVisible = <c:out value="${viewSettings.tabsVisible}" />;
   tle.viewSettings.navVisible = <c:out value="${viewSettings.navVisible}" />;
   tle.viewSettings.navResizable = <c:out value="${viewSettings.navResizable}" />;
</script>

<iframe id="wc_appFrame" name="wc_appFrame" width="100%" height="100%" frameborder="no" scrolling="no" src="main.do" style="display:block;"></iframe>
</body>
</html:html>
