<%@ page import="com.vmware.webcenter.wizard.Constants, com.vmware.webcenter.wizard.config.StepConfig" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="STEPS_KEY" value="<%= Constants.STEPS_KEY %>" scope="page" />
<c:set var="CURRENT_STEP_INDEX_KEY" value="<%= Constants.CURRENT_STEP_INDEX_KEY %>" scope="page" />
<c:set var="VISITED_STEP_INDEX_KEY" value="<%= Constants.VISITED_STEP_INDEX_KEY %>" scope="page" />

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css" />
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <style type="text/css">
         .toc
         {
            height: 310px;
            overflow:auto;
         }
         .toc_past
         {
         }
         .toc_present
         {
            font-weight:bold;
         }
         .toc_future
         {
            color:#999999;
         }
         .index
         {
            color:#666666;
         }
      </style>

		<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
		<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
			<jsp:param name="packages" value="xua" />
		</jsp:include>

		<script language="JavaScript" type="text/javascript">
         vpx.wzrd = {};
         vpx.wzrd.steps = [];
         <c:forEach items="${requestScope[STEPS_KEY]}" var="step" varStatus="status">
            vpx.wzrd.steps[<c:out value="${status.index}" />] = {name:"<c:out value="${step.name}" />", loadAction:"<c:out value="${pageContext.request.contextPath}${step.loadAction}" />"};
         </c:forEach>
         vpx.wzrd.currentIndex = <c:out value="${requestScope[CURRENT_STEP_INDEX_KEY]}" />
         vpx.wzrd.visitedIndex = <c:out value="${requestScope[VISITED_STEP_INDEX_KEY]}" />

         function syncToStep(step) {
            // TODO Add client-side logic to update TOC without reload when possible
            window.location.reload();
         }

         function syncToNextStep(key, value) {

            var form = document.contentsForm;
            form.propertyKey.value = key;
            form.propertyValue.value = value;
            form.submit();
         }

         function handleBack() {
            var index = vpx.wzrd.currentIndex - 1;
            if (index < 0) {
               return;
            }
            var href = vpx.wzrd.steps[index].loadAction;
            href = href + "?step=back";
            tle.getWorkspacePane().workspaceDetails.wc_wizardWorkspacePane.location.href = href;
         }

         function handleNext() {
            var form = tle.getWorkspacePane().workspaceDetails.wc_wizardWorkspacePane.document.forms[0];
            // TODO Form validation
            form.submit();
         }

         function handleCancel() {
            tle.location.href = "<c:out value="${pageContext.request.contextPath}/wzrdCancel.do" />";
         }

         function setNextEnabled(bool) {
            var button = $("button_next");
            button.disabled = !bool;
            button.className = bool ? "buttonCtrl" : "buttonCtrl disabled";
         }

         function setBackEnabled(bool) {
            var button = $("button_back");
            button.disabled = !bool;
            button.className = bool ? "buttonCtrl" : "buttonCtrl disabled";
         }

         function resizeToc() {
            var viewHeight = vpx.xua.viewport.getHeight(self);
            var tocHeight = vpx.xua.getHeight("toc");
            var tocY = vpx.xua.getY("toc");
            var contentsHeight = vpx.xua.getHeight("contents");

            var newHeight = viewHeight - (tocHeight - contentsHeight) - (tocY * 2);

            var contentsY = vpx.xua.getY("contents");
            var tocListY = vpx.xua.getY("tocList");
            var tocListHeight = vpx.xua.getHeight("tocList");
            var legendY = vpx.xua.getY("legend");
            var legendHeight = vpx.xua.getHeight("legend");
            var opticalMarginTop = tocListY - (legendY + legendHeight);

            if (newHeight - (opticalMarginTop * 2) < tocListHeight) {
               vpx.xua.setStyle("contents", "overflow", "auto");
            } else {
            	vpx.xua.setStyle("contents", "overflow", "");
            }

            vpx.xua.setHeight("contents", newHeight);
            return true;
         }

         function initPage() {
            tle.toggleModal(true);
            vpx.xua.event.listen(parent, "resize", resizeToc);
            resizeToc();
         }

         function handleBodyUnload() {
            vpx.xua.event.ignore(parent, "resize", resizeToc);
         }

      </script>
   </head>
   <body onload="initPage();" onunload="handleBodyUnload();">
      <form name="contentsForm" method="GET">
         <input type="hidden" name="propertyKey" value="">
         <input type="hidden" name="propertyValue" value="">
      </form>

      <div id="toc" class="dialog" style="width: 247px;">
         <div class="titlebar">
            <table border="0" cellspacing="0" cellpadding="0">
               <tr>
                  <td width="100%"><span class="title"><bean:message key="${sessionScope[WIZARDVO_KEY].wizardConfig.displayName}" /></span></td>
               </tr>
            </table>
         </div>

         <div class="window">
            <div id="legend" class="legend"><span><bean:message key="wizard.global.contents" /></span></div>
            <div id="contents" class="fieldset">
               <table id="tocList">
                  <c:forEach items="${requestScope[STEPS_KEY]}" var="step" varStatus="status">
                     <tr valign="top">
                        <td class="index"><c:out value="${status.count}" />.</td>
                        <c:choose>
                           <c:when test="${status.index <= requestScope[VISITED_STEP_INDEX_KEY]}">
                              <c:choose>
                                 <c:when test="${status.index == requestScope[CURRENT_STEP_INDEX_KEY]}">
                                    <td class="toc_present"><bean:message key="${step.displayName}" /></td>
                                 </c:when>
                                 <c:otherwise>
                                    <fmt:message key="${step.description}" bundle="${messageResources}" var="titleAttr" scope="page" />
                                       <td><html:link action="${step.loadAction}?step=back" target="wc_wizardWorkspacePane" title="${titleAttr}"><bean:message key="${step.displayName}" /></html:link></td>
                                 </c:otherwise>
                              </c:choose>
                           </c:when>
                           <c:otherwise>
                              <td class="toc_future"><bean:message key="${step.displayName}" /></td>
                           </c:otherwise>
                        </c:choose>
                     </tr>
                  </c:forEach>
               </table>
            </div>
            <%-- don't renice line below: white spaces would introduce undesired spaces around buttons!  --%>
            <div class="commandButtons"><c:choose><c:when test="<%= (Integer.parseInt(request.getAttribute(Constants.CURRENT_STEP_INDEX_KEY).toString()) == ((java.util.List)request.getAttribute(Constants.STEPS_KEY)).size() - 1) %>"><fmt:message key="wizard.global.buttons.finish" bundle="${messageResources}" var="nextValue" scope="page" /></c:when><c:otherwise><fmt:message key="wizard.global.buttons.next" bundle="${messageResources}" var="nextValue" scope="page" /></c:otherwise></c:choose><c:choose><c:when test="${requestScope[CURRENT_STEP_INDEX_KEY] == 0}"><input type="button" id="button_back" class="buttonCtrl disabled" style="margin-left:0px;" value="<bean:message key="wizard.global.buttons.back" />" onclick="handleBack();" disabled="disabled" /></c:when><c:otherwise><input type="button" id="button_back" class="buttonCtrl" style="margin-left:0px;" value="<bean:message key="wizard.global.buttons.back" />" onclick="handleBack();" /></c:otherwise></c:choose><input type="button" id="button_next" class="buttonCtrl" value="<c:out value="${nextValue}" />" onclick="handleNext();" /><input type="button" id="button_cancel" class="buttonCtrl" value="<bean:message key="wizard.global.buttons.cancel" />" onclick="handleCancel();" /></div>
         </div>
      </div>
   </body>
</html>
