<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants"%>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page"/>
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page"/>
<c:set var="CDDVD_CLIENT_MEDIA_PHYSICAL" value="<%= String.valueOf(Constants.CDDVD_CLIENT_MEDIA_PHYSICAL) %>" scope="page" />
<c:forEach var='map' items='${wizard.viewMap}'>
   <c:if test="${map.key eq 'dvdView'}">
      <c:set var="dvdView" value="${map.value}"/>
   </c:if>
</c:forEach>

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css"/>
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css"/>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,gui,browser,win,drag"/>
      </jsp:include>
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
      <script type="text/javascript" src="js/wizard/hardware.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>
      <script type="text/javascript">
      function init() {
       initHelp('cdDvd');
       <c:if test="${!wizard.form.valid}">
	      handleValidationDialog(tle.getWorkspacePane());
       </c:if>
         syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name" />');
      }
       
      function toggleDriveSource(){

	   var boolPhysical = document.getElementById("physical").checked;
	   var boolVirtual = document.getElementById("virtual").checked;

	   document.getElementById("clientExclusive").disabled = !boolPhysical;
	   document.getElementById("clientExclusive").checked = !boolVirtual;
	   document.getElementById("l10n_wizard_hardware_cdDvd_clientExclusiveLabel").className = boolPhysical ? "" : "disabled";
      }
      </script>
   </head>

   <body onload="init();" onunload="tearDown();">
      <div class="titlebar" style="width: 505px;">
         <table border="0" cellspacing="0" cellpadding="0">
            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_cdDvd_ide_title" class="title">
                  <bean:message key="wizard.hardware.cdDvd.ide.title"/></span>
               </td>
            </tr>

            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_cdDvd_ide_title_desc" class="subtitle">
                  <bean:message key="wizard.hardware.cdDvd.ide.title.desc"/></span>
               </td>
            </tr>
         </table>
      </div>

      <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
            <c:set var="media" value="${wizard.form.data['cdDvd.mediaType']}"/>

            <c:forEach var='map' items='${wizard.viewMap}'>
               <c:if test="${map.key eq 'dvdView'}">
                  <c:set var="cdDvdView" value="${map.value}"/>
               </c:if>
            </c:forEach>

            <div class="window">
               <div class="fieldset">
                  <div class="legend">
                     <span id="l10n_wizard_hardware_cdDvd_virtualDevice">
                     <bean:message key="wizard.hardware.cdDvd.virtualDevice"/></span>
                  </div>

                  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td width="25%">
                           <span id="l10n_wizard_hardware_cdDvd_ide">
                           <bean:message key="wizard.hardware.cdDvd.ide"/>
                        </td>

                        <td width="75%">
                           <c:set var="aNode" value="${cdDvdView.availableIdeNode}"/>
                           <html:select property="property(cdDvd.ideNode)">
                              <c:if test="${!empty cdDvdView.ideNodes}">
                                 <c:forEach var="node" items="${cdDvdView.ideNodes}">
                                    <html:option value="${node.used}:${node.value}">
                                    <c:out value="${node.name}"/> </html:option>
                                 </c:forEach>
                              </c:if>
                           </html:select>
                        </td>
                     </tr>
                  </table>
               </div>

               <c:if test="${media == CDDVD_CLIENT_MEDIA_PHYSCIAL}">
                  <div class="fieldset">
                     <div class="legend">
                        <span id="l10n_wizard_hardware_cdDvd_access">
                        <bean:message key="wizard.hardware.cdDvd.access"/></span>
                     </div>

                     <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                           <td class="bulletCtrl">
                              <input type="radio" class="radioCtrl" name="property(cdDvd.access)"
                                value="<%= Constants.CDDVD_CLIENT_ACCESS_PASSTHROUGH %>"
                                checked="1" id="physical" onclick="toggleDriveSource()">
                           </td>

                           <td>
                              <label class="title"><span id="l10n_wizard_hardware_cdDvd_access_physcial">
                              <bean:message key="wizard.hardware.cdDvd.access.physcial"/></span></label>

                              <div class="description">
                                 <span id="l10n_wizard_hardware_cdDvd_access_physcial_desc">
                                 <bean:message key="wizard.hardware.cdDvd.access.physical.desc"/></span>
                              </div>
                           </td>
                        </tr>

                        <c:if test="${dvdView.remotePassthroughBackingOption.exclusive}">
                           <tr>
                              <td>
                              </td>

                              <td>
                                 <table class="description" border="0" cellspacing="0" cellpadding="0">
                                    <tr>
                                       <td class="bulletCtrl" width="1%">
										  <c:set var="cb" value="${wizard.form.data['cdDvd.clientExclusive']}"/>

                                          <c:choose>
                                             <c:when test="${cb == 'Yes'}">
                                                <input type="checkbox" id="clientExclusive" onclick="selectionChanged();" checked="1">
                                             </c:when>
                                             <c:otherwise>
                                                <input type="checkbox" id="clientExclusive" onclick="selectionChanged();">
                                             </c:otherwise>
                                         </c:choose>
                                       </td>

                                       <td colspan="2">
                                          <label for="clientExclusiveLabel">
                                          <span id="l10n_wizard_hardware_cdDvd_clientExclusiveLabel">
                                          <bean:message key="wizard.hardware.cdDvd.clientExclusiveLabel"/> </span></label>
                                       </td>
                                    </tr>
                                 </table>
                              </td>
                           </tr>
                        </c:if>

                        <tr>
                           <td class="bulletCtrl">
                              <input type="radio"  class="radioCtrl" name="property(cdDvd.access)"
                                 value="<%= Constants.CDDVD_CLIENT_ACCESS_EMULATE %>" id="virtual"
                                 onclick="toggleDriveSource()">
                           </td>

                           <td>
                              <label class="title"><span id="l10n_wizard_hardware_cdDvd_access_virtual">
                              <bean:message key="wizard.hardware.cdDvd.access.virtual"/></span></label>

                              <div class="description">
                                 <span id="l10n_wizard_hardware_cdDvd_access_virtual_desc">
                                 <bean:message key="wizard.hardware.cdDvd.access.virtual.desc"/></span>
                              </div>
                           </td>
                        </tr>
						<html:hidden property="property(cdDvd.clientExclusive)" styleId="_clientExclusive"/>
                     </table>
                  </div>
			      <script type="text/javascript">
                     function selectionChanged(){
                        document.getElementById("_clientExclusive").value = "No"

                        if (document.getElementById("clientExclusive").checked){
                           document.getElementById("_clientExclusive").value = "Yes"
                        }
                     }
                  </script>
               </c:if>
         </html:form>
      </div>
   </body>
</html>
