<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants"%>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page"/>
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page"/>
<c:set var="CDDVD_HOST_MEDIA_PHYSICAL" value="<%= String.valueOf(Constants.CDDVD_HOST_MEDIA_PHYSICAL) %>" scope="page" />
<c:set var="CDDVD_HOST_MEDIA_ISO" value="<%= String.valueOf(Constants.CDDVD_HOST_MEDIA_ISO) %>" scope="page" />
<c:set var="CDDVD_CLIENT_MEDIA_PHYSICAL" value="<%= String.valueOf(Constants.CDDVD_CLIENT_MEDIA_PHYSICAL) %>" scope="page" />

<html>
   <head>
      <link rel="stylesheet" href="css/default.css" type="text/css"/>
      <!--[if IE]>
      <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css"/>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua"/>
      </jsp:include>
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
      <script language="JavaScript" type="text/javascript">
       function init() {
         initHelp('cdDvd');
         syncContentsToStep('cdDvdConfirmation');
       }
  
      </script> 
   </head>

   <body onload="init();" onunload="tearDown();">
      <div class="titlebar" style="width: 505px;">
         <table border="0" cellspacing="0" cellpadding="0">
            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_cdDvd_confirmation_title" class="title">
                  <bean:message key="wizard.hardware.cdDvd.confirmation.title"/></span>
               </td>
            </tr>

            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_cdDvd_confirmation_title_desc" class="subtitle">
                  <bean:message key="wizard.hardware.cdDvd.confirmation.title.desc"/></span>
               </td>
            </tr>
         </table>
      </div>

      <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
            <c:forEach var='map' items='${wizard.viewMap}'>
               <c:if test="${map.key eq 'dvdView'}">
                  <c:set var="cdDvdView" value="${map.value}"/>
               </c:if>
            </c:forEach>

            <div class="window">
               <div class="fieldset">
                  <span class="legend" id="l10n_wizard_hardware_cdDvd_confirmation_add_device">
                  <bean:message key="wizard.hardware.cdDvd.confirmation.add.device"/></span>

                  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_cdDvd_confirmation_hardware_type">
                           <bean:message key="wizard.hardware.cdDvd.confirmation.hardware.type"/></span>
                        </td>

                        <td>
                           <span id="l10n_wizard_hardware_cdDvd_confirmation_hardware_type_desc">
                           <bean:message key="wizard.hardware.cdDvd.confirmation.hardware.type.desc"/></span>
                        </td>
                     </tr>

                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_cdDvd_confirmation_media_type">
                           <bean:message key="wizard.hardware.cdDvd.confirmation.media.type"/></span>
                        </td>

                        <td>
                           <c:set var="media" value="${wizard.form.data['cdDvd.mediaType']}"/>

                           <c:if test="${media == CDDVD_HOST_MEDIA_PHYSICAL}">
                              <bean:message key="wizard.hardware.cdDvd.confirmation.media.host.physical"/>
                           </c:if>

                           <c:if test="${media == CDDVD_HOST_MEDIA_ISO}">
                              <bean:message key="wizard.hardware.cdDvd.confirmation.media.host.iso"/>
                           </c:if>

                           <c:if test="${media == CDDVD_CLIENT_MEDIA_PHYSICAL}">
                              <bean:message key="wizard.hardware.cdDvd.confirmation.media.client.physical"/>
                           </c:if>
                        </td>
                     </tr>

                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_cdDvd_confirmation_media_source">
                           <bean:message key="wizard.hardware.cdDvd.confirmation.media.source"/></span>
                        </td>

                        <td>
                           <c:if test="${media == CDDVD_HOST_MEDIA_PHYSICAL}">
                              <c:out value="${wizard.form.data['cdDvd.hostMediaPhysicalPath']}"/>
                           </c:if>

                           <c:if test="${media == CDDVD_HOST_MEDIA_ISO}">
                              <c:out value="${wizard.form.data['cdDvd.isoImagePath']}"/>
                           </c:if>

                           <c:if test="${media == CDDVD_CLIENT_MEDIA_PHYSICAL}">
                              <c:out value="${wizard.form.data['cdDvd.clientMediaPhysicalPath']}"/>
                           </c:if>
                        </td>
                     </tr>
                     
                     <c:if test="${media != CDDVD_CLIENT_MEDIA_PHYSICAL}">
                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_cdDvd_confirmation_connectAtPowerOn">
                           <bean:message key="wizard.hardware.cdDvd.confirmation.connectAtPowerOn"/></span>
                        </td>

                        <td>
                           <c:set var="cb" value="${wizard.form.data['cdDvd.connectAtPowerOn']}"/>
                           <c:choose>
                              <c:when test="${cb == 'Yes'}">
                                 <bean:message key="common.label.yes"/>
                              </c:when>

                              <c:otherwise>
                                 <bean:message key="common.label.no"/>
                              </c:otherwise>
                           </c:choose>
                        </td>
                     </tr>
                     </c:if>

                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_cdDvd_confirmation_vrtualDevice">
                           <bean:message key="wizard.hardware.cdDvd.confirmation.vrtualDevice"/></span>
                        </td>

                        <td>
                           <c:set var="ideNodeList" value="${cdDvdView.ideNodes}"/>

                           <c:if test="${ideNodeList != null}">
                              <c:forEach var="node" items="${ideNodeList}">
                                 <c:set var="ideNodeValue" value="${node.used}:${node.value}"/>

                                 <c:if test="${wizard.form.data['cdDvd.ideNode'] == ideNodeValue}">
                                    <c:out value="${node.name}"/>
                                 </c:if>
                              </c:forEach>
                           </c:if>
                        </td>
                     </tr>

                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_cdDvd_confirmation_access">
                           <bean:message key="wizard.hardware.cdDvd.confirmation.access"/></span>
                        </td>

                        <td>
                           <span id="l10n_wizard_hardware_cdDvd_confirmation_emulation">
                           <bean:message key="wizard.hardware.cdDvd.confirmation.emulation"/></span>
                        </td>
                     </tr>
                  </table>
               </div>
            </div>
         </html:form>
      </div>
   </body>
</html>
