<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants"%>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page"/>
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page"/>

<c:set var="CDDVD_HOST_MEDIA_PHYSICAL" value="<%= String.valueOf(Constants.CDDVD_HOST_MEDIA_PHYSICAL) %>" scope="page" />
<c:set var="CDDVD_HOST_MEDIA_ISO" value="<%= String.valueOf(Constants.CDDVD_HOST_MEDIA_ISO) %>" scope="page" />
<c:set var="CDDVD_CLIENT_MEDIA_PHYSICAL" value="<%= String.valueOf(Constants.CDDVD_CLIENT_MEDIA_PHYSICAL) %>" scope="page" />

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css"/>
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css"/>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>

      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,win,drag"/>
      </jsp:include>
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
      <script type="text/javascript" src="js/wizard/datastore.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>
      <script>
         function respond() {
	         if (this.selectedItem != null) {
	            document.getElementById("drivePath").value=this.selectedItem;
	         }
	      }
	      function init() {
	         initHelp('cdDvd');
            <c:if test="${!wizard.form.valid}">
	            handleValidationDialog(tle.getWorkspacePane());
            </c:if>
            syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name" />');
         }
         
      </script>
   </head>

   <body onload="init();" onunload="tearDown();">
      <div class="titlebar" style="width: 505px;">
         <table border="0" cellspacing="0" cellpadding="0">
            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_cdDvd_drive_title" class="title">
                  <bean:message key="wizard.hardware.cdDvd.drive.title"/></span>
               </td>
            </tr>

            <tr>
               <td width="100%">
                  <div class="subtitle">
                     <span id="l10n_wizard_hardware_cdDvd_drive_desc">
                     <bean:message key="wizard.hardware.cdDvd.drive.desc"/></span>
                  </div>
               </td>
            </tr>
         </table>
      </div>

      <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
            <c:set var="media" value="${wizard.form.data['cdDvd.mediaType']}"/>

            <div class="window">
               <div class="fieldset">
                  <c:choose>
                     <c:when test="${media == CDDVD_HOST_MEDIA_ISO}">
                        <span class="legend" id="l10n_wizard_hardware_cdDvd_isoImage">
                        <bean:message key="wizard.hardware.cdDvd.isoImage"/></span>
                     </c:when>

                     <c:otherwise>
                        <span class="legend" id="l10n_wizard_hardware_cdDvd_physicalDrive">
                        <bean:message key="wizard.hardware.cdDvd.physicalDrive"/></span>
                     </c:otherwise>
                  </c:choose>

                  <table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td width="100%">
                           <c:if test="${media == CDDVD_HOST_MEDIA_PHYSICAL}">
                              <html:text property="property(cdDvd.hostMediaPhysicalPath)" style="width:100%"
                                         styleId="drivePath"/>
                           </c:if>

                           <c:if test="${media == CDDVD_HOST_MEDIA_ISO}">
                              <html:text property="property(cdDvd.isoImagePath)" style="width:100%"
                                         styleId="drivePath"/>
                           </c:if>

                           <c:if test="${media == CDDVD_CLIENT_MEDIA_PHYSICAL}">
                              <html:text property="property(cdDvd.clientMediaPhysicalPath)" style="width:100%"
                                         styleId="drivePath"/>
                           </c:if>
                        </td>

                        <c:if test="${media == CDDVD_HOST_MEDIA_ISO}">
                           <td style="white-space : nowrap">
                              <a href="#" onclick="handleOpenDialog('cdDvd', self); return false;" id="browseIso">
                              <span id="l10n_vmConfiguration_browse">
                              <bean:message key="vmConfiguration.browse"/> </span></a>
                           </td>
                        </c:if>
                     </tr>
                  </table>
               </div>
               
               <c:if test="${media != CDDVD_CLIENT_MEDIA_PHYSICAL}">

               <div class="fieldset">
                  <span class="legend" id="110n_wizard_hardware_cdDvd_device_status">
                  <bean:message key="wizard.hardware.cdDvd.device.status"/></span>

                  <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td class="bulletCtrl">
                           <c:set var="cb" value="${wizard.form.data['cdDvd.connectAtPowerOn']}"/>

                           <c:choose>
                              <c:when test="${cb == 'Yes'}">
                                 <input type="checkbox" id="connectAtPowerOn" onclick="selectionChanged();" checked="1">
                              </c:when>

                              <c:otherwise>
                                 <input type="checkbox" id="connectAtPowerOn" onclick="selectionChanged();">
                              </c:otherwise>
                           </c:choose>
                        </td>

                        <td>
                           <label for="connectAtPowerOn"><span id="110n_wizard_hardware_cdDvd_device_connectAtPowerOn">
                           <bean:message key="wizard.hardware.cdDvd.device.connectAtPowerOn"/></span></label>
                        </td>
                     </tr>

                     <html:hidden property="property(cdDvd.connectAtPowerOn)" styleId="_connectAtPowerOn"/>
                  </table>
               </div>
               </c:if>
               
            </div>

            <script type="text/javascript">
               function selectionChanged(){
                  document.getElementById("_connectAtPowerOn").value = "No"

                  if (document.getElementById("connectAtPowerOn").checked){
                     document.getElementById("_connectAtPowerOn").value = "Yes"
                  }
               }
            </script>
         </html:form>
      </div>
   </body>
</html>
