<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />
<c:forEach var='map' items='${wizard.viewMap}'>
   <c:if test="${map.key eq 'dvdView'}">
      <c:set var="dvdView" value="${map.value}"/>
   </c:if>
</c:forEach>

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css" />
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css" />

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
      
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      
      <script type="text/javascript" src="js/wizard/common.js"></script>

      <script type="text/javascript">
	    function setFormInputs() {

           var mediaType = <c:out value="${wizard.form.data['cdDvd.mediaType']}" />
           document.getElementById("hostPhysical").checked=true;
           if (mediaType == "<%= Constants.CDDVD_HOST_MEDIA_PHYSICAL %>") {
             document.getElementById("hostPhysical").checked=true;
           } else if (mediaType == "<%= Constants.CDDVD_HOST_MEDIA_ISO %>") {
             document.getElementById("hostISO").checked=true;
           } else if (mediaType == "<%= Constants.CDDVD_CLIENT_MEDIA_PHYSICAL %>") {
             document.getElementById("clientPhysical").checked=true;
           }
       }
       
       function init() {
         initHelp('cdDvd');
         setupHelp("<bean:message bundle="helpFiles" key="help.vm.ah.cdtype"/>");
         syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name" />');
         setFormInputs();
       }
  
	</script>
   </head>
    <body onload="init();" onunload="tearDown();">
		<div class="titlebar" style="width: 505px;">
		   <table border="0" cellspacing="0" cellpadding="0">
		    <tr>
      <td width="100%"><span id="l10n_wizard_hardware_cdDvd_media_title" class="title">
         <bean:message key="wizard.hardware.cdDvd.media.title"/></span></td>
		    </tr>
		    <tr>
      <td width="100%"><span id="l10n_wizard_hardware_cdDvd_media_desc" class="subtitle">
         <bean:message key="wizard.hardware.cdDvd.media.desc"/></span></td>
		    </tr>
		   </table>
		</div>

		<div class="dialog" style="width: 505px;">
		   <html:form action="wzrdNext" method="POST">
		   <div class="window">
		      <div class="fieldset">
        <div class="legend"><span id="l10n_wizard_hardware_cdDvd_host">
        <bean:message key="wizard.hardware.cdDvd.host"/></span></div>

        <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td class="bulletCtrl"> <input type="radio" name="property(cdDvd.mediaType)"
            value="<%=Constants.CDDVD_HOST_MEDIA_PHYSICAL%>" id="hostPhysical"></td>
            <td><label class="title" ><span id="l10n_wizard_hardware_cdDvd_host_drive">
              <bean:message key="wizard.hardware.cdDvd.host.drive"/></span></label> <div class="description">
              <span id="l10n_wizard_hardware_cdDvd_host_desc">
                <bean:message key="wizard.hardware.cdDvd.host.desc"/></span></div></td>
          </tr>
          <tr>
            <td class="bulletCtrl"> <input type="radio" name="property(cdDvd.mediaType)"
            value="<%=Constants.CDDVD_HOST_MEDIA_ISO%>" id="hostISO"></td>
            <td><label class="title" ><span id="l10n_wizard_hardware_cdDvd_iso">
              <bean:message key="wizard.hardware.cdDvd.iso"/></span></label>

              <div class="description"><span id="l10n_wizard_hardware_cdDvd_iso_desc">
                <bean:message key="wizard.hardware.cdDvd.iso.desc"/></span></div></td>
          </tr>
        </table>

	<%-- If the host doesn't support, disable the client media --%>
	<c:if test="${!empty dvdView.remotePassthroughBackingOption}" >
	   <div class="legend"><span id="l10n_wizard_hardware_cdDvd_client">
	   <bean:message key="wizard.hardware.cdDvd.client"/></span></div>

	   <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
	    <tr>
	       <td class="bulletCtrl"> <input type="radio" name="property(cdDvd.mediaType)"
		value="<%=Constants.CDDVD_CLIENT_MEDIA_PHYSICAL%>" id="clientPhysical"></td>
	       <td><label class="title"><span id="l10n_wizard_hardware_cdDvd_client_physical">
		<bean:message key="wizard.hardware.cdDvd.client.physical"/></span></label>
	       <div class="description"><span id="l10n_wizard_hardware_client_physical_desc">
		<bean:message key="wizard.hardware.cdDvd.client.physical.desc"/></span></div></td>
	    </tr>
	   </table>
	</c:if>
	</div>
     </div>
   </html:form>
  </div>
 </body>
</html>