<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.wizard.Constants" %>
<%@ page import="com.vmware.webcenter.util.VMODLConstants" %>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />

<html>
<head>
<title>Wizard Table of Contents</title>
<link rel="stylesheet" href="css/default.css" type="text/css" />
<!--[if IE]>
<link href="css/default-ie.css" rel="stylesheet" type="text/css" />
<![endif]-->
<link rel="stylesheet" type="text/css" href="css/wizard/hardware.css" />

<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
   <jsp:param name="packages" value="xua" />
</jsp:include>
<%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
<script type="text/javascript" src="js/wizard/common.js"></script>

<script>
   var currentHardwareType = "<c:out value="${requestScope['deviceType']}" />";
   var currentOnClick = null;
   var currentToolTip = null;
   
   function selectHardwareType(type) {
    
      //Currently selected node's default attributes are restored
      var currentHref = document.getElementById(currentHardwareType + "_box").parentNode;
      var newHref = document.getElementById(type + "_box").parentNode;
      
      vpx.xua.setAttribute(currentHardwareType + "_box", "class", "listKeyHilite");
      vpx.xua.setAttribute(currentHardwareType + "_key", "class", "listKey");
      if(currentOnClick) {
         currentHref.ondblclick = currentHref.onclick;
         currentHref.onclick = currentOnClick;
      }
      if (currentToolTip) {
         currentHref.title = currentToolTip;
      }
      
      //New selected node is set as hilited.
      vpx.xua.setAttribute(type + "_box", "class", "listKeyHilite listKeyHilited");
      vpx.xua.setAttribute(type + "_key", "class", "listKey listKeySlctd listKeyParent");
      currentOnClick = newHref.onclick; //saving original onclick action
      newHref.onclick = newHref.ondblclick;
      if (!vpx.xua.ie) {
         /**
   	    * IE behaves differently than other browsers upon double click. It
     	    * sends one "click" event, and one "double click" event, whereas
    	    * most user agents send two "click" events and one "double click"
          * event. Thus, upon receiving a "double click" event in IE, you
          * know that to mimic other user agents, you need to send a synthetic
          * "click" event.
          */
         newHref.ondblclick = null;
      }
      currentToolTip = newHref.title;
      newHref.title = "<bean:message key="vpxbrowser.node.branch.tooltip.selected"/>";
      currentHardwareType = type;
      
      document.forms[0]["property(hardwareType.device)"].value=type;      
      tle.getWorkspacePane().workspaceDetails.wc_wizardContentsPane.syncToNextStep("hardwareType.device", type);
   }
   
   function initPage() {

      setupHelp("<bean:message bundle="helpFiles" key="help.vm.ah.type"/>");
      
      var isAnyDeviceAddable = <c:out value="${requestScope['isAnyDeviceAddable']}" />;      
      if (!isAnyDeviceAddable) {
         tle.getWorkspacePane().workspaceDetails.wc_wizardContentsPane.setNextEnabled(false);
         tle.getWorkspacePane().workspaceDetails.wc_wizardContentsPane.setBackEnabled(false);
         return;
      }    
      
      syncContentsToStep('<bean:write name="<%= Constants.STEP_KEY %>" property="name" />');  
            
      var value = "<c:out  value = "${wizard.form.data['hardwareType.device']}"/>";      
      if (value != null && value.length > 0) {        
         selectHardwareType(value);
      } else {
         selectHardwareType('disk');
      }
      
      selfCheckList();         
   }
   
   function tearDown() {
      resetHelp();
   }

   /**
    * This is a workaround for BUG 95807-  Random device links appear blue and misbehave
    * For some reason, sometimes extra "<a>" tags are generated above and below the hardware names.
    * These <a> tags have nothing in between the open and closing </a>.
    * This workaround looks for these misplaced <a> sets, and reloads the page if any are detected.
    */
   function selfCheckList() {
      var hardwareContainer = document.getElementById("contents");      
      var links = hardwareContainer.getElementsByTagName("a");
      for (i = 0; i < links.length; i++ ) {
         if (!links[i].getElementsByTagName("div")[0]) {
            document.location.reload();
         }
      }
      
   }
   
   function handleNext() {
      var form = tle.getWorkspacePane().workspaceDetails.wc_wizardWorkspacePane.document.forms[0];
      form.submit();
   }  
   onload = initPage;
</script>
</head>

<body onload="initPage();" onunload="tearDown();">

   <div class="titlebar" style="width: 505px;">
      <table border="0" cellspacing="0" cellpadding="0">
         <tr>
            <td width="100%"><span class="title" id="wizard_hardware_devices_name"><bean:message key="wizard.hardware.devices.name"/></span></td>
         </tr>
         <tr>
            <td width="100%"><span class="subtitle" id="wizard_hardware_devices_desc"><bean:message key="wizard.hardware.devices.desc"/></span></td>
         </tr>
      </table>
   </div>
   
   <div class="dialog" style="width: 505px;">
      <html:form action="wzrdNext" method="POST">
         <input type="hidden" id="hardwareType" name="property(hardwareType.device)" value="disk"/>
         <div class="window">        
                     
         <c:forEach var = 'map' items = '${wizard.viewMap}'>
            <c:if test = "${map.key eq 'hardwareView'}">
               <c:set var = "hardwareView" value = "${map.value}"/>
           </c:if>
         </c:forEach>
            
            <div class="legendIntro">
               <span id="wizard_hardware_devices_selection">
                  <bean:message key="wizard.hardware.devices.selection"/>
               </span>
            </div>
            
            <div id="contents" class="fieldset listbox">
               <table class="listView deviceList" border="0" cellspacing="0" cellpadding="0">
                  <colgroup>
                     <col /> <col style="width:100%;" />
                  </colgroup>
                 
                  <%--  Virtual Disk  --%>
                  <c:choose>
                     <c:when test="${!hardwareView.hardDiskAddable}">
                        <tr>
                           <td class="lcol listKeyIcon"><div class="virtualDisk-16x16 icon" /></td>
                           <td>
                              <span class="subtitle" id="110n_wizard_hardware_device_harddisk">
                                 <bean:message key="wizard.hardware.device.harddisk"/>
                              </span>
                              <c:out value="${hardwareView.messages['hardDiskMessage']}" />
                           </td>
                        </tr>
                     </c:when>
                     
                     <c:otherwise>
                        <tr>
                           <td class="lcol listKeyIcon"><div class="virtualDisk-16x16 icon" /></td>
                           <td class="listKey"> 
                              <a href="#" onclick="selectHardwareType('disk');" ondblclick="handleNext();" 
                                 title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>">
                                 <div id="disk_box" class="listKeyHilite listKeyHilited">
                                    <div id="disk_key" class="listKey listKeySlctd">
                                       <span id="110n_wizard_hardware_device_harddisk">
                                          <bean:message key="wizard.hardware.device.harddisk"/>
                                       </span>
                                    </div>
                                 </div>
                              </a>
                           </td>
                        </tr>
                     </c:otherwise>
                  </c:choose>
                  
                  <%-- Ethernet Card --%>
                  <c:choose>
                     <c:when test="${!hardwareView.ethernetCardAddable}">
                        <tr>
                           <td class="lcol listKeyIcon"><div class="networkAdapter-16x16 icon" /></td>
                           <td>
                              <span class="subtitle" id="110n_wizard_hardware_device_nic">
                                 <bean:message key="wizard.hardware.device.nic"/>
                              </span>
                              <c:out value="${hardwareView.messages['ethernetCardMessage']}" />
                           </td>
                        </tr>
                     </c:when>
                     
                     <c:otherwise>
                        <tr>
                           <td class="lcol listKeyIcon"><div class="networkAdapter-16x16 icon" /></td>
                           <td class="listKey">
                              <a href="#" onclick="selectHardwareType('nic');" ondblclick="handleNext();"
                                 title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>">
                                 <div  id="nic_box" class="listKeyHilite">
                                    <div id="nic_key" class="listKey">
                                       <span id="110n_wizard_hardware_device_nic">
                                          <bean:message key="wizard.hardware.device.nic"/>
                                       </span>
                                    </div>
                                 </div>
                              </a>
                           </td>
                        </tr>
                     </c:otherwise>
                  </c:choose>
                  
                  <%-- Cd/Dvd --%>
                  <c:choose>
                     <c:when test="${!hardwareView.cddvdAddable}">
                        <tr>
                           <td class="lcol listKeyIcon"><div class="cdDvdDrive-16x16 icon" /></td>
                           <td>
                              <span class="subtitle" id="110n_wizard_hardware_device_cdDvd">
                                 <bean:message key="wizard.hardware.device.cdDvd"/>
                              </span>
                              <c:out value="${hardwareView.messages['cdDvdMessage']}" />
                            </td>
                        </tr>
                     </c:when>
                     
                     <c:otherwise>
                        <tr>
                           <td class="lcol listKeyIcon"><div class="cdDvdDrive-16x16 icon" /></td>
                           <td class="listKey">
                              <a href="#" onclick="selectHardwareType('dvd');" ondblclick="handleNext();"
                                 title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>">
                                 <div id="dvd_box" class="listKeyHilite">
                                    <div id="dvd_key" class="listKey">
                                       <span id="110n_wizard_hardware_device_cdDvd">
                                          <bean:message key="wizard.hardware.device.cdDvd"/>
                                       </span>
                                    </div>
                                 </div>
                              </a>
                           </td>
                        </tr>
                     </c:otherwise>
                  </c:choose>
                  
                  <%-- Floppy --%>
                  <c:choose>
                     <c:when test="${!hardwareView.floppyAddable}">
                        <tr>
                           <td class="lcol listKeyIcon"><div class="floppyDrive-16x16 icon" /></td>
                           <td>
                              <span class="subtitle" id="110n_wizard_hardware_device_floppy">
                                 <bean:message key="wizard.hardware.device.floppy"/>
                              </span>
                              <c:out value="${hardwareView.messages['floppyMessage']}" />
                           </td>
                        </tr>
                     </c:when>
                     
                     <c:otherwise>
                        <tr>
                           <td class="lcol listKeyIcon"><div class="floppyDrive-16x16 icon" /></td>
                           <td class="listKey">
                              <a href="#" onclick="selectHardwareType('floppy');" ondblclick="handleNext();"
                                 title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>">
                                 <div id="floppy_box" class="listKeyHilite">
                                    <div id="floppy_key" class="listKey">
                                       <span id="110n_wizard_hardware_device_floppy">
                                          <bean:message key="wizard.hardware.device.floppy"/>
                                       </span>
                                    </div>
                                 </div>
                              </a>
                           </td>
                        </tr>
                     </c:otherwise>
                  </c:choose>
                  
                  <%-- Serial Port --%>
                  <c:choose>
                     <c:when test="${!hardwareView.serialPortAddable}">
                        <tr>
                           <td class="lcol listKeyIcon"><div class="serialPort-16x16 icon" /></td>
                           <td>
                              <span class="subtitle" id="110n_wizard_hardware_device_serialPort">
                                 <bean:message key="wizard.hardware.device.serialPort"/>
                              </span>
                              <c:out value="${hardwareView.messages['serialPortMessage']}" />
                           </td>
                        </tr>
                     </c:when>
                     
                     <c:otherwise>
                        <tr>
                           <td class="lcol listKeyIcon"><div class="serialPort-16x16 icon" /></td>
                           <td class="listKey">
                              <a href="#" onclick="selectHardwareType('serial');" ondblclick="handleNext();"
                                 title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>">
                                 <div id="serial_box" class="listKeyHilite">
                                    <div id="serial_key" class="listKey">
                                       <span id="110n_wizard_hardware_device_serialPort">
                                          <bean:message key="wizard.hardware.device.serialPort"/>
                                       </span>
                                    </div>
                                 </div>
                              </a>
                           </td>
                        </tr>
                     </c:otherwise>
                  </c:choose>
                  
                  <%-- Parallel Port --%>
                  <c:choose>
                     <c:when test="${!hardwareView.parallelPortAddable}">
                        <tr>
                           <td class="lcol listKeyIcon"><div class="parallelPort-16x16 icon" /></td>
                           <td>
                              <span class="subtitle" id="110n_wizard_hardware_device_parallelPort">
                                 <bean:message key="wizard.hardware.device.parallelPort"/>
                              </span>
                              <c:out value="${hardwareView.messages['parallelPortMessage']}" />
                           </td>
                        </tr>
                     </c:when>
                     
                     <c:otherwise>
                        <tr>
                           <td class="lcol listKeyIcon"><div class="parallelPort-16x16 icon" /></td>
                           <td class="listKey">
                              <a href="#" onclick="selectHardwareType('parallel');" ondblclick="handleNext();"
                                 title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>">
                                 <div id="parallel_box" class="listKeyHilite">
                                    <div id="parallel_key" class="listKey">
                                       <span id="110n_wizard_hardware_device_parallelPort">
                                          <bean:message key="wizard.hardware.device.parallelPort"/>
                                       </span>
                                    </div>
                                 </div>
                              </a>
                           </td>
                        </tr>
                     </c:otherwise>
                  </c:choose>
                  
                  <%-- SCSI passthrough --%>                  
                     <c:choose>
                        <c:when test="${!hardwareView.SCSIPassthroughAddable}">
                           <tr>
                              <td class="lcol listKeyIcon"><div class="scsiDevice-16x16 icon" /></td>
                              <td>
                                 <span class="subtitle" id="110n_wizard_hardware_device_passthrough">
                                    <bean:message key="wizard.hardware.device.passthrough"/>
                                 </span>
                                  <c:out value="${hardwareView.messages['scsiPassthroughMessage']}" />                            
                              </td>
                           </tr>
                        </c:when>
                        
                        <c:otherwise>
                           <tr>
                              <td class="lcol listKeyIcon"><div class="scsiDevice-16x16 icon" /></td>
                              <td class="listKey">
                                 <a href="#" onclick="selectHardwareType('scsi');" ondblclick="handleNext();"
                                    title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>">
                                    <div id="scsi_box" class="listKeyHilite">
                                       <div id="scsi_key" class="listKey">
                                          <span id="110n_wizard_hardware_device_passthrough">
                                             <bean:message key="wizard.hardware.device.passthrough"/>
                                          </span>
                                       </div>
                                    </div>
                                 </a>
                              </td>
                           </tr>
                        </c:otherwise>
                     </c:choose>
                  
                
               </table>
            </div>
         </div>         
      </html:form>
   </div>
</body>
</html>




