<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.wizard.Constants" %>
<%@ page import="com.vmware.webcenter.util.VMODLConstants" %>
<c:set var="INDEPENDENT_MODE" value="<%= com.vmware.webcenter.view.viewhelper.Constants.INDEPENDENT_PERSISTENT_DISKMODE %>" scope="page" />
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css" />
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css" />

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,gui,browser,win,drag" />
      </jsp:include>
      
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      
      <script type="text/javascript" src="js/wizard/common.js"></script>

      <script type="text/javascript" src="js/wizard/hardware.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>
      <script type="text/javascript">

      function init() {
     
       initHelp('disk');
     
       <c:if test="${!wizard.form.valid}">
          handleValidationDialog(tle.getWorkspacePane());
       </c:if>
       
      <c:if test="${requestScope[INDEPENDENT_MODE]}" >                  
          toggleIndp();
      </c:if> 
             
        toggleCompatibility();     
             
      }
      function toggleCompatibility() {

          var o = document.getElementById("physicalCompatibility");
          if (o == null) {
            return;
          }
      
           var boolPhysical = o.checked;           
         
           <c:choose>
              <c:when test="${requestScope[INDEPENDENT_MODE]}" >
                 toggleDiskModesIndependent(boolPhysical);
              </c:when>
              <c:otherwise>
                 toggleDiskModesPreIndependent(boolPhysical);
              </c:otherwise>
           </c:choose> 
           
           if (!boolPhysical) {
              toggleIndp();         
           }    
        }
        
      function toggleDiskModesIndependent(boolPhysical) {
          
           document.getElementById("independent").disabled = boolPhysical;
           document.getElementById("l10n_vmConfiguration_hd_diskMode").className = (!boolPhysical) ? "" : "disabled";
           document.getElementById("l10n_vmConfiguration_hd_diskMode_independent_label").className = (!boolPhysical) ? "" : "disabled";
           document.getElementById("l10n_vmConfiguration_hd_diskMode_independent_desc").className = (!boolPhysical) ? "" : "disabled";
                      
           document.getElementById("persistent").disabled = boolPhysical
           document.getElementById("nonPersistent").disabled = boolPhysical
          
           document.getElementById("l10n_vmConfiguration_hd_diskMode_persistent_label").className = (!boolPhysical) ? "" : "disabled";
           document.getElementById("l10n_vmConfiguration_hd_diskMode_persistent_desc").className = (!boolPhysical) ? "" : "disabled";

           document.getElementById("l10n_vmConfiguration_hd_diskMode_nonPersistent_label").className = (!boolPhysical) ? "" : "disabled";
           document.getElementById("l10n_vmConfiguration_hd_diskMode_nonPersistent_desc").className = (!boolPhysical) ? "" : "disabled";
      }
      
       function toggleDiskModesPreIndependent(boolPhysical) {
           
           document.getElementById("persistent").disabled = boolPhysical
           document.getElementById("nonPersistent").disabled = boolPhysical           
           document.getElementById("undoable").disabled = boolPhysical
           document.getElementById("append").disabled = boolPhysical
          
           document.getElementById("l10n_vmConfiguration_hd_diskMode_persistent_label").className = (!boolPhysical) ? "" : "disabled";
           document.getElementById("l10n_vmConfiguration_hd_diskMode_persistent_desc").className = (!boolPhysical) ? "" : "disabled";

           document.getElementById("l10n_vmConfiguration_hd_diskMode_nonPersistent_label").className = (!boolPhysical) ? "" : "disabled";
           document.getElementById("l10n_vmConfiguration_hd_diskMode_nonPersistent_desc").className = (!boolPhysical) ? "" : "disabled";
           
           document.getElementById("l10n_vmConfiguration_hd_diskMode_undoable_label").className = (!boolPhysical) ? "" : "disabled";
           document.getElementById("l10n_vmConfiguration_hd_diskMode_undoable_desc").className = (!boolPhysical) ? "" : "disabled";

           document.getElementById("l10n_vmConfiguration_hd_diskMode_append_label").className = (!boolPhysical) ? "" : "disabled";
           document.getElementById("l10n_vmConfiguration_hd_diskMode_append_desc").className = (!boolPhysical) ? "" : "disabled";           
        }
     </script>
   </head>
   <body onload="init();syncContentsToStep('<bean:write name="<%= Constants.STEP_KEY %>" property="name" />');" onunload="tearDown();">
			<div class="titlebar" style="width: 505px;">
			   <table border="0" cellspacing="0" cellpadding="0">
			      <tr>
				      <td width="100%"><span id="l10n_wizard_hardware_diskOptions_title" class="title">
				       <bean:message key="wizard.hardware.diskOptions.title"/></span></td>
			      </tr>
			      <tr>
				       <td width="100%"><span id="l10n_wizard_hardware_diskOptions_title_desc" class="subtitle">
				       <bean:message key="wizard.hardware.diskOptions.title.desc" /></span></td>
			      </tr>
			   </table>
			</div>
			<div class="dialog" style="width: 505px;">
      <html:form action="wzrdNext" method="POST">

	     <c:forEach var='map' items='${wizard.viewMap}'>
                <c:if test="${map.key eq 'diskView'}">
                   <c:set var="diskView" value="${map.value}"/>
                </c:if>
             </c:forEach>

	   	<c:set var='diskType' value="${wizard.form.data['diskSelection.type']}" />

       <div class="window">

		      <div class="fieldset">
             <div class="legend"><span id="l10n_wizard_hardware_diskOptions_virtualDevice">
             <bean:message key="wizard.hardware.diskOptions.virtualDevice" /></span></div>
             <table width="50%" border="0" cellspacing="0" cellpadding="0">
             <tr>
             <td width="50%"><span id="l10n_wizard_hardware_diskOptions_scsiNode">
             <bean:message key="wizard.hardware.diskOptions.scsiNode" /></td>
             <td width="25%">
			 
             <c:set var="aNode" value="${diskView.availableScsiNode}"/>
             <html:select property="property(diskOptions.scsiNode)">
                <c:forEach var="node" items="${diskView.scsiNodes}">
                    <html:option value="${node.used}:${node.ctrlrBusNum}:${node.deviceUnitNum}:${node.ctrlrKey}" >
			           <c:out value='${node.ctrlrBusNum}'/>:<c:out value='${node.deviceUnitNum}'/> <c:out value='${node.deviceName}'/>
		            </html:option>
                </c:forEach>
              </html:select></td>
             </tr>
            </table>
           </div>

           <c:if test="${diskType == 'mappedDisk'}" >
		<div class="fieldset">
		  <div class="fieldset">
	             <div class="legend"><span id="l10n_wizard_hardware_diskOptions_compatibility">
	             <bean:message key="wizard.hardware.diskOptions.compatibility" /></span></div>
	             <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
	         	    <tr>
	                 <td class="bulletCtrl"><html:radio property="property(diskOptions.compatibility)"
	                  styleId="physicalCompatibility" styleClass="radioCtrl" value="<%=VMODLConstants.VIRTUALDISKCOMPATIBILITYMODE_PHYSICALMODE%>"
	                  onclick="javascript:toggleCompatibility();"/></td>
	                 <td><label class="title" for="physicalCompatibility">
	                      <span id="l10n_wizard_hardware_diskOptions_compatibility_physical">
	                      <bean:message key="wizard.hardware.diskOptions.compatibility.physical" /></span></label>
	                      <div class="description"><span id="l10n_wizard_hardware_diskOptions_compatibility_physical_desc">
	                      <bean:message key="wizard.hardware.diskOptions.compatibility.physical.desc" /></span></div>
	                 </td>
	              </tr>
	              <tr>
	                <td class="bulletCtrl"><html:radio property="property(diskOptions.compatibility)"
	                    styleId="virtualCompatibility" styleClass="radioCtrl" value="<%=VMODLConstants.VIRTUALDISKCOMPATIBILITYMODE_VIRTUALMODE%>"
	                    onclick="javascript:toggleCompatibility();"/></td>
	                <td><label class="title" for="virtualCompatibility">
	                	   <span id="l10n_wizard_hardware_diskOptions_compatibility_virtual">
	                     <bean:message key="wizard.hardware.diskOptions.compatibility.virtual" /></span></label>
	                     <div class="description"><span id="l10n_wizard_hardware_diskOptions_compatibility_virtual_desc">
	                     <bean:message key="wizard.hardware.diskOptions.compatibility.virtual.desc" /></span></div>
	                 </td>
	               </tr>
	              </table>
	            </div>
	         </div>
	     </c:if>

            <!-- disk mode -->
           	<div class="fieldset" id="fsDiskMode">
			      <div class="legend">
			        <span id="l10n_vmConfiguration_hd_diskMode">
			        <bean:message key="vmConfiguration.hd.diskMode"/>
			      	</span>
			      </div>
			    			                  
              <%-- Include diskModes --%>  
              <c:choose>
                <c:when test="${requestScope[INDEPENDENT_MODE]}" >
                   <%@ include file="diskModesIndependent.jsp" %>
                </c:when>
                <c:otherwise>
                  <%@ include file="diskModesPreIndependent.jsp" %>
                </c:otherwise>
				  </c:choose>
				  </div>
				  <html:hidden property="property(diskOptions.independent_mode)" value="${requestScope[INDEPENDENT_MODE]}"/>
         </div>
       </html:form>
		  </div>
		</body>
</html>




