<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.wizard.Constants" %>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />
<c:set var='diskType' value="${wizard.form.data['diskSelection.type']}"/>
<c:forEach var = 'map' items = '${wizard.viewMap}'>
   <c:if test = "${map.key eq 'diskView'}">
       <c:set var = "diskView" value = "${map.value}"/>
   </c:if>
</c:forEach>
<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css" />
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css" />

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,gui,browser,win,drag" />
      </jsp:include>
      
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      
      <script type="text/javascript" src="js/wizard/common.js"></script>

      <script type="text/javascript" src="js/wizard/datastore.js"></script>
      <script type="text/javascript" src="js/wizard/hardware.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>
      <script type="text/javascript">

	  function respond() {
	    if (this.selectedItem != null) {
	      document.getElementById("dataStorePath").value=this.selectedItem;
	    }
            if (!isNull(this.freespace)) {
               var text = "<bean:message key="vmDetails.tab.summary.related.datastores.free"/>";
               document.getElementById("freespace").value=this.freespace + "  " + text;
            }
	  }

     function init() {

       initHelp('disk');
       
       <c:if test="${!wizard.form.valid}">
          handleValidationDialog(tle.getWorkspacePane());
       </c:if>

       <c:if test="${!empty diskView.defaultDatastoreSummary}">
          toggleDatastore();
       </c:if>
     }

      </script>
   </head>

   <body onload="init();syncContentsToStep('<bean:write name="<%= Constants.STEP_KEY %>" property="name" />');" onunload="tearDown();">

		<div class="titlebar" style="width: 505px;">
		   <table border="0" cellspacing="0" cellpadding="0">
		   <c:if test="${diskType == 'newDisk'}" >
			  <tr>
			  <td width="100%"><span id="l10n_wizard_hardware_diskCapacity_title" class="title">
			  <bean:message key="wizard.hardware.diskCapacity.title"/></span></td>
			  </tr>
			  <tr>
			  <td width="100%"><span id="l10n_wizard_hardware_diskCapacity_title_desc" class="subtitle">
			   <bean:message key="wizard.hardware.diskCapacity.title.desc"/></span></td>
			  </tr>
			  </c:if>
			  <c:if test="${diskType == 'mappedDisk'}">
			  <tr>
			  <td width="100%"><span id="l10n_wizard_hardware_diskCapacity_RDM_title" class="title">
			  <bean:message key="wizard.hardware.diskCapacity.RDM.title"/></span></td>
			  </tr>
			  <tr>
			  <td width="100%"><span id="l10n_wizard_hardware_diskCapacity_RDM_title_desc" class="subtitle">
			   <bean:message key="wizard.hardware.diskCapacity.RDM.title.desc"/></span></td>
			  </tr>
			  </c:if>
		   </table>
		</div>
		<div class="dialog" style="width: 505px;">
	  <html:form action="wzrdNext" method="POST">

	  	<div class="window">

			 <c:if test="${diskType == 'newDisk'}" >
			    <div class="fieldset">
		        <div class="legend"><span id="l10n_wizard_hardware_diskCapacity_name">
		        <bean:message key="wizard.hardware.diskCapacity.name"/></span></div>
				  	<table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
							<tr>
							  <td><span id="l10n_wizard_hardware_diskCapacity_size">
							  <bean:message key="wizard.hardware.diskCapacity.size"/></span></td>
							  <td>
							  <html:text property="property(diskCapacity.size)" styleClass="text numericTextInput"/>
							  </td>
							  <td>&nbsp;</td>
							  <td>
							   <html:select property="property(diskCapacity.units)">
								  <html:option value="MB"><bean:message key="wizard.hardware.diskCapacity.size.MB"/></html:option>
								  <html:option value="GB"><bean:message key="wizard.hardware.diskCapacity.size.GB"/></html:option>
							   </html:select>
							  </td>
							</tr>
				  	</table>
		      </div>
	      </c:if>
	      <div class="fieldset">
	      	<div class="legend"><span id="l10n_wizard_hardware_diskCapacity_location">
	      	<bean:message key="wizard.hardware.diskCapacity.location"/></span></div>
	        <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
	        <c:choose>
	        <c:when test="${!empty diskView.defaultDatastoreSummary}">
				  	<tr>
				    	<td class="bulletCtrl">
				    	<html:radio property="property(diskCapacity.datastore)" value="vmDataStore" styleId="vmDataStore" styleClass="radioCtrl" onclick="toggleDatastore();"/></td>
						  <td colspan="3">
						     <label class="title" ><span id="l10n_wizard_hardware_diskCapacity_vmDatastore">
						     <bean:message key="wizard.hardware.diskCapacity.vmDatastore"/></span></label>
						     <div class="description"><span id="l10n_wizard_hardware_diskCapacity_vmDatastore_desc">
						     <bean:message key="wizard.hardware.diskCapacity.vmDatastore.desc"/></span></div>
				      </td>
					 </tr>
					 <tr>
					    <td></td><td><bean:message key="wizard.hardware.diskCapacity.default.datastore.name"/></td>
					    <td colspan="2">&nbsp;&nbsp;<c:out value="${diskView.defaultDatastoreSummary.name}"/></td>
					 </tr>
					 <tr>
					    <td></td><td><bean:message key="wizard.hardware.diskCapacity.default.datastore.capacity"/></td>
					    <td colspan="2">&nbsp;&nbsp;<c:out value="${diskView.defaultDatastoreSummary.capacityInGB}"/></td>
					 </tr>
					 <tr>
					    <td></td><td><bean:message key="wizard.hardware.diskCapacity.default.datastore.freespace"/></td>
					    <td colspan="2">&nbsp;&nbsp;<c:out value="${diskView.defaultDatastoreSummary.freespaceInGB}"/></td>
					 </tr>
					 <tr><td colspan="2">&nbsp;&nbsp;</td></tr>
				    <tr>
				      <td class="bulletCtrl">
				      <html:radio property="property(diskCapacity.datastore)" value="specificDataStore" styleId="specificDataStore" styleClass="radioCtrl" onclick="toggleDatastore();"/></td>
						  <td colspan="3">
						    <label class="title"><span id="l10n_wizard_hardware_diskCapacity_speficDatastore">
						    <bean:message key="wizard.hardware.diskCapacity.specificDatastore"/></span></label>
						    <div class="description"><span id="l10n_wizard_hardware_diskCapacity_speficDatastore_desc">
						    <bean:message key="wizard.hardware.diskCapacity.specificDatastore.desc"/></span></div>
				      </td>
				    </tr>
					  <tr>
					     <td>&nbsp;</td>
					     <td><span id="l10n_wizard_hardware_diskCapacity_datastore">
						<bean:message key="wizard.hardware.diskCapacity.datastore"/></span></td>
					     <td>&nbsp;
					     <html:text property="property(diskCapacity.dataStorePath)" styleId="dataStorePath"
						   style="width:250px;position:relative;" /></td>


               <td>
               <a href="#" id="browse" name="browse" class="browse"
                 onclick="handleOpenDialog('<%= com.vmware.webcenter.view.viewhelper.Constants.NEW_DISK_DATASTORE_BROWSER %>', tle.getWorkspacePane()); return false;">
                 <span id="l10n_vmConfiguration_browse">
		    <bean:message key="vmConfiguration.browse"/>
		 </span></td>
					  </tr>
					  <tr>
					     <td>&nbsp;</td>
					     <td>&nbsp;</td>

					     <td><span id="l10n_wizard_hardware_diskCapacity_datastore_freespace">
								&nbsp;&nbsp;<html:text styleId="freespace" property="property(diskCapacpity.freespace)" style="border:0px;"/>
								</span>
						</td>
					  </tr>
                      </c:when>
                      <c:otherwise>
                      <tr>
                         <td class="bulletCtrl" colspan="2">
                            <div class="description"><span id="l10n_wizard_hardware_diskCapacity_speficDatastore_desc">
                            <bean:message key="wizard.hardware.diskCapacity.specificDatastore.desc"/></span></div>
                          </td>
                       </tr>
                       <tr>
                          <td><span id="l10n_wizard_hardware_diskCapacity_datastore">
                          <bean:message key="wizard.hardware.diskCapacity.datastore"/></span></td>
                          <td>&nbsp;
                            <html:text property="property(diskCapacity.dataStorePath)" styleId="dataStorePath"
                              style="width:250px;position:relative;" /></td>

                          <td>
                            <a href="#" id="browse" name="browse" class="browse"
                             onclick="handleOpenDialog('datastore', tle.getWorkspacePane()); return false;">
                            <span id="l10n_vmConfiguration_browse">
                               <bean:message key="vmConfiguration.browse"/>
                             </span>
                          </td>
                       </tr>
                       <tr>
                         <td>&nbsp;</td>
                         <td><span id="l10n_wizard_hardware_diskCapacity_datastore_freespace">
                            &nbsp;&nbsp;<html:text styleId="freespace" property="property(diskCapacpity.freespace)" style="border:0px;"/>
                             </span>
                         </td>
                        </tr>
                          <html:hidden property="property(diskCapacity.datastore)" value="specificDataStore"/>
                       </c:otherwise>
                      </c:choose>
				  </table>
	      </div>
	    </div>
	    </html:form>
		 </div>
		</body>
</html>




