<%@ include file = "/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import = "com.vmware.webcenter.wizard.Constants"%>
<%@ page import = "com.vmware.webcenter.util.VMODLConstants"%>
<c:set var = "WIZARDVO_KEY" value = "<%= Constants.WIZARDVO_KEY %>" scope = "page"/>
<c:set var = "wizard" value = "${sessionScope[WIZARDVO_KEY]}" scope = "page"/>
<c:set var = "PHYSICAL_COMPATABILITY" value = "<%= VMODLConstants.VIRTUALDISKCOMPATIBILITYMODE_PHYSICALMODE %>"   scope = "page"/>
<c:set var = "VIRTUAL_COMPATABILITY" value = "<%= VMODLConstants.VIRTUALDISKCOMPATIBILITYMODE_VIRTUALMODE %>"  scope = "page"/>

<html>
    <head>
        <link rel = "stylesheet" href = "css/default.css" type = "text/css"/>
        <!--[if IE]>
        <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
        <![endif]-->
        <link rel = "stylesheet" type = "text/css" href = "css/wizard/hardware.css"/>

        <%@ include file = "/WEB-INF/jsp/common/commonJs.jsp"%>
        <jsp:include page = "/WEB-INF/jsp/common/vpxJs.jsp">
            <jsp:param name = "packages" value = "xua"/>
        </jsp:include>
        
        <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
        <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      
        <script type = "text/javascript" src = "js/wizard/common.js">
        </script>
    </head>

    <body onload = "syncContentsToStep('<bean:write name="<%= Constants.STEP_KEY %>" property="name" />');initHelp('disk');" onunload="tearDown();">
        <div class = "titlebar" style = "width: 505px;">
            <table border = "0" cellspacing = "0" cellpadding = "0">
                <tr>
                    <td width = "100%">
                        <span id = "l10n_wizard_hardware_diskConfirmation_title" class = "title">
                        <bean:message key = "wizard.hardware.diskConfirmation.title"/></span>
                    </td>
                </tr>

                <tr>
                    <td width = "100%">
                        <span id = "l10n_wizard_hardware_diskConfirmation_title_desc" class = "subtitle">
                        <bean:message key = "wizard.hardware.diskConfirmation.title.desc"/></span>
                    </td>
                </tr>
            </table>
        </div>

        <div class = "dialog" style = "width: 505px;">
            <html:form action = "wzrdNext" method = "POST">
                <c:forEach var = 'map' items = '${wizard.viewMap}'>
                    <c:if test = "${map.key eq 'diskView'}">
                        <c:set var = "diskView" value = "${map.value}"/>
                    </c:if>
                </c:forEach>

                <div class = "window">
                    <div class = "fieldset">
                        <span class = "legend" id = "l10n_wizard_hardware_diskConfirmation_device_info">
                        <bean:message key = "wizard.hardware.diskConfirmation.device.info"/></span>

                        <table width = "100%" border = "0" cellspacing = "0" cellpadding = "0">
                            <tr>
                                <td>
                                    <span id = "l10n_wizard_hardware_diskConfirmation_hardware_type">
                                    <bean:message key = "wizard.hardware.diskConfirmation.hardware.type"/></span>
                                </td>

                                <td>
                                    <span id = "l10n_wizard_hardware_diskConfirmation_hardware_disk">
                                    <bean:message key = "wizard.hardware.diskConfirmation.hardware.disk"/></span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <span id = "l10n_wizard_hardware_diskConfirmation_disk_type">
                                    <bean:message key = "wizard.hardware.diskConfirmation.disk.type"/></span>
                                </td>

                                <td>
                                    <c:set var = 'diskType' value = "${wizard.form.data['diskSelection.type']}"/>

                                    <c:if test = "${diskType == 'newDisk'}">
                                        <span id = "l10n_wizard_hardware_diskConfirmation_newDisk">
                                        <bean:message key = "wizard.hardware.diskConfirmation.newDisk"/></span>
                                    </c:if>

                                    <c:if test = "${diskType == 'existingDisk'}">
                                        <span id = "l10n_wizard_hardware_diskConfirmation_existingDisk">
                                        <bean:message key = "wizard.hardware.diskConfirmation.existingDisk"/></span>
                                    </c:if>

                                    <c:if test = "${diskType == 'mappedDisk'}">
                                        <span id = "l10n_wizard_hardware_diskConfirmation_mappedLUN">
                                        <bean:message key = "wizard.hardware.diskConfirmation.mappedLUN"/></span>
                                    </c:if>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <span id = "l10n_wizard_hardware_diskConfirmation_capacity">
                                    <bean:message key = "wizard.hardware.diskConfirmation.capacity"/></span>
                                </td>

                                <td>
                                    <c:if test = "${diskType == 'newDisk'}">
                                        <bean:message key = "common.diskCapacity.size.var${wizard.form.data['diskCapacity.units']}" arg0 = "${wizard.form.data['diskCapacity.size']}"/>
                                    </c:if>
                                    <c:if test = "${diskType == 'existingDisk'}">
                                        <c:out value = "${wizard.form.data['existingDisk.diskSize']}"/>
                                    </c:if>
                                    <c:if test = "${diskType == 'mappedDisk'}">
                                        <bean:message key = "common.diskCapacity.size.varGB" arg0 = "${wizard.form.data['lun.capacity']}"/>
                                    </c:if>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <c:if test = "${diskType == 'newDisk'}">
                                        <span id = "l10n_wizard_hardware_diskConfirmation_location">
                                        <bean:message key = "wizard.hardware.diskConfirmation.location"/></span>
                                    </c:if>

                                    <c:if test = "${diskType == 'existingDisk'}">
                                        <span id = "l10n_wizard_hardware_diskConfirmation_existingDisk_location">
                                        <bean:message key = "wizard.hardware.diskConfirmation.existingDisk.location"/></span>
                                    </c:if>

                                    <c:if test = "${diskType == 'mappedDisk'}">
                                        <span id = "l10n_wizard_hardware_diskConfirmation_mappedDisk_location">
                                        <bean:message key = "wizard.hardware.diskConfirmation.mappedDisk.location"/></span>
                                    </c:if>
                                </td>

                                <td>
				<c:if test = "${diskType == 'newDisk'}">
				   <c:set var = 'datastore' value = "${wizard.form.data['diskCapacity.datastore']}"/>
					  <c:if test = "${datastore == 'vmDataStore'}">
						 <c:out value = "${diskView.defaultDatastoreSummary.name}"/>
					  </c:if>
					  <c:if test = "${datastore == 'specificDataStore'}">
						 <c:out value = "${wizard.form.data['diskCapacity.dataStorePath']}"/>
					  </c:if>
				</c:if>
				<c:if test = "${diskType == 'existingDisk'}">
				   <c:out value = "${wizard.form.data['existingDisk.fileName']}"/>
				</c:if>
				<c:if test = "${diskType == 'mappedDisk'}">
				   <c:out value = "${wizard.form.data['lun.canonicalName']}"/>
				</c:if>
                                </td>
                            </tr>

                            <c:if test = "${diskType == 'mappedDisk'}">
                                <tr>
                                    <td>
                                        <span id = "l10n_wizard_hardware_diskConfirmation_mappedDisk_RDMlocation">
                                        <bean:message key = "wizard.hardware.diskConfirmation.mappedDisk.RDMlocation"/></span>
                                    </td>

                                    <td>
                                        <c:set var = 'datastore'  value = "${wizard.form.data['diskCapacity.datastore']}"/>

                                        <c:if test = "${datastore == 'vmDataStore'}">
                                            <bean:message key = "wizard.hardware.virtualDisk.mappedLUN.vm.datastore"/>
                                        </c:if>

                                        <c:if test = "${datastore == 'specificDataStore'}">
                                            <c:out value = "${wizard.form.data['diskCapacity.dataStorePath']}"/>
                                        </c:if>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <span id = "l10n_wizard_hardware_diskConfirmation_mappedDisk_compatibility">
                                        <bean:message key = "wizard.hardware.diskConfirmation.mappedDisk.compatibility"/>
                                    </td>

                                    <td>
                                        <c:set var = "compatability" value = "${wizard.form.data['diskOptions.compatibility']}"/>

                                        <c:choose>
                                            <c:when test = "${compatability == PHYSICAL_COMPATABILITY}">
                                                <bean:message key = "wizard.hardware.diskOptions.compatibility.physical"/>
                                            </c:when>

                                            <c:otherwise>
                                                <bean:message key = "wizard.hardware.diskOptions.compatibility.virtual"/>
                                            </c:otherwise>
                                        </c:choose>
                                    </td>
                                </tr>
                            </c:if>

                            <tr>
                                <td>
                                    <span id = "l10n_wizard_hardware_diskConfirmation_mode">
                                    <bean:message key = "wizard.hardware.diskConfirmation.mode"/></span>
                                </td>

                                <td>                                 
                                    <c:choose>
                                        <c:when test = "${wizard.form.data['diskOptions.independent_mode']}">
                                            <c:choose>
                                            <c:when test = "${!wizard.form.data['diskOptions.independent']}">
                                              <bean:message key = "wizard.hardware.diskConfirmation.snapshotMode"/>
                                            </c:when>
                                            <c:otherwise>
                                            <c:if test = "${wizard.form.data['diskOptions.diskMode'] == 'independent_persistent'}">
                                                <bean:message key = "wizard.hardware.diskConfirmation.persistentMode"/>
                                            </c:if>

                                            <c:if test = "${wizard.form.data['diskOptions.diskMode'] == 'independent_nonpersistent'}">
                                                <bean:message key = "wizard.hardware.diskConfirmation.nonpersistentMode"/>
                                            </c:if>
                                            </c:otherwise>
                                            </c:choose>
                                        </c:when>  
                                        <c:otherwise>
                                            <c:set var="diskMode" value = "${wizard.form.data['diskOptions.diskMode']}"/>
                                            <c:if test = "${diskMode == 'persistent'}">
                                                <bean:message key = "wizard.hardware.diskConfirmation.persistentMode"/>
                                            </c:if>    
                                            <c:if test = "${diskMode == 'nonpersistent'}">
                                                <bean:message key = "wizard.hardware.diskConfirmation.nonpersistentMode"/>
                                            </c:if> 
                                            <c:if test = "${diskMode == 'undoable'}">
                                                <bean:message key = "wizard.hardware.diskConfirmation.undoableMode"/>
                                            </c:if> 
                                            <c:if test = "${diskMode == 'append'}">
                                                <bean:message key = "wizard.hardware.diskConfirmation.appendMode"/>
                                            </c:if>                                                                                                                                                                          
                                        </c:otherwise>
                                    </c:choose>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <span id = "l10n_wizard_hardware_diskConfirmation_scsiNode">
                                    <bean:message key = "wizard.hardware.diskConfirmation.scsiNode"/></span>
                                </td>

                                <td>
                                    <c:set var = "scsiNodesList" value = "${diskView.scsiNodes}"/>

                                    <c:if test = "${scsiNodesList != null}">
                                        <c:forEach var = "node" items = "${scsiNodesList}">
                                            <c:set var = "eachItem" value = "${node.used}:${node.ctrlrBusNum}:${node.deviceUnitNum}:${node.ctrlrKey}"/>
                                            <c:if test = "${wizard.form.data['diskOptions.scsiNode'] == eachItem}">
                                                <c:out value = "${node.name}"/>
                                            </c:if>
                                        </c:forEach>
                                    </c:if>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </html:form>
        </div>
    </body>
</html>