<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.wizard.Constants" %>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />
<c:forEach var = 'map' items = '${wizard.viewMap}'>
    <c:if test = "${map.key eq 'diskView'}">
        <c:set var = "diskView" value = "${map.value}"/>
    </c:if>
</c:forEach>

<c:forEach var = 'map' items = '${wizard.viewMap}'>
    <c:if test = "${map.key eq 'hardwareView'}">
        <c:set var = "hardwareView" value = "${map.value}"/>
    </c:if>
</c:forEach>

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css" />
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css" />
      
     
      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
      
      <script type="text/javascript" >
	var currentDiskType = "newDisk";
	function selectDiskType(type) {

	   currentDiskType = type;
	   document.forms[0]["property(diskSelection.currentDiskType)"].value=type;
	   tle.getWorkspacePane().workspaceDetails.wc_wizardContentsPane.syncToNextStep("diskSelection.type", type);
	}

    function checkPrivleges() {

       var newDiskPriv = "<c:out value="${hardwareView.canAddNewDisk}" />";
       var existingDiskPriv = "<c:out value="${hardwareView.canAddExistingDisk}" />";
       var rdmDiskPriv = "<c:out value="${hardwareView.canAddRawDevice}" />";

       if (newDiskPriv == 'false') {
          document.getElementById("newDisk").disabled = true;
          document.getElementById("l10n_wizard_hardware_disk_new").className  = "disabled";
          document.getElementById("l10n_wizard_hardware_disk_new_desc").className = "disabled";
       }

       if (existingDiskPriv == 'false') {
          document.getElementById("existingDisk").disabled = true;
          document.getElementById("l10n_wizard_hardware_disk_existing").className  = "disabled";
          document.getElementById("l10n_wizard_hardware_disk_existing_desc").className = "disabled";
       }

       if (rdmDiskPriv == 'false') {
          disableLUNPath();
       }

       var targetLunSize = "<c:out value='${diskView.targetLuns.totalPages}'/>";
       if (targetLunSize == 0) {
          disableLUNPath();
       }
    }

    function disableLUNPath(){
       document.getElementById("mappedDisk").disabled = true;
       document.getElementById("l10n_wizard_hardware_disk_mapped").className  = "disabled";
       document.getElementById("l10n_wizard_hardware_disk_mapped_desc").className = "disabled";
    }
     </script>

   </head>

		<body onload="checkPrivleges();syncContentsToStep('<bean:write name="<%= Constants.STEP_KEY %>" property="name" />');initHelp('disk');" onunload="tearDown();">

		<div class="titlebar" style="width: 505px;">
		   <table border="0" cellspacing="0" cellpadding="0">
		    <tr>
			  <td width="100%"><span id="l10n_wizard_hardware_disk_title" class="title">
			  <bean:message key="wizard.hardware.disk.title"/></span></td>
		    </tr>
		    <tr>
			  <td width="100%"><span id="l10n_wizard_hardware_disk_desc" class="subtitle">
			   <bean:message key="wizard.hardware.disk.desc"/></span></td>
		    </tr>
		   </table>
		</div>

		<div class="dialog" style="width: 505px;">
		   <html:form action="wzrdNext" method="POST">
		   <input type="hidden" id="diskType" name="property(diskSelection.currentDiskType)"/>
		   <div class="window">
		      <div class="fieldset">
           <div class="legend"><span id="l10n_wizard_hardware_disk_type">
           <bean:message key="wizard.hardware.disk.type"/></span></div>
 		      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
					  <tr>
					    <td class="bulletCtrl">
					    <html:radio property="property(diskSelection.type)" value="newDisk"
					    styleId="newDisk" styleClass="radioCtrl" onclick="selectDiskType('newDisk');"/></td>
						  <td><label class="title" ><span id="l10n_wizard_hardware_disk_new">
						  <bean:message key="wizard.hardware.disk.new"/></span></label>
						  <div class="description"><span id="l10n_wizard_hardware_disk_new_desc">
						  <bean:message key="wizard.hardware.disk.new.desc"/></span></div>
						  </td>
					  </tr>
					  <tr>
					  <tr>
					    <td class="bulletCtrl">
				     <html:radio property="property(diskSelection.type)" value="existingDisk"
					    styleId="existingDisk" styleClass="radioCtrl" onclick="selectDiskType('existingDisk');"/></td>
					    <td><label class="title" ><span id="l10n_wizard_hardware_disk_existing">
						       <bean:message key="wizard.hardware.disk.existing"/></span></label>
						  <div class="description"><span id="l10n_wizard_hardware_disk_existing_desc">
						       <bean:message key="wizard.hardware.disk.existing.desc"/></span></div>
						  </td>
					  </tr>
					  <tr>
					    <td class="bulletCtrl">
 			       <html:radio property="property(diskSelection.type)" value="mappedDisk"
					    styleId="mappedDisk" styleClass="radioCtrl" onclick="selectDiskType('mappedDisk');"/></td>
					    <td><label class="title"><span id="l10n_wizard_hardware_disk_mapped">
						       <bean:message key="wizard.hardware.disk.mapped"/></span></label>
						  <div class="description"><span id="l10n_wizard_hardware_disk_mapped_desc">
						        <bean:message key="wizard.hardware.disk.mapped.desc"/></span></div>
						  </td>
					  </tr>
					</table>
					</div>
		   </div>
		   </html:form>
		</div>
		</body>
</html>
