<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.wizard.Constants"%>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page"/>
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page"/>

<html>
   <head>
      <link rel="stylesheet" href="css/default.css" type="text/css"/>
      <!--[if IE]>
      <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css"/>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua"/>
      </jsp:include>
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
      <script language="JavaScript" type="text/javascript">
       function init() {
         initHelp('floppy');
         syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name" />');
       }
      </script> 
   </head>

   <body onload="init();" onunload="tearDown();">
      <div class="titlebar" style="width:505px;">
         <table border="0" cellspacing="0" cellpadding="0">
            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_floppy_confirmation_title" class="title">
                  <bean:message key="wizard.hardware.floppy.confirmation.title"/></span>
               </td>
            </tr>

            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_floppy_confirmation_title_desc" class="subtitle">
                  <bean:message key="wizard.hardware.floppy.confirmation.title.desc"/></span>
               </td>
            </tr>
         </table>
      </div>

      <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
            <div class="window">
               <div class="fieldset">
                  <span class="legend" id="l10n_wizard_hardware_floppy_confirmation_add_device">
                  <bean:message key="wizard.hardware.floppy.confirmation.add.device"/></span>

                  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_floppy_confirmation_hardware_type">
                           <bean:message key="wizard.hardware.floppy.confirmation.hardware.type"/></span>
                        </td>

                        <td>
                           <span id="l10n_wizard_hardware_floppy_confirmation_hardware_type_desc">
                           <bean:message key="wizard.hardware.floppy.confirmation.hardware.type.desc"/></span>
                        </td>
                     </tr>

                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_floppy_confirmation_media_type">
                           <bean:message key="wizard.hardware.floppy.confirmation.media.type"/></span>
                        </td>

                        <td>
                           <c:set var="media" value="${wizard.form.data['floppy.mediaType']}"/>
                           <!-- TODO:hack remove the constatns after JSTL 1.2 upgrade.-->
                           <c:set var="FLOPPY_HOST_MEDIA_PHYSICAL_DRIVE" value="1"/>
                           <c:set var="FLOPPY_HOST_MEDIA_EXISTING_IMAGE" value="2"/>
                           <c:set var="FLOPPY_HOST_MEDIA_BLANK_IMAGE" value="3"/>
                           <c:set var="FLOPPY_CLIENT_MEDIA_PHYSICAL_DRIVE" value="4"/>

                           <c:if test="${media == FLOPPY_HOST_MEDIA_PHYSICAL_DRIVE}">
                              <bean:message key="wizard.hardware.floppy.confirmation.host.physical"/>
                           </c:if>

                           <c:if test="${media == FLOPPY_HOST_MEDIA_EXISTING_IMAGE}">
                              <bean:message key="wizard.hardware.floppy.confirmation.host.existing.image"/>
                           </c:if>

                           <c:if test="${media == FLOPPY_HOST_MEDIA_BLANK_IMAGE}">
                              <bean:message key="wizard.hardware.floppy.confirmation.host.blank.image"/>
                           </c:if>

                           <c:if test="${media == FLOPPY_CLIENT_MEDIA_PHYSICAL_DRIVE}">
                              <bean:message key="wizard.hardware.floppy.confirmation.media.client.physical"/>
                           </c:if>
                        </td>
                     </tr>

                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_floppy_confirmation_media_source">
                           <bean:message key="wizard.hardware.floppy.confirmation.media.source"/></span>
                        </td>

                        <td>
                           <c:if test="${media == FLOPPY_HOST_MEDIA_PHYSICAL_DRIVE}">
                              <c:out value="${wizard.form.data['floppy.hostMediaPhysicalPath']}"/>
                           </c:if>

                           <c:if test="${media == FLOPPY_HOST_MEDIA_EXISTING_IMAGE}">
                              <c:out value="${wizard.form.data['floppy.isoImagePath']}"/>
                           </c:if>

                           <c:if test="${media == FLOPPY_HOST_MEDIA_BLANK_IMAGE}">
                              <c:out value="${wizard.form.data['floppy.newIsoImagepath']}"/>
                           </c:if>

                           <c:if test="${media == FLOPPY_CLIENT_MEDIA_PHYSICAL_DRIVE}">
                              <c:out value="${wizard.form.data['floppy.clientMediaPhysicalPath']}"/>
                           </c:if>
                        </td>
                     </tr>
                     <c:if test="${media != FLOPPY_CLIENT_MEDIA_PHYSICAL_DRIVE}">
                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_floppy_confirmation_connectAtPowerOn">
                           <bean:message key="wizard.hardware.floppy.confirmation.connectAtPowerOn"/></span>
                        </td>

                        <td>
                           <c:set var="cb" value="${wizard.form.data['floppy.connectAtPowerOn']}"/>
                           <c:choose>
                              <c:when test="${cb == 'Yes'}">
                                 <bean:message key="common.label.yes"/>
                              </c:when>

                              <c:otherwise>
                                 <bean:message key="common.label.no"/>
                              </c:otherwise>
                           </c:choose>
                        </td>
                     </tr>
                     </c:if>

                     <tr>
                  </table>
               </div>
            </div>
         </html:form>
      </div>
   </body>
</html>
