<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.wizard.Constants"%>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page"/>
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page"/>
<c:set var="media" value="${wizard.form.data['floppy.mediaType']}"/>
<!-- TODO:hack remove the constatns after JSTL 1.2 upgrade.-->
<c:set var="FLOPPY_HOST_MEDIA_PHYSICAL_DRIVE" value="1"/>
<c:set var="FLOPPY_HOST_MEDIA_EXISTING_IMAGE" value="2"/>
<c:set var="FLOPPY_HOST_MEDIA_BLANK_IMAGE" value="3"/>
<c:set var="FLOPPY_CLIENT_MEDIA_PHYSICAL_DRIVE" value="4"/>

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css"/>
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css"/>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,win,drag"/>
      </jsp:include>
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>

      <script type="text/javascript" src="js/wizard/datastore.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>
      <script>
      function respond() {
	        if (this.selectedItem != null) {
	           document.getElementById("drivePath").value=this.selectedItem;
	        }
	     }

        function init() {
           initHelp('floppy');
           <c:if test="${!wizard.form.valid}">
	           handleValidationDialog(tle.getWorkspacePane());
           </c:if>
           syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name" />');
        }
      </script>
   </head>

   <body onload="init();" onunload="tearDown();">
      <div class="titlebar" style="width:505px;">
         <table border="0" cellspacing="0" cellpadding="0">
            <c:if test="${media == FLOPPY_HOST_MEDIA_PHYSICAL_DRIVE ||
	       media == FLOPPY_CLIENT_MEDIA_PHYSICAL_DRIVE}">
               <tr>
                  <td width="100%">
                     <span id="l10n_wizard_hardware_floppy_drive_title" class="title">
                     <bean:message key="wizard.hardware.floppy.drive.title"/></span>
                  </td>
               </tr>

               <tr>
                  <td width="100%">
                     <div class="subtitle">
                        <span id="l10n_wizard_hardware_floppy_drive_desc">
                        <bean:message key="wizard.hardware.floppy.drive.title.desc"/></span>
                     </div>
                  </td>
               </tr>
            </c:if>

            <c:if test="${media == FLOPPY_HOST_MEDIA_EXISTING_IMAGE}">
               <tr>
                  <td width="100%">
                     <span id="l10n_wizard_hardware_floppy_isoImage_title" class="title">
                     <bean:message key="wizard.hardware.floppy.isoImage.title"/></span>
                  </td>
               </tr>

               <tr>
                  <td width="100%">
                     <div class="subtitle">
                        <span id="l10n_wizard_hardware_floppy_isoImage_title_desc">
                        <bean:message key="wizard.hardware.floppy.isoImage.title.desc"/></span>
                     </div>
                  </td>
               </tr>
            </c:if>

            <c:if test="${media == FLOPPY_HOST_MEDIA_BLANK_IMAGE}">
               <tr>
                  <td width="100%">
                     <span id="l10n_wizard_hardware_floppy_new_isoImage_title" class="title">
                     <bean:message key="wizard.hardware.floppy.new.isoImage.title"/></span>
                  </td>
               </tr>

               <tr>
                  <td width="100%">
                     <div class="subtitle">
                        <span id="l10n_wizard_hardware_floppy_new_isoImage_title_desc">
                        <bean:message key="wizard.hardware.floppy.new.isoImage.title.desc"/></span>
                     </div>
                  </td>
               </tr>
            </c:if>
         </table>
      </div>

      <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
            <div class="window">
               <div class="fieldset">
                  <c:if test="${media == FLOPPY_HOST_MEDIA_PHYSICAL_DRIVE || media == FLOPPY_CLIENT_MEDIA_PHYSICAL_DRIVE}">
                     <span class="legend" id="l10n_wizard_hardware_floppy_drive_physcial">
                     <bean:message key="wizard.hardware.floppy.drive.physical"/></span>
                  </c:if>

                  <c:if test="${media == FLOPPY_HOST_MEDIA_EXISTING_IMAGE}">
                     <span class="legend" id="l10n_wizard_hardware_floppy_drive_isoImage">
                     <bean:message key="wizard.hardware.floppy.drive.isoImage"/></span>
                  </c:if>

                  <c:if test="${media == FLOPPY_HOST_MEDIA_BLANK_IMAGE}">
                     <span class="legend" id="l10n_wizard_hardware_floppy_drive_new_isoimage">
                     <bean:message key="wizard.hardware.floppy.drive.new.isoimage"/></span>
                  </c:if>

                  <table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td width="100%">
                           <c:if test="${media == FLOPPY_HOST_MEDIA_PHYSICAL_DRIVE}">
                              <html:text styleId="drivePath" property="property(floppy.hostMediaPhysicalPath)"
                                         style="width:100%"/>
                           </c:if>

                           <c:if test="${media == FLOPPY_HOST_MEDIA_EXISTING_IMAGE}">
                              <html:text styleId="drivePath" property="property(floppy.isoImagePath)"
                                         style="width:100%"/>
                           </c:if>

                           <c:if test="${media == FLOPPY_HOST_MEDIA_BLANK_IMAGE}">
                              <html:text styleId="drivePath" property="property(floppy.newIsoImagepath)"
                                         style="width:100%"/>
                           </c:if>

                           <c:if test="${media == FLOPPY_CLIENT_MEDIA_PHYSICAL_DRIVE}">
                              <html:text styleId="drivePath" property="property(floppy.clientMediaPhysicalPath)"
                                         style="width:100%"/>
                           </c:if>
                        </td>

                        <c:if test="${media == FLOPPY_HOST_MEDIA_EXISTING_IMAGE}">
                           <td>
                              <a href="#" onclick="handleOpenDialog('floppy&mediaType=existing', self); return false;" id="browseIso">
                              <span id="l10n_vmConfiguration_browse">
                              <bean:message key="vmConfiguration.browse"/></span></a>
                           </td>
                        </c:if>
                        <c:if test="${media == FLOPPY_HOST_MEDIA_BLANK_IMAGE}">
                           <td>
                              <a href="#" onclick="handleOpenDialog('floppy&mediaType=blank', self); return false;" id="browseIso">
                              <span id="l10n_vmConfiguration_browse">
                              <bean:message key="vmConfiguration.browse"/></span></a>
                           </td>
                        </c:if>                        
                     </tr>
                  </table>
               </div>
               
               <c:if test="${media != FLOPPY_CLIENT_MEDIA_PHYSICAL_DRIVE}">

               <div class="fieldset">
                  <span class="legend" id="110n_wizard_hardware_floppy_device_status">

                  <bean:message key="wizard.hardware.floppy.device.status"/></span>

                  <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td class="bulletCtrl">
                           <c:set var="cb" value="${wizard.form.data['floppy.connectAtPowerOn']}"/>

                           <c:choose>
                              <c:when test="${cb == 'Yes'}">
                                 <input type="checkbox" id="connectAtPowerOn" onclick="selectionChanged();" checked="1">
                              </c:when>

                              <c:otherwise>
                                 <input type="checkbox" id="connectAtPowerOn" onclick="selectionChanged();">
                              </c:otherwise>
                           </c:choose>
                        </td>

                        <td>
                           <label for="connectAtPowerOn"><span id="110n_wizard_hardware_floppy_device_connectAtPowerOn">
                           <bean:message key="wizard.hardware.floppy.device.connectAtPowerOn"/></span></label>
                        </td>
                     </tr>

                     <html:hidden property="property(floppy.connectAtPowerOn)" styleId="_connectAtPowerOn"/>
                  </table>
               </div>
            </div>
            
            </c:if>

            <script type="text/javascript">
               function selectionChanged(){
                  document.getElementById("_connectAtPowerOn").value = "No"

                  if (document.getElementById("connectAtPowerOn").checked){
                     document.getElementById("_connectAtPowerOn").value = "Yes"
                  }
               }
            </script>
         </html:form>
      </div>
   </body>
</html>
