<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, 
                 com.vmware.webcenter.util.SortCriteria, 
                 com.vmware.webcenter.control.action.DataCollectionBaseAction,
                 com.vmware.webcenter.control.action.wizards.hardware.DiskLUNBrowserAction" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />
<c:forEach var='map' items='${wizard.viewMap}'>
   <c:if test="${map.key eq 'diskView'}">
      <c:set var="diskViewID" value="${map.value.ID}"/>
   </c:if>
</c:forEach>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">



<head>
 <link href="css/default.css" rel="stylesheet" type="text/css" />
 <!--[if IE]>
 <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
 <![endif]-->
 <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css" />

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,gui,browser,win,drag" />
      </jsp:include>
      
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
        
      <script type="text/javascript" src="js/wizard/common.js"></script>
 
 
 <script type="text/javascript" src="js/wizard/validate.js"></script>
 <script type="text/javascript">

      vpx.context = {
        xmlSpec                : null,
        paginator              : null,
        browser                : null,
        updatesId              : null,
        updatesRunning         : false,   
        DC_PREV_PAGE           : "<%= DataCollectionBaseAction.DC_PREV_PAGE %>",
        DC_NEXT_PAGE           : "<%= DataCollectionBaseAction.DC_NEXT_PAGE %>",
        PARAM_NAME_PAGE        : "<%= DiskLUNBrowserAction.PARAM_NAME_PAGE %>",
        PARAM_NAME_SORT_COL    : "<%= DiskLUNBrowserAction.PARAM_NAME_SORT_COL %>",
        PARAM_NAME_SORT_DIR    : "<%= DiskLUNBrowserAction.PARAM_NAME_SORT_DIR %>",
        viewId                 : "<c:out value='${diskViewID}'/>"
     };

    function handleBodyLoad() {
      var c = vpx.context;          
   
      c.xmlSpec = new vpx.net.XmlSpec("wzrdHardwareSetupLUNLocationXML.do");   
      c.xmlSpec.setAttribute("viewId", "<c:out value='${diskViewID}'/>");  
             
      c.browser = new vpx.browser.Browser($("browserContainer"), <%= Constants.BROWSER_PAGE_DEFAULT_SIZE %>, true, true);
      
      c.paginator = new vpx.browser.Paginator($("paginatorContainer"));
      c.paginator.setProvider(c.browser);	      
      
      c.browser.registerListener(vpx.browser.EVENT.SELECTION, handleSelectionChanged);
      c.browser.registerListener(vpx.browser.EVENT.PAGE, handlePage);
      c.browser.registerListener(vpx.browser.EVENT.SORT, handleSort);  
          
      c.browser.requestData(c.xmlSpec);       
   }

   function handleSelectionChanged(browser) {
      var selected = browser.getSelected()[0];
      if (isDefined(selected)) {
         document.forms[0]["property(lun.uid)"].value=selected.getId();
         document.forms[0]["property(lun.canonicalName)"].value=selected.getAttribute("canonicalName");
         document.forms[0]["property(lun.deviceName)"].value=selected.getAttribute("devName");
         document.forms[0]["property(lun.capacity)"].value=selected.getAttribute("capacity");
      }
   }

   function handleSort(browser, column, sortOrder) {
   var c = vpx.context;

   c.xmlSpec.setAttribute(c.PARAM_NAME_SORT_COL, column.getName());
   c.xmlSpec.setAttribute(c.PARAM_NAME_SORT_DIR, sortOrder);
   browser.requestData(c.xmlSpec);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_SORT_COL);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_SORT_DIR);
   }

   function handlePage(browser, pageType) {
   var c = vpx.context;

      switch (pageType) {
      case vpx.browser.PAGE.PREV:
      c.xmlSpec.setAttribute(c.PARAM_NAME_PAGE, c.DC_PREV_PAGE);
         break;
      case vpx.browser.PAGE.NEXT:
      c.xmlSpec.setAttribute(c.PARAM_NAME_PAGE, c.DC_NEXT_PAGE);
         break;
      default:
         throw new Error("Unsupported page type: " + pageType);
      }

   browser.requestData(c.xmlSpec);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_PAGE); 
   }
   
   function validate() {
       
       <c:if test="${!wizard.form.valid}">
          handleValidationDialog(tle.getWorkspacePane());
       </c:if>
   }
 </script>
</head>

<body onload="handleBodyLoad();validate();syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name" />');initHelp('disk');" onunload="tearDown();">
 <div class="titlebar" style="width: 505px;">
   <table border="0" cellspacing="0" cellpadding="0">
      <tr>
	      <td width="100%"><span class="title" id="wizard_hardware_disk_datastore_location"><bean:message key="wizard.hardware.disk.datastore.lun"/></span></td>
      </tr>
      <tr>
	      <td width="100%"><span class="subtitle" id="wizard_hardware_disk_datastore_location_desc"><bean:message key="wizard.hardware.disk.datastore.lun.desc"/></span></td>
      </tr>
   </table>
</div>

 <html:form action="wzrdNext" method="POST">
      <html:hidden styleId="lunUid" property="property(lun.uid)" />
      <html:hidden styleId="lunDeviceName" property="property(lun.deviceName)" />
      <html:hidden styleId="lunCanonicalName" property="property(lun.canonicalName)" />
      <html:hidden styleId="lunCapacity" property="property(lun.capacity)" />
      <div class="dialog" style="width:505px;overflow:auto;" onselectstart="return false;">
         <div style="border-bottom: solid 1px #B3B3B3; padding: 0px;">
            <div id="navigatorContainer"></div>
            <div id="browserContainer"></div>
            <div id="paginatorContainer"></div>
         </div>
      </div>
  </html:form>
</body>
</html:html>