<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.wizard.Constants"%>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page"/>
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page"/>

<html>
   <head>
      <link rel="stylesheet" href="css/default.css" type="text/css"/>
      <!--[if IE]>
        <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
        <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css"/>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua"/>
      </jsp:include>
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
      <script language="JavaScript" type="text/javascript">
         function init() {
            initHelp('nic');
            syncContentsToStep('<bean:write name="<%= Constants.STEP_KEY %>" property="name" />');  
         }
      </script>
   </head>

   <body onload="init();" onunload="tearDown();">
      <div class="titlebar" style="width: 505px;">
         <table border="0" cellspacing="0" cellpadding="0">
            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_diskConfirmation_title" class="title">
                  <bean:message key="wizard.hardware.diskConfirmation.title"/></span>
               </td>
            </tr>

            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_diskConfirmation_title_desc" class="subtitle">
                  <bean:message key="wizard.hardware.diskConfirmation.title.desc"/></span>
               </td>
            </tr>
         </table>
      </div>

      <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
            <c:forEach var='map' items='${wizard.viewMap}'>
               <c:if test="${map.key eq 'nicView'}">
                  <c:set var="nicView" value="${map.value}"/>
               </c:if>
            </c:forEach>

            <div class="window">
               <div class="fieldset">
                  <span class="legend" id="l10n_wizard_hardware_diskConfirmation_device_info">
                  <bean:message key="wizard.hardware.diskConfirmation.device.info"/></span>

                  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_nic_confirmation_hardware">
                           <bean:message key="wizard.hardware.nic.confirmation.hardware"/></span>
                        </td>

                        <td>
                           <span id="l10n_wizard_hardware_nic_confirmation_device">
                           <bean:message key="wizard.hardware.nic.confirmation.device"/></span>
                        </td>
                     </tr>

                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_confirmation_network">
                           <bean:message key="wizard.hardware.nic.confirmation.network"/></span>
                        </td>

                        <td>
                           <c:out value="${wizard.form.data['nic.network']}"/>
                        </td>
                     </tr>

                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_diskConfirmation_disk_type">
                           <bean:message key="wizard.hardware.nic.confirmation.connectAtPowerOn"/></span>
                        </td>

                        <td>
                           <c:set var="cb" value="${wizard.form.data['nic.connectAtPowerOn']}"/>
                           <c:choose>
                              <c:when test="${cb == 'Yes'}">
                                 <bean:message key="common.label.yes"/>
                              </c:when>

                              <c:otherwise>
                                 <bean:message key="common.label.no"/>
                              </c:otherwise>
                           </c:choose>
                        </td>
                     </tr>

                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_nic_confirmation_virtualDevice">
                           <bean:message key="wizard.hardware.nic.confirmation.virtualDevice"/></span>
                        </td>

                        <td>
                           <c:out value="${wizard.form.data['nicOptions.adapterType']}"/>
                        </td>
                     </tr>
                  </table>
               </div>
            </div>
         </html:form>
      </div>
   </body>
</html>
