<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.wizard.Constants"%>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page"/>
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page"/>
<c:set var="wizardForm" value="${wizard.form}" scope="page"/>

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css"/>
      <!--[if IE]>
        <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
        <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css"/>
      
      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,gui,browser,win,drag"/>
      </jsp:include>
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      
      <script type="text/javascript" src="js/wizard/common.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>
      <script type="text/javascript">
      function init() {
       initHelp('nic');
       <c:if test="${!wizard.form.valid}">
          handleValidationDialog(tle.getWorkspacePane());
       </c:if>
      }
      </script>
   </head>

   <body onload="init();syncContentsToStep('<bean:write name="<%= Constants.STEP_KEY %>" property="name" />');" onunload="tearDown();">
      <div class="titlebar" style="width: 505px;">
         <table border="0" cellspacing="0" cellpadding="0">
            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_nic_title" class="title">
                  <bean:message key="wizard.hardware.nic.title"/></span>
               </td>
            </tr>

            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_nic_title_desc" class="subtitle">
                  <bean:message key="wizard.hardware.nic.title.desc"/></span>
               </td>
            </tr>
         </table>
      </div>

      <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
            <c:forEach var='map' items='${wizard.viewMap}'>
               <c:if test="${map.key eq 'nicView'}">
                  <c:set var="nicView" value="${map.value}"/>
               </c:if>
            </c:forEach>

            <div class="window">
               <div class="fieldset">
                  <span class="legend" id="l10n_wizard_hardware_nic_network">
                  <bean:message key="wizard.hardware.nic.network"/></span>

                  <table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td>
                           <html:select property="property(nic.network)" style="width:100%">
                              <c:forEach var="node" items="${nicView.networks}">
                                 <html:option value="${node.name}"><c:out value="${node.name}"/> </html:option>
                              </c:forEach>
                           </html:select>
                        </td>
                     </tr>
                  </table>
               </div>

               <div class="fieldset">
                  <span class="legend" id="wizard.hardware.nic.device.status">

                  <bean:message key="wizard.hardware.nic.device.status"/></span>

                  <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td class="bulletCtrl">
                           <c:set var="cb" value="${wizard.form.data['nic.connectAtPowerOn']}"/>
                           <c:choose>
                              <c:when test="${cb == 'Yes'}">
                                 <input type="checkbox" id="connectAtPowerOn" onclick="selectionChanged();" checked="1">
                              </c:when>

                              <c:otherwise>
                                 <input type="checkbox" id="connectAtPowerOn" onclick="selectionChanged();">
                              </c:otherwise>
                           </c:choose>
                        </td>

                        <td>
                           <label for="connectAtPowerOn"> <span id="wizard_hardware_nic_device_connectAtPowerOn">
                           <bean:message key="wizard.hardware.nic.device.connectAtPowerOn"/></span></label>
                        </td>
                     </tr>
                     <html:hidden property="property(nic.connectAtPowerOn)" styleId="_connectAtPowerOn"/>
                  </table>
               </div>
            </div>

            <script type="text/javascript">
               function selectionChanged(){
                  document.getElementById("_connectAtPowerOn").value = "No"
                  if (document.getElementById("connectAtPowerOn").checked){
                     document.getElementById("_connectAtPowerOn").value = "Yes"
                  }
               }
            </script>
         </html:form>
      </div>
   </body>
</html>
