<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />
<!-- TODO:hack remove the constatns after JSTL 1.2 upgrade.-->
<c:set var="PARALLEL_PORT_PHYSICAL_DRIVE" value="1"/>
<c:set var="PARALLEL_PORT_OUTPUT_FILE" value="2"/>

<html>
   <head>
	<link rel="stylesheet" href="css/default.css" type="text/css" />
	<!--[if IE]>
	<link href="css/default-ie.css" rel="stylesheet" type="text/css" />
	<![endif]-->

	<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
	<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
		<jsp:param name="packages" value="xua" />
	</jsp:include>
	<%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
	<%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
   <script type="text/javascript" src="js/wizard/common.js"></script>
   <script language="JavaScript" type="text/javascript">
       function init() {
         initHelp('parallel');
         syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name"/>');
       }
    </script> 
   </head>

   <body onload="init();" onunload="tearDown();">

   <div class="titlebar" style="width: 505px;">
      <table border="0" cellspacing="0" cellpadding="0">
         <tr>
            <td width="100%"><span id="l10n_wizard_hardware_parallelPort_confirmation_title" class="title">
            <bean:message key="wizard.hardware.parallelPort.confirmation.title"/></span></td>
         </tr>
         <tr>
            <td width="100%"><span id="l10n_wizard_hardware_parallelPort_confirmation_title_desc" class="subtitle">
            <bean:message key="wizard.hardware.parallelPort.confirmation.title.desc"/></span></td>
         </tr>
      </table>
   </div>

   <div class="dialog" style="width: 505px;">
      <html:form action="wzrdNext" method="POST">
	<c:forEach var='map' items='${wizard.viewMap}'>
           <c:if test="${map.key eq 'parallelPortView'}">
	      <c:set var="parallelPortView" value="${map.value}"/>
           </c:if>
        </c:forEach>
        <c:set var="backingType" value="${wizard.form.data['parallelPort.mediaType']}" />
        <div class="window">
           <div class="fieldset">
           <span class="legend" id="l10n_wizard_hardware_parallelPort_confirmation_add_device">
           <bean:message key="wizard.hardware.parallelPort.confirmation.add.device"/></span>

             <table width="100%" border="0" cellspacing="0" cellpadding="0">
               <tr>
                  <td><span id="l10n_wizard_hardware_parallelPort_confirmation_hardware_type">
                      <bean:message key="wizard.hardware.parallelPort.confirmation.type"/></span></td>
                  <td><span id="l10n_wizard_hardware_parallelPort_confirmation_hardware_type_desc">
                      <bean:message key="wizard.hardware.parallelPort.confirmation.hardware.type.desc"/></span></td>
               </tr>
               <tr>
                  <td><span id="l10n_wizard_hardware_parallelPort_confirmation_connection_type">
                      <bean:message key="wizard.hardware.parallelPort.confirmation.connection.type"/></span></td>
                  <td>
                     <c:if test="${backingType == PARALLEL_PORT_PHYSICAL_DRIVE}">
                        <span id="l10n_wizard_hardware_parallelPort_confirmation_physical" class="title">
                        <bean:message key="wizard.hardware.parallelPort.confirmation.physical"/></span>
                     </c:if>
                     <c:if test="${backingType == PARALLEL_PORT_OUTPUT_FILE}">
                        <span id="l10n_wizard_hardware_parallelPort_confirmation_file" class="title">
                        <bean:message key="wizard.hardware.parallelPort.confirmation.file"/></span>
                     </c:if>
                  </td>
              </tr>
              <tr>
                 <td><span id="l10n_wizard_hardware_parallelPort_confirmation_connection_source">
                     <bean:message key="wizard.hardware.parallelPort.confirmation.connection.source"/></span></td>
                 <td><c:out value="${wizard.form.data['parallelPort.path']}" />
		        <c:out value="${wizard.form.data['serialPort.path']}" />
			<c:if test="${backingType == PARALLEL_PORT_PHYSICAL_DRIVE}">
                           <c:set var="parallels" value="${parallelPortView.parallels}"/>
                           <c:if test="${parallels != null}">
                              <c:forEach var="node" items="${parallels}">
                                 <c:set var="value" value="${node.name}"/>
                                 <c:if test="${wizard.form.data['parallelPort.physicalPath'] == value}">
                                     <c:out value="${node.name}" />
                                 </c:if>
                              </c:forEach>
                           </c:if>
			</c:if>
			<c:if test="${backingType == PARALLEL_PORT_OUTPUT_FILE}">
                            <c:out value="${wizard.form.data['parallelPort.outputFile']}" />
			</c:if>
		 </td>
              </tr>
              <tr>
                 <td><span id="l10n_wizard_hardware_parallelPort_confirmation_connectAtPowerOn">
                 <bean:message key="wizard.hardware.parallelPort.confirmation.connectAtPowerOn"/></span></td>
                 <td>
                     <c:set var="cb" value="${wizard.form.data['parallelPort.connectAtPowerOn']}" />
                     <c:choose>
                        <c:when test="${cb == 'Yes'}" >
                           <bean:message key="common.label.yes"/>
                        </c:when>

                        <c:otherwise>
                           <bean:message key="common.label.no"/>
                        </c:otherwise>
                     </c:choose>
                  </td>
                </tr>
             </table>
           </div>
         </div>
      </html:form>
    </div>
  </body>
</html>