<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />
<!-- TODO:hack remove the constatns after JSTL 1.2 upgrade.-->
<c:set var="PARALLEL_PORT_PHYSICAL_DRIVE" value="1"/>
<c:set var="PARALLEL_PORT_OUTPUT_FILE" value="2"/>

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css" />
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css" />

      <script type="text/javascript" src="js/wizard/datastore.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>

       <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
       <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
          <jsp:param name="packages" value="xua,win,drag" />
       </jsp:include>
       <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
       <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>

      <script>
        function respond() {
	        if (this.selectedItem != null) {
	          document.getElementById("outputFile").value=this.selectedItem;
	        }
	     }

	     function init() {
	        initHelp('parallel');
           <c:if test="${!wizard.form.valid}">
	      handleValidationDialog(tle.getWorkspacePane());
           </c:if>
           syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name" />');
        }
        
      </script>

   </head>
   <body onload="init();" onunload="tearDown();">
    <html:form action="wzrdNext" method="POST">
    <c:set var="backingType" value="${wizard.form.data['parallelPort.mediaType']}" />

    <c:forEach var='map' items='${wizard.viewMap}'>
         <c:if test="${map.key eq 'parallelPortView'}">
            <c:set var="parallelPortView" value="${map.value}"/>
         </c:if>
     </c:forEach>

    <div class="titlebar" style="width:505px;">

       <table border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td width="100%"><span id="l10n_wizard_hardware_parallelPort_port" class="title">
	       <c:if test="${backingType == PARALLEL_PORT_PHYSICAL_DRIVE}">
		  <span id="l10n_wizard_hardware_parallelPort_port" class="title">
		  <bean:message key="wizard.hardware.parallelPort.port"/></span>
	       </c:if>
	       <c:if test="${backingType == PARALLEL_PORT_OUTPUT_FILE}">
		   <span id="l10n_wizard_hardware_parallelPort_file" class="title">
		   <bean:message key="wizard.hardware.parallelPort.file"/></span>
	       </c:if>
	    </td>
	  </tr>
	  <tr>
            <td ><div class="subtitle"><span id="l10n_wizard_hardware_parallelPort_path_desc" >
            <bean:message key="wizard.hardware.parallelPort.port.desc"/></span></div></td>
	  </tr>
       </table>
    </div>

    <div class="dialog" style="width: 505px;">

       <div class="window">
	  <div class="fieldset">
	    <c:if test="${backingType == PARALLEL_PORT_PHYSICAL_DRIVE}">
	       <span class="legend" id="l10n_wizard_hardware_parallelPort_physical_port" class="title">
	       <bean:message key="wizard.hardware.parallelPort.physical.port"/></span>
            </c:if>
            <c:if test="${backingType == PARALLEL_PORT_OUTPUT_FILE}">
	        <span class="legend" id="l10n_wizard_hardware_parallelPort_file_port" class="title">
	        <bean:message key="wizard.hardware.parallelPort.file.port"/></span>
            </c:if>

	    <table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
	       <tr>
	          <td width="100%">
             <c:choose>
               <c:when test="${backingType == PARALLEL_PORT_PHYSICAL_DRIVE}">
     	          <c:if test="${parallelPortView.parallels != null}">
	             <html:select property="property(parallelPort.physicalPath)" style="width:100%">
                        <c:forEach var="node" items="${parallelPortView.parallels}">
                           <html:option value="${node.name}" >
			      <c:out value="${node.name}" />
			   </html:option>
			</c:forEach>
		     </html:select>
	           </c:if>
               </c:when>
               <c:otherwise>
                 <html:text styleId="outputFile" property="property(parallelPort.outputFile)" style="width:100%" />
               </c:otherwise>
             </c:choose>
	          </td>

	          <c:if test="${backingType == PARALLEL_PORT_OUTPUT_FILE}">
		     <td style="white-space : nowrap"><a href="#" onclick="handleOpenDialog('parallel', self); return false;" id="browseIso">
			 <span id="l10n_vmConfiguration_browse">
			   <bean:message key="vmConfiguration.browse"/>
			 </span></a></td>
		  </c:if>
		</tr>
	     </table>
       </div>

       <div class="fieldset">
	  <span class="legend" id="l10n_wizard_hardware_parallelPort_device_status">
          <bean:message key="wizard.hardware.parallelPort.device.status"/></span>
	    <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
		<tr>
		   <td class="bulletCtrl">
		    <c:set var="cb" value="${wizard.form.data['parallelPort.connectAtPowerOn']}" />
		    <c:choose>
		      <c:when test="${cb == 'Yes'}" >
			<input type="checkbox" id="connectAtPowerOn" onclick="selectionChanged();" checked="1">
		     </c:when>
		     <c:otherwise>
		     <input type="checkbox" id="connectAtPowerOn" onclick="selectionChanged();">
		     </c:otherwise>
		   </c:choose>
		  </td>
		   <td><label for="connectAtPowerOn"><span id="l10n_wizard_hardware_parallelPort_connectAtPoweron">
		        <bean:message key="wizard.hardware.parallelPort.connectAtPoweron"/></span></label> </td>
		</tr>
		  <html:hidden property="property(parallelPort.connectAtPowerOn)" styleId="_connectAtPowerOn"/>
	     </table>
	   </div>
	 </div>
   	   <script type="text/javascript">
      	     function selectionChanged() {
      	        document.getElementById("_connectAtPowerOn").value="No"
      	        if (document.getElementById("connectAtPowerOn").checked) {
      	          document.getElementById("_connectAtPowerOn").value="Yes"
      	        }
      	     }
          </script>
       </html:form>
    </div>
  </body>
</html>