<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants"%>

<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page"/>

<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page"/>

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css"/>
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css"/>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
       <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
       <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
   </head>

   <body onload="syncContentsToStep(
   'passthroughSCSIConfirmation');initHelp('scsi');" onunload="tearDown();">
      <div class="titlebar" style="width: 505px;">
         <table border="0" cellspacing="0" cellpadding="0">
            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_passthroughSCSI_confirmation_title" class="title">
                  <bean:message key="wizard.hardware.passthroughSCSI.confirmation.title"/></span>
               </td>
            </tr>

            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_passthroughSCSI_confirmation_title_desc" class="subtitle">
                  <bean:message key="wizard.hardware.passthroughSCSI.confirmation.title.desc"/></span>
               </td>
            </tr>
         </table>
      </div>

      <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
            <c:forEach var='map' items='${wizard.viewMap}'>
               <c:if test="${map.key eq 'passthroughSCSIView'}">
                  <c:set var="scsiView" value="${map.value}"/>
               </c:if>
            </c:forEach>

            <div class="window">
               <div class="fieldset">
                  <span class="legend" id="l10n_wizard_hardware_passthroughSCSI_confirmation_add_device">
                  <bean:message key="wizard.hardware.passthroughSCSI.confirmation.add.device"/></span>

                  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_passthroughSCSI_confirmation_hardware_type">
                           <bean:message key="wizard.hardware.passthroughSCSI.confirmation.hardware.type"/></span>
                        </td>
                        <td>
                           <span id="l10n_wizard_hardware_passthroughSCSI_confirmation_hardware_type_desc">
                           <bean:message key="wizard.hardware.passthroughSCSI.confirmation.hardware.type.desc"/></span>
                        </td>
                     </tr>
                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_passthroughSCSI_confirmation_device_source">
                           <bean:message key="wizard.hardware.passthroughSCSI.confirmation.device.source"/></span>
                        </td>
                        <td>
                           <c:set var="deviceList" value="${scsiView.scsiPassthroughs}"/>
                           <c:if test="${deviceList != null}">
                              <c:forEach var="node" items="${deviceList}">
                                 <c:set var="nodeValue" value="${node.name}"/>
                                 <c:if test="${wizard.form.data['passthroughSCSI.deviceNode'] == nodeValue}">
                                     <bean:message key="wizard.hardware.passthroughSCSI.SCSIDevice.${node.scsiClass}" arg0 = "${node.name}"/>
                                 </c:if>
                              </c:forEach>
                           </c:if>
                        </td>
                     </tr>
                     <tr>
                        <td>
                           <span id="l10n_wizard_hardware_passthroughSCSI_confirmation_virtual_device">
                           <bean:message key="wizard.hardware.passthroughSCSI.confirmation.virtual.device"/></span>
                        </td>
                        <td>
                           <c:set var="nodeList" value="${scsiView.scsiNodes}"/>
                           <c:if test="${nodeList != null}">
                              <c:forEach var="node" items="${nodeList}">
                                 <c:set var="nodeValue" value="${node.used}:${node.ctrlrBusNum}:${node.deviceUnitNum}:${node.ctrlrKey}"/>
                                 <c:if test="${wizard.form.data['passthroughSCSI.scsiNode'] == nodeValue}">
                                    <c:out value="${node.name}" />
                                 </c:if>
                              </c:forEach>
                           </c:if>
                        </td>
                     </tr>
                  </table>
               </div>
            </div>
         </html:form>
      </div>
   </body>
</html>
