<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants"%>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css"/>
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css"/>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,win,drag"/>
      </jsp:include>
       <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
       <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>
      <script type="text/javascript">
         function init() {
            initHelp('scsi');
            <c:if test="${!wizard.form.valid}">
	            handleValidationDialog(tle.getWorkspacePane());
            </c:if>
         }
      </script>
   </head>

   <body onload="init();syncContentsToStep(
   'passthroughSCSIDeviceSelection');" onunload="tearDown();">
      <div class="titlebar" style="width: 505px;">
         <table border="0" cellspacing="0" cellpadding="0">
            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_passthroughSCSI_title" class="title">
                  <bean:message key="wizard.hardware.passthroughSCSI.title"/></span>
               </td>
            </tr>

            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_passthroughSCSI_title_desc" class="subtitle">
                  <bean:message key="wizard.hardware.passthroughSCSI.title.desc"/></span>
               </td>
            </tr>
         </table>
      </div>

      <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
            <c:forEach var='map' items='${wizard.viewMap}'>
               <c:if test="${map.key eq 'passthroughSCSIView'}">
                  <c:set var="scsiView" value="${map.value}"/>
               </c:if>
            </c:forEach>

            <div class="window">
               <div class="fieldset">
                  <span class="legend" id="l10n_wizard_hardware_passthroughSCSI_physicalDevice">
                  <bean:message key="wizard.hardware.passthroughSCSI.physicalDevice"/></span>

                  <table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td width="20%">
                           <span id="l10n_wizard_hardware_passthroughSCSI_SCSIDevice"/>
                           <bean:message key="wizard.hardware.passthroughSCSI.SCSIDevice"/>
                           </span>
                        </td>
                        <td width="80%">
                           <html:select property="property(passthroughSCSI.deviceNode)" style="width:100%">
                              <c:if test="${scsiView != null}">
                                 <c:forEach var="node" items="${scsiView.scsiPassthroughs}">
                                    <html:option value="${node.name}">
                                    <bean:message key="wizard.hardware.passthroughSCSI.SCSIDevice.${node.scsiClass}" arg0 = "${node.name}"/> </html:option>
                                 </c:forEach>
                              </c:if>
                           </html:select>
                        </td>
                     </tr>
                  </table>
               </div>
         </html:form>
      </div>
   </body>
</html>
