<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants"%>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page"/>
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page"/>

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css"/>
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css"/>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,win,drag"/>
      </jsp:include>
       <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
       <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>
      <script type="text/javascript">
        function init() {
            initHelp('scsi');
            <c:if test="${!wizard.form.valid}">
	            handleValidationDialog(tle.getWorkspacePane());
            </c:if>
         }
      </script>
   </head>

   <body onload="init();syncContentsToStep(
   'passthroughSCSIOptions');" onunload="tearDown();">
      <div class="titlebar" style="width: 505px;">
         <table border="0" cellspacing="0" cellpadding="0">
            <tr>
               <td width="100%">
                  <span id="l10n_wizard_hardware_passthrough_options_title" class="title">
                  <bean:message key="wizard.hardware.passthrough.options.title"/></span>
               </td>
            </tr>
            <tr>
               <td width="100%">
                  <div class="subtitle"><span id="l10n_wizard_hardware_passthrough_options_title_desc">
                  <bean:message key="wizard.hardware.passthrough.options.title.desc"/></span></div>
               </td>
            </tr>
         </table>
      </div>

      <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
            <c:forEach var='map' items='${wizard.viewMap}'>
               <c:if test="${map.key eq 'passthroughSCSIView'}">
                  <c:set var="scsiView" value="${map.value}"/>
               </c:if>
            </c:forEach>

            <div class="window">
               <div class="fieldset">
                  <div class="legend">
                     <span id="l10n_wizard_hardware_passthrough_options_virtualDevice">
                     <bean:message key="wizard.hardware.passthrough.options.virtualDevice"/></span>
                  </div>

                  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td width="25%">
                           <span id="l10n_wizard_hardware_passthrough_options_scsi_node">
                           <bean:message key="wizard.hardware.passthrough.options.scsi.node"/>
                        </td>
                        <td width="75%">
                           <html:select property="property(passthroughSCSI.scsiNode)" style="width:100%">
                              <c:if test="${!empty scsiView}">
                                 <c:forEach var="node" items="${scsiView.scsiNodes}">
                                    <html:option value="${node.used}:${node.ctrlrBusNum}:${node.deviceUnitNum}:${node.ctrlrKey}">
                                    <c:out value="${node.name}" /> </html:option>
                                 </c:forEach>
                              </c:if>
                           </html:select>
                        </td>
                     </tr>
                  </table>
               </div>
         </html:form>
      </div>
   </body>
</html>
