<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />
<!-- TODO:hack remove the constatns after JSTL 1.2 upgrade.-->
<c:set var="SERIAL_PORT_PHYSICAL_DRIVE" value="1"/>
<c:set var="SERIAL_PORT_OUTPUT_FILE" value="2"/>
<c:set var="SERIAL_PORT_NAMED_PIPE" value="3"/>
<c:set var="SERIAL_PORT_NEAR_END_SERVER" value="<%= String.valueOf(Constants.SERIAL_PORT_NEAR_END_SERVER) %>"/>
<c:set var="SERIAL_PORT_NEAR_END_CLIENT" value="<%= String.valueOf(Constants.SERIAL_PORT_NEAR_END_CLIENT) %>"/>
<c:set var="SERIAL_PORT_FAR_END_VM" value="<%= String.valueOf(Constants.SERIAL_PORT_FAR_END_VM) %>"/>
<c:set var="SERIAL_PORT_FAR_END_APPLICATION" value="<%= String.valueOf(Constants.SERIAL_PORT_FAR_END_APPLICATION) %>"/>

<html>
   <head>
   <link rel="stylesheet" href="css/default.css" type="text/css" />
   <!--[if IE]>
   <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
   <![endif]-->

	<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
	<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
		<jsp:param name="packages" value="xua" />
	</jsp:include>
	<%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
       <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
    <script type="text/javascript" src="js/wizard/common.js"></script>
    <script language="JavaScript" type="text/javascript">
       function init() {
         initHelp('serial');
         syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name" />');
       }
    </script> 
    </head>

    <body onload="init();" onunload="tearDown();">

	<div class="titlebar" style="width: 505px;">
	   <table border="0" cellspacing="0" cellpadding="0">
	      <tr>
	         <td width="100%"><span id="l10n_wizard_hardware_serialPort_confirmation_title" class="title">
		 <bean:message key="wizard.hardware.serialPort.confirmation.title"/></span></td>
	      </tr>
	      <tr>
	         <td width="100%"><span id="l10n_wizard_hardware_serialPort_confirmation_title_desc" class="subtitle">
		 <bean:message key="wizard.hardware.serialPort.confirmation.title.desc"/></span></td>
	      </tr>
	   </table>
	</div>

	<div class="dialog" style="width: 505px;">
	   <html:form action="wzrdNext" method="POST">
	    <c:forEach var='map' items='${wizard.viewMap}'>
	       <c:if test="${map.key eq 'serialPortView'}">
	          <c:set var="serialPortView" value="${map.value}"/>
	       </c:if>
	    </c:forEach>
            <c:set var="backingType" value="${wizard.form.data['serialPort.mediaType']}" />

	   <div class="window">
	      <div class="fieldset">
              <span class="legend" id="l10n_wizard_hardware_serialPort_confirmation_add_device">
              <bean:message key="wizard.hardware.serialPort.confirmation.add.device"/></span>

	        <table width="100%" border="0" cellspacing="0" cellpadding="0">
		  <tr>
		     <td><span id="l10n_wizard_hardware_serialPort_confirmation_hardware_type">
	                 <bean:message key="wizard.hardware.serialPort.confirmation.hardware.type"/></span></td>
		     <td><span id="l10n_wizard_hardware_serialPort_confirmation_hardware_type_desc">
	                 <bean:message key="wizard.hardware.serialPort.confirmation.hardware.type.desc"/></span></td>
		   </tr>
		   <tr>
		      <td><span id="l10n_wizard_hardware_serialPort_confirmation_connection_type">
	                 <bean:message key="wizard.hardware.serialPort.confirmation.connection.type"/></span></td>
		      <td>
			<c:if test="${backingType == SERIAL_PORT_PHYSICAL_DRIVE}">
			   <span id="l10n_wizard_hardware_serialPort_hostSerialPort" class="title">
			   <bean:message key="wizard.hardware.serialPort.hostSerialPort"/></span>
			</c:if>
			<c:if test="${backingType == SERIAL_PORT_OUTPUT_FILE}">
			   <span id="l10n_wizard_hardware_serialPort_hostFile" class="title">
			   <bean:message key="wizard.hardware.serialPort.hostFile"/></span>
		        </c:if>
			<c:if test="${backingType == SERIAL_PORT_NAMED_PIPE}">
			   <span id="l10n_wizard_hardware_serialPort_hostPipe" class="title">
			   <bean:message key="wizard.hardware.serialPort.hostPipe"/></span>
			</c:if>
		      </td>
	           </tr>
		   <c:if test="${backingType == SERIAL_PORT_NAMED_PIPE}">

		      <c:set var="nearEndType" value="${wizard.form.data['serialPort.nearEndType']}" />
		      <c:set var="farEndType" value="${wizard.form.data['serialPort.farEndType']}" />

			   <tr>
			      <td><span id="l10n_wizard_hardware_serialPort_confirmation_near_end">
				 <bean:message key="wizard.hardware.serialPort.confirmation.near.end"/></span></td>
			      <td>
				 <c:choose>
				    <c:when test="${nearEndType == SERIAL_PORT_NEAR_END_SERVER}">
					<span id="l10n_wizard_hardware_serialPort_confirmation_server">
					<bean:message key="wizard.hardware.serialPort.confirmation.server"/></span>
				    </c:when>
				    <c:otherwise>
				        <span id="l10n_wizard_hardware_serialPort_confirmation_client">
					<bean:message key="wizard.hardware.serialPort.confirmation.client"/></span>
				    </c:otherwise>
				 </c:choose>
			      </td>
			   </tr>
			   <tr>
			      <td><span id="l10n_wizard_hardware_serialPort_confirmation_far_end">
			      <bean:message key="wizard.hardware.serialPort.confirmation.far.end"/></span></td>
			      <td>
			      <c:choose>
				 <c:when test="${farEndType == SERIAL_PORT_FAR_END_VM}">
				    <span id="l10n_wizard_hardware_serialPort_confirmation_vm">
			            <bean:message key="wizard.hardware.serialPort.confirmation.vm"/></span>
				 </c:when>
				 <c:otherwise>
				    <span id="l10n_wizard_hardware_serialPort_confirmation_application">
				    <bean:message key="wizard.hardware.serialPort.confirmation.application"/></span>
				 </c:otherwise>
			      </c:choose>
			    </td>
			    </tr>
	           </c:if>
		   <tr>
		      <td><span id="l10n_wizard_hardware_serialPort_confirmation_connection_source">
	              <bean:message key="wizard.hardware.serialPort.confirmation.connection.source"/></span></td>
		      <td>
		        <c:out value="${wizard.form.data['serialPort.path']}" />
			<c:if test="${backingType == SERIAL_PORT_PHYSICAL_DRIVE}">
                           <c:set var="serials" value="${serialPortView.serials}"/>
                           <c:if test="${serials != null}">
                              <c:forEach var="node" items="${serials}">
                                 <c:set var="value" value="${node.name}"/>
                                 <c:if test="${wizard.form.data['serialPort.physicalPath'] == value}">
                                     <c:out value="${node.name}" />
                                 </c:if>
                              </c:forEach>
                           </c:if>
			</c:if>
			<c:if test="${backingType == SERIAL_PORT_OUTPUT_FILE}">
                            <c:out value="${wizard.form.data['serialPort.outputPath']}" />
			</c:if>
			<c:if test="${backingType == SERIAL_PORT_NAMED_PIPE}">
			    <c:out value="${wizard.form.data['serialPort.namedPipe']}" />
			</c:if>
		      </td>
		      </tr>
		      <tr>
			 <td><span id="l10n_wizard_hardware_serialPort_confirmation_connectAtPowerOn">
	                 <bean:message key="wizard.hardware.serialPort.confirmation.connectAtPowerOn"/></span></td>
			  <td>
                 <c:set var="cb1" value="${wizard.form.data['serialPort.connectAtPowerOn']}" />
                 <c:choose>
                    <c:when test="${cb1 == 'Yes'}" >
                       <bean:message key="common.label.yes"/>
                    </c:when>
                    
                    <c:otherwise>
                       <bean:message key="common.label.no"/>
                    </c:otherwise>
                 </c:choose>
			  </td>
			</tr>
			<tr>
			  <td><span id="l10n_wizard_hardware_serialPort_confirmation_yield">
	                    <bean:message key="wizard.hardware.serialPort.confirmation.yield"/></span></td>
			  <td>
                 <c:set var="cb2" value="${wizard.form.data['serialPort.yield']}" />
                 <c:choose>
                    <c:when test="${cb2 == 'Yes'}" >
                       <bean:message key="common.label.yes"/>
                    </c:when>
                    
                    <c:otherwise>
                       <bean:message key="common.label.no"/>
                    </c:otherwise>
                 </c:choose>
			  </td>
			</tr>
		      </table>
		  </div>
	     </div>
	   </html:form>
	</div>
    </body>
</html>




