<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.wizard.Constants" %>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css" />
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css" />

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
      <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
       <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
      <script language="JavaScript" type="text/javascript">
         function init() {
           initHelp('serial');
           syncContentsToStep('<bean:write name="<%= Constants.STEP_KEY %>" property="name" />');
         }
      </script>
   </head>

   <body onload="init();" onunload="tearDown();">
       <div class="titlebar" style="width: 505px;">
         <table border="0" cellspacing="0" cellpadding="0">
           <tr>
	       <td width="100%"><span id="l10n_wizard_hardware_serialPort_options_title" class="title">
	       <bean:message key="wizard.hardware.serialPort.options.title"/></span></td>
	   </tr>
	   <tr>
	       <td width="100%"><span id="l10n_wizard_hardware_serialPort_options_title_desc" class="subtitle">
		<bean:message key="wizard.hardware.serialPort.options.title.desc"/></span></td>
	   </tr>
	 </table>
	</div>
       <div class="dialog" style="width: 505px;">
         <html:form action="wzrdNext" method="POST">
           <div class="window">
             <div class="fieldset">
	       <div class="legend">
	       <span id="l10n_wizard_hardware_serialPort_options_io_mode">
	       <bean:message key="wizard.hardware.serialPort.options.io.mode"/></span>
	       </div>
	       <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
	          <tr>
		     <td class="bulletCtrl">
		     <c:set var="cb" value="${wizard.form.data['serialPort.yield']}" />
		     <c:choose>
			<c:when test="${cb == 'Yes'}" >
			   <input type="checkbox" id="yieldOnPoll" onclick="selectionChanged();" checked="1">
			</c:when>
			<c:otherwise>
			   <input type="checkbox" id="yieldOnPoll" onclick="selectionChanged();">
			</c:otherwise>
		     </c:choose>
		     </td>
		     <td>
			<label class="title" for="yield">
			<span id="110n_wizard.hardware.serialPort.options.yield">
			<bean:message key="wizard.hardware.serialPort.options.yield"/></span>
			</label>
			<div class="description">
			<span id="110n_wizard.hardware.serialPort.options.yield.desc">
			<bean:message key="wizard.hardware.serialPort.options.yield.desc"/></span>
			</div>
		     </td>
		   </tr>
		   <html:hidden property="property(serialPort.yield)" styleId="_yieldOnPoll"/>
	       </table>
	    </div>
         </div>
      	 <script type="text/javascript">
            function selectionChanged() {
               document.getElementById("_yieldOnPoll").value="No"
                  if (document.getElementById("yieldOnPoll").checked) {
         	     document.getElementById("_yieldOnPoll").value="Yes"
               }
            }
         </script>
       </html:form>
     </div>
  </body>
</html>