<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />
<!-- TODO:hack remove the constatns after JSTL 1.2 upgrade.-->
<c:set var="SERIAL_PORT_PHYSICAL_DRIVE" value="1"/>
<c:set var="SERIAL_PORT_OUTPUT_FILE" value="2"/>
<c:set var="SERIAL_PORT_NAMED_PIPE" value="3"/>
<c:set var="SERIAL_PORT_NEAR_END_SERVER" value="<%= String.valueOf(Constants.SERIAL_PORT_NEAR_END_SERVER) %>"/>
<c:set var="SERIAL_PORT_NEAR_END_CLIENT" value="<%= String.valueOf(Constants.SERIAL_PORT_NEAR_END_CLIENT) %>"/>
<c:set var="SERIAL_PORT_FAR_END_VM" value="<%= String.valueOf(Constants.SERIAL_PORT_FAR_END_VM) %>"/>
<c:set var="SERIAL_PORT_FAR_END_APPLICATION" value="<%= String.valueOf(Constants.SERIAL_PORT_FAR_END_APPLICATION) %>"/>

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css" />
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/hardware.css" />

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
       <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
       <%@ include file="/WEB-INF/jsp/wizards/hardware/_help.jsp" %>
      <script type="text/javascript" src="js/wizard/datastore.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>


       <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
       <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
          <jsp:param name="packages" value="xua,win,drag" />
       </jsp:include>
       <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>

      <script>
	function respond() {
	   if (this.selectedItem != null) {
	      document.getElementById("outputFile").value=this.selectedItem;
	   }
        }

        function init() {
           initHelp('serial');
           <c:if test="${!wizard.form.valid}">
	          handleValidationDialog(tle.getWorkspacePane());
           </c:if>
           syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name" />');
        }
      </script>

   </head>
   <body onload="init();" onunload="tearDown();">

      <html:form action="wzrdNext" method="POST">
         <div class="titlebar" style="width:505px;">

	    <c:forEach var='map' items='${wizard.viewMap}'>
	       <c:if test="${map.key eq 'serialPortView'}">
	          <c:set var="serialPortView" value="${map.value}"/>
	       </c:if>
	    </c:forEach>
            <c:set var="backingType" value="${wizard.form.data['serialPort.mediaType']}" />

            <table border="0" cellspacing="0" cellpadding="0">
            <tr>
            <td width="100%">
                <c:if test="${backingType == SERIAL_PORT_PHYSICAL_DRIVE}">
                    <div class="title"><span id="l10n_wizard_hardware_serialPort_port">
                    <bean:message key="wizard.hardware.serialPort.port"/></span></div>
                </c:if>
                <c:if test="${backingType == SERIAL_PORT_OUTPUT_FILE}">
                    <div class="title"><span id="l10n_wizard_hardware_serialPort_file">
                    <bean:message key="wizard.hardware.serialPort.file"/></span></div>
                </c:if>
                <c:if test="${backingType == SERIAL_PORT_NAMED_PIPE}">
                    <div class="title"><span id="l10n_wizard_hardware_serialPort_pipe">
                    <bean:message key="wizard.hardware.serialPort.pipe"/></span></div>
                </c:if>
            </td>
            </tr>
            <tr>
            <td ><div class="subtitle"><span id="l10n_wizard_hardware_serialPort_path_desc">
            <bean:message key="wizard.hardware.serialPort.path.desc"/></span></div></td>
            </tr>
            </table>
         </div>

         <div class="dialog" style="width: 505px;">

           <div class="window">
              <div class="fieldset">

                <c:if test="${backingType == SERIAL_PORT_PHYSICAL_DRIVE}">
                <span class="legend" id="l10n_wizard_hardware_serialPort_physical_port" class="title">
                <bean:message key="wizard.hardware.serialPort.physical.port"/></span>
                </c:if>
                <c:if test="${backingType == SERIAL_PORT_OUTPUT_FILE}">
                <span class="legend" id="l10n_wizard_hardware_serialPort_output_file" class="title">
                <bean:message key="wizard.hardware.serialPort.output.file"/></span>
                </c:if>
                <c:if test="${backingType == SERIAL_PORT_NAMED_PIPE}">
                <span class="legend" id="l10n_wizard_hardware_serialPort_pipe_name" class="title">
                <bean:message key="wizard.hardware.serialPort.pipe.name"/></span>
                 </c:if>

                <table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
                   <tr>
                      <td width="100%">
                         <c:choose>
                           <c:when test="${backingType == SERIAL_PORT_PHYSICAL_DRIVE}">
			      <c:if test="${!empty serialPortView.serials}">
				  <html:select property="property(serialPort.physicalPath)" style="width:100%">
				      <c:forEach var="node" items="${serialPortView.serials}">
					  <html:option value="${node.name}" >
					      <c:out value="${node.name}" />
					  </html:option>
				      </c:forEach>
			         </html:select>
			      </c:if>
                           </c:when>
                           <c:otherwise>
                                <c:if test="${backingType == SERIAL_PORT_OUTPUT_FILE}">
                                   <html:text property="property(serialPort.outputPath)" styleId="outputFile"style="width:100%" />
                                </c:if>
                                <c:if test="${backingType == SERIAL_PORT_NAMED_PIPE}">
                                   <html:text property="property(serialPort.namedPipe)" style="width:100%" />
                                </c:if>
                           </c:otherwise>
                         </c:choose>

                      </td>
                      <c:if test="${backingType == SERIAL_PORT_OUTPUT_FILE}">
			  <td style="white-space : nowrap"><a href="#" onclick="handleOpenDialog('serial', self); return false;" id="browseIso">
			     <span id="l10n_vmConfiguration_browse">
			        <bean:message key="vmConfiguration.browse"/>
			     </span></a></td>
                       </c:if>
                    </tr>
                    <c:if test="${backingType == SERIAL_PORT_NAMED_PIPE}">
                    <tr>
		              <%-- TODO:XXXX hardcoded.Show the example based on guest OS as per prototype --%>
                      <td width="100%" colspan="2"><span id="example" class="subtitle">
                      <bean:message key="wizard.hardware.serialPort.pipe.name.example"/></span></td>
                    </tr>
                    </c:if>
               </table>
              </div>

              <c:if test="${backingType == SERIAL_PORT_NAMED_PIPE}">

		<div class="fieldset" id="nearEndGroup" >
		<span class="legend" id="l10n_wizard_hardware_serialPort_near_end">
		<bean:message key="wizard.hardware.serialPort.near.end"/></span>
		 <table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
		    <tr>
			<td class="bulletCtrl"><html:radio property="property(serialPort.nearEndType)"  styleId="nearEndServer"
			value="${SERIAL_PORT_NEAR_END_SERVER}"/></td>
			<td>
			  <label class="title" for="server"><span id="l10n_wizard_hardware_serialPort_near_end_server">
			  <bean:message key="wizard.hardware.serialPort.near.end.server"/></span></label>
			  <div class="description">
			  <span id="l10n_wizard_hardware_serialPort_near_end_server_desc">
			  <bean:message key="wizard.hardware.serialPort.near.end.server.desc"/></div>
			</td>
		   </tr>
		   <tr>
			<td class="bulletCtrl"><html:radio property="property(serialPort.nearEndType)" styleId="nearEndClient"
			value="${SERIAL_PORT_NEAR_END_CLIENT}" /></td>
			<td>
			  <label class="title" for="client"><span id="l10n_wizard_hardware_serialPort_near_end_client">
			  <bean:message key="wizard.hardware.serialPort.near.end.client"/></span></label>
			  <div class="description vertLast"><span id="l10n_wizard_hardware_serialPort_near_end_client_desc">
			  <bean:message key="wizard.hardware.serialPort.near.end.client.desc"/></span></div>
			</td>
		   </tr>
		 </table>
		</div>

		<div class="fieldset" id="farEndGroup" >
		<span class="legend" id="l10n_wizard_hardware_serialPort_far_end">
		<bean:message key="wizard.hardware.serialPort.far.end"/></span>
		 <table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
		    <tr>
			<td class="bulletCtrl"><html:radio property="property(serialPort.farEndType)" styleId="farEndVM"
			value="${SERIAL_PORT_FAR_END_VM}" /></td>
			<td>
			  <label class="title" for="virtualMachine"><span id="l10n_wizard_hardware_serialPort_far_end_vm">
			  <bean:message key="wizard.hardware.serialPort.far.end.vm"/></span></label>
			  <div class="description"><span id="l10n_wizard_hardware_serialPort_far_end_vm_desc">
			  <bean:message key="wizard.hardware.serialPort.far.end.vm.desc"/></div>
			</td>
		   </tr>
		   <tr>
			<td class="bulletCtrl"><html:radio property="property(serialPort.farEndType)" styleId="farEndApp"
			value="${SERIAL_PORT_FAR_END_APPLICATION}" /></td>
			<td>
			  <label class="title" for="application"><span id="l10n_wizard_hardware_serialPort_far_end_application">
			  <bean:message key="wizard.hardware.serialPort.far.end.application"/></span></label>
			  <div class="description vertLast"><span id="l10n_wizard_hardware_serialPort_far_end_application_desc">
			  <bean:message key="wizard.hardware.serialPort.far.end.application.desc"/></span></div>
			</td>
		   </tr>
		 </table>
		</div>
              </c:if>

              <div class="fieldset">
                 <span class="legend" id="l10n_wizard_hardware_serialPort_device_status">
                 <bean:message key="wizard.hardware.serialPort.device.status"/></span>
                 <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td class="bulletCtrl">
                     <c:set var="cb" value="${wizard.form.data['serialPort.connectAtPowerOn']}" />
                     <c:choose>
                       <c:when test="${cb == 'Yes'}" >
                         <input type="checkbox" id="connectAtPowerOn" onclick="selectionChanged();" checked="1">
                      </c:when>
                      <c:otherwise>
                      <input type="checkbox" id="connectAtPowerOn" onclick="selectionChanged();">
                      </c:otherwise>
                    </c:choose>
                   </td>
                   <td><label for="connectAtPowerOn"><span id="l10n_wizard_hardware_serialPort_connectAtPoweron">
                    <bean:message key="wizard.hardware.serialPort.connectAtPoweron"/></span></label> </td>
                 </tr>
                 <html:hidden property="property(serialPort.connectAtPowerOn)" styleId="_connectAtPowerOn"/>
              </table>
             </div>
            </div>
            <script type="text/javascript">
               function selectionChanged() {
                  document.getElementById("_connectAtPowerOn").value="No"
         	  if (document.getElementById("connectAtPowerOn").checked) {
         	     document.getElementById("_connectAtPowerOn").value="Yes"
         	  }
               }
            </script>
       </html:form>
     </div>
   </body>
</html>