<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.wizard.Constants" %>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />
<c:set var="validationErrors" value="${wizard.form.validationErrors}" scope="page" />

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<html>
   <head>
      <title>Question</title>
      <link href="css/default.css" rel="stylesheet" type="text/css" />
      <!--[if IE]>
      <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
      <![endif]-->
      <style type="text/css">
         body { margin: 0px; padding: 0px; border: none; overflow: hidden; }
         .titlebar .title { margin-left: 0px; }
         div.commandButtons {
            border-top: solid 1px #e6e6e6;
            margin: 8px;
            margin-top: 0px;
            padding-top: 8px;
         }
      </style>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,drag" />
      </jsp:include>
      <script type="text/javascript" src="js/wizard/common.js"></script>

      <script>
         var vpxWin;
         var methods = {};
         methods.getContentDimension = function() {
            return vpx.xua.getDimension("windowPane");
         };

	 methods.getIcon = function () {
	    return this.icon;
	 };

	 methods.setIcon = function (icon) {
	    vpx.xua.setAttribute($("windowIcon"), "class", "icon " + icon.source);
	    return this.icon = icon;
	 };

	 methods.setIcon = function (icon) {
            vpx.xua.setAttribute($("windowIcon"), "class", "icon " + icon.source);			
	    return this.icon = icon;
	 };
			
	 function initPane(o) {
	    vpxWin = o;
	    var handles = $("windowTitleCell");
	    if (! isArray(handles)) {
		handles = [handles];
	    }

	    extendObject(vpxWin, methods);

	    document.onkeyup = function (e) {
	       if (vpx.xua.event.getKeyCode(e) == 27) {
		  vpxWin.cancel();
	       }
	    };

	    vpx.xua.event.listen($("windowClose"), "click", vpxWin.cancel.bind(vpxWin));

	    vpxWin.ready();
	 };


         dragStart = function (e) {
            vpx.xua.setStyle("windowViewport", "position", "absolute");
            var dim = vpx.xua.getDimension("windowViewport");
            vpx.xua.setPosition("windowViewport", new Position(0,0).subtract(dim.toPosition()));
            vpx.xua.setStyle("windowControls", "display", "none");
         };


         dragDrag = function (e) {
            window.status = vpx.xua.event.getPosition(e);
            return true;
         };

         dragEnd = function (e) {
            vpx.xua.setStyle("windowViewport", "position", "static");
            vpx.xua.setStyle("windowControls", "display", "");
         };

         function handleRespond() {
            vpxWin.okay();
         }
      </script>
   </head>

   <body>
      <div id="windowPane" class="dialog half" style="position:absolute; top:0px; left:0px; border-bottom:solid 1px #b3b3b3; margin:0px; padding-bottom:0px;">
         <div id="windowTitleBar" class="titlebar">
            <table border="0" cellspacing="0" cellpadding="0">
               <tr>
                  <td id="windowTitleCell" width="100%"><span id="l10n_wizard_add_hardware_validation_windowTitle" class="title">
                  <bean:message key="wizard.add.hardware.validation.windowTitle" /></span></td>
                  <td id="windowCloseCell"><div id="windowClose" class="close-12x12 icon" /></td>
               </tr>
            </table>
         </div>
         <!-- div style="width:100%; height:120px; background-color:#c00;" / -->
         <div style="margin: 8px;">
            <table style="border-collapse: collapse;" border="0" cellpadding="0" cellspacing="0">
               <tr>
                  <td valign="top"><div id="windowIcon" class="icon warning-32x32" /></td>
                  <td>
                     <div id="windowMessage" style="margin-left:8px;">
                     <span id="l10n_wizard_add_hardware_validation_windowDesc" class="title">
                         <bean:message key="wizard.add.hardware.validation.windowDesc" /></span>
                       <c:if test="${!empty validationErrors}">
                          <c:forEach items="${validationErrors}" var="item" varStatus="status">
                            &nbsp;&nbsp <ul><li><c:out value="${item.value}"/></li></ul>
                          </c:forEach>
                       </c:if>
                    </div>
                  </td>
               </tr>
            </table>
         </div>

       <div id="windowControls">
          <div class="commandButtons">
             <input class="buttonCtrl" style="width: 80px;" type="button" id="OK" value="<bean:message key="common.label.ok"/>" onclick="handleRespond();" />
          </div>
       </div>

      </div>
   </body>
</html>
