<%@ taglib uri="/tags/c" prefix="c" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ page isELIgnored="false" %>
<c:set var="WIZARDVO_KEY" value="<%= com.vmware.webcenter.wizard.Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />
<c:set var="diskType" value="${wizard.form.data['diskSelection.type']}" />
<c:set var="hostType" value="${wizard.form.data['host.productLineId']}" />

<c:set var="CREATE_VM_GUEST_OS_RECOMMENDED_MIN" value="<%= String.valueOf(Constants.CREATE_VM_GUEST_OS_RECOMMENDED_MIN) %>" scope="page" />
<c:set var="CREATE_VM_RECOMMENDED_MEMORY" value="<%= String.valueOf(Constants.CREATE_VM_RECOMMENDED_MEMORY) %>" scope="page" />
<c:set var="CREATE_VM_RECOMMENDED_MEMORY_MAX" value="<%= String.valueOf(Constants.CREATE_VM_RECOMMENDED_MEMORY_MAX) %>" scope="page" />
<c:set var="CREATE_VM_CUSTOM_MEMORY" value="<%= String.valueOf(Constants.CREATE_VM_CUSTOM_MEMORY) %>" scope="page" />
<c:set var="PRODUCT_VMSERVER" value="<%= String.valueOf(Constants.PRODUCT_VMSERVER) %>" scope="page" />

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css" />
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/newVM.css" />

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
      <script type="text/javascript" src="js/wizard/common.js"></script>
   </head>
   <body onload="syncContentsToStep('<bean:write name="<%= com.vmware.webcenter.wizard.Constants.STEP_KEY %>" property="name" />');">
      <div class="titlebar">
         <span class="sectionTitle"><bean:message key="wizard.addVM.step.confirmation.name" /></span>
      </div>
      <div class="subhead"><bean:message key="wizard.addVM.step.confirmation.desc" /></div>
      <html:form action="wzrdNext" method="POST">
         <div class="window pane">
            <bean:message key="wizard.addVM.step.confirmation.vm.desc"/>
            <fieldset>
               <table width="100%" cellpadding="0" cellspacing="0" border="0">
                  <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.name"/></td>
                     <td><c:out value="${wizard.form.data['vmName.name']}" /></td>
                  </tr>
                   <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.location"/></td>
                     <td><c:out value="${wizard.form.data['location.name']}" /></td>
                  </tr>                 
                  <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.guest"/></td>
                     <td><c:out value="${wizard.form.data['guestOS.windowsGuestOS']}" /></td>
                  </tr>
                  <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.processors"/></td>
                     <td><c:out value="${wizard.form.data['processors.numCPUs']}" /></td>
                  </tr>
                  <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.memory"/></td>
                     <td><c:set var="memoryType" value="${wizard.form.data['memory.sizeMB']}" /> 
                        <c:if test="${memoryType == CREATE_VM_GUEST_OS_RECOMMENDED_MIN}">                        
                           <c:out value="${wizard.form.data['memory.recommendedMinMemory']}" />
                        </c:if>
                         <c:if test="${memoryType == CREATE_VM_RECOMMENDED_MEMORY}">                        
                           <c:out value="${wizard.form.data['memory.recommendedMemory']}" />
                        </c:if>
                         <c:if test="${memoryType == CREATE_VM_RECOMMENDED_MEMORY_MAX}">                        
                           <c:out value="${wizard.form.data['memory.recommendedMaxMemory']}" />
                        </c:if>    
                         <c:if test="${memoryType == CREATE_VM_CUSTOM_MEMORY}">                        
                           <c:out value="${wizard.form.data['memory.customSize']}" />
                        </c:if>                                                                 
                        MB
                     </td>
                  </tr>
                  <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.nic"/></td>
                     <td>                         
                        <c:out value="${wizard.form.data['network.name']}" />               
                     </td>
                  </tr>
                  <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.disk"/></td>
                     <td>                     
                        <c:if test = "${diskType == 'newDisk'}">
                            <span id = "l10n_wizard_hardware_diskConfirmation_newDisk">
                            <bean:message key = "wizard.hardware.diskConfirmation.newDisk"/></span>
                        </c:if>

                        <c:if test = "${diskType == 'existingDisk'}">
                            <span id = "l10n_wizard_hardware_diskConfirmation_existingDisk">
                            <bean:message key = "wizard.hardware.diskConfirmation.existingDisk"/></span>
                        </c:if>

                        <c:if test = "${diskType == 'mappedDisk'}">
                            <span id = "l10n_wizard_hardware_diskConfirmation_mappedLUN">
                            <bean:message key = "wizard.hardware.diskConfirmation.mappedLUN"/></span>
                        </c:if>
                     </td>
                  </tr>
                  <c:if test="${diskType == 'newDisk'}">
                   <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.disk.capacity"/></td>
                     <td><c:out value="${wizard.form.data['diskCapacity.size']}" />
                         <c:out value="${wizard.form.data['diskCapacity.units']}" />
                     </td>
                  </tr>
                  </c:if>
                   <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.disk.location"/></td>
                     <td>
                    <c:if test = "${diskType == 'newDisk'}">                     
                        <c:set var="datastore" value="${wizard.form.data['diskCapacity.datastore']}" />
                        <c:choose>
                           <c:when test="${datastore eq 'specificDataStore'}">
                              <c:out value="${wizard.form.data['diskCapacity.dataStorePath']}" />
                           </c:when>
                           <c:otherwise>
                              <c:out value="${wizard.form.data['defaultDatastore.name']}" />
                           </c:otherwise>
                        </c:choose>
                    </c:if>

                    <c:if test = "${diskType == 'existingDisk'}">
                        <c:out value="${wizard.form.data['existingDisk.fileName']}" /> 
                    </c:if>

                    <c:if test = "${diskType == 'mappedDisk'}">               
                        <c:out value="${wizard.form.data['lun.canonicalName']}" />                        
                    </c:if>
                     </td>
                  </tr>
                  
                 <c:if test="${hostType eq PRODUCT_VMSERVER}">
                   <tr>
                    <td>
                      <bean:message key="wizard.hardware.diskCapacity.allocate.space.now"/>:
                    </td>
                    <td>
                      <c:out value="${wizard.form.data['diskCapacity.allocateSpaceNow']}"/>   
                    </td>                    
                   </tr>
                   <tr>
                    <td>
                      <bean:message key="wizard.hardware.diskCapacity.split.disk"/>:
                    </td>
                    <td>
                      <c:choose>
                        <c:when test="${empty wizard.form.data['diskCapacity.splitDisk']}">                          
                          <bean:message key="common.label.no"/>
                        </c:when>
                        <c:otherwise>
                          <c:out value="${wizard.form.data['diskCapacity.splitDisk']}"/>   
                        </c:otherwise>
                      </c:choose>
                         
                    </td>                    
                   </tr>                   
                   <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.disk.adapter"/></td>
                     <td><c:out value="${wizard.form.data['adapter.name']}" /></td>
                  </tr>      
                  </c:if>                                             
                  <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.cd"/></td>
                     <td><bean:message key="wizard.addVM.step.confirmation.vm.cd.path"/></td>
                  </tr>
                  <tr>
                     <td width="220"><bean:message key="wizard.addVM.step.confirmation.vm.floppy"/></td>
                     <td><bean:message key="wizard.addVM.step.confirmation.vm.floppy.path"/></td>
                  </tr>
               </table>
            </fieldset>
         </div>
      </html:form>
   </body>
</html>
