<%@ taglib uri = "/tags/c" prefix = "c"%>
<%@ taglib uri = "/tags/struts-html" prefix = "html"%>
<%@ taglib uri = "/tags/struts-bean" prefix = "bean"%>
<%@ page import = "com.vmware.webcenter.wizard.Constants"%>
<%@ page isELIgnored = "false"%>

<c:set var = "WIZARDVO_KEY" value = "<%= Constants.WIZARDVO_KEY %>" scope = "page"/>
<c:set var = "wizard" value = "${sessionScope[WIZARDVO_KEY]}" scope = "page"/>

<html>
    <head>
        <link rel = "stylesheet" type = "text/css" href = "css/default.css"/>
        <!--[if IE]>
        <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
        <![endif]-->
        <link rel = "stylesheet" type = "text/css" href = "css/wizard/newVM.css"/>

        <%@ include file = "/WEB-INF/jsp/common/commonJs.jsp"%>

        <jsp:include page = "/WEB-INF/jsp/common/vpxJs.jsp">
            <jsp:param name = "packages" value = "xua,win,drag"/>
        </jsp:include>

        <script type = "text/javascript" src = "js/wizard/common.js"></script>

      <script type="text/javascript" src="js/wizard/datastore.js"></script>
      <script type="text/javascript" src="js/wizard/validate.js"></script>

        <script type = "text/javascript">

        function respond() {
          if (this.selectedItem != null) {
             document.getElementById("dataStorePath").value=this.selectedItem;
          }
        }

        function init() {

           <c:if test="${!wizard.form.valid}">
              handleValidationDialog(tle.getWorkspacePane());
           </c:if>
        }


        </script>
    </head>

    <body onload = "syncContentsToStep('diskCapacity'); init();">
        <div class = "titlebar">
            <span class = "sectionTitle">
            <bean:message key = "wizard.addVM.step.disk.capacity"/></span>
        </div>

        <div class = "subhead">
            <bean:message key = "wizard.addVM.step.disk.capacity.desc"/>
        </div>

        <html:form action = "wzrdNext" method = "POST">
            <div class = "window pane">
                <div class = "fieldset">
                    <span id = "l10n_wizard_hardware_diskCapacity_name" class = "legend">
                    <bean:message key = "wizard.hardware.diskCapacity.name"/></span>

                    <table class = "ctrlGrp" border = "0" cellspacing = "0" cellpadding = "0">
                        <tr>
                            <td>
                                <span id = "l10n_wizard_hardware_diskCapacity_size">
                                <bean:message key = "wizard.hardware.diskCapacity.size"/></span>
                            </td>

                            <td>
                                <html:text property = "property(diskCapacity.size)"
                                           styleClass = "text numericTextInput"/>
                            </td>

                            <td>
                                &nbsp;
                            </td>

                            <td>
                            <html:select property="property(diskCapacity.units)">
                               <html:option value="MB"><bean:message key="wizard.hardware.diskCapacity.size.MB"/></html:option>
                               <html:option value="GB"><bean:message key="wizard.hardware.diskCapacity.size.GB"/></html:option>
                            </html:select>
                            </td>
                        </tr>
                    </table>
                </div>

                <p>
                <div class = "fieldset">
                    <span id = "l10n_vmConfiguration_device_status" class = "legend"> Location</span>

                    <table class = "ctrlGrp" border = "0" cellspacing = "0" cellpadding = "0">
                        <tr>
                            <td class = "bulletCtrl" colspan = "3">
                                <div class = "description">
                                    <span id = "l10n_wizard_hardware_diskCapacity_speficDatastore_desc">
                                    <bean:message key = "wizard.hardware.diskCapacity.specificDatastore.desc"/></span>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <span id = "l10n_wizard_hardware_diskCapacity_datastore">
                                <bean:message key = "wizard.hardware.diskCapacity.datastore"/></span>
                            </td>

                            <td>

                                <html:text property = "property(defaultDatastore.name)"
                                           styleId = "dataStorePath" style = "width:100%;position:relative;"/>
                            </td>

                            <td>
                                <a href = "#" id = "browse" name = "browse" class = "browse"
                                   onclick = "handleOpenDialog('datastore&computeResouceId='+ '<c:out value="${wizard.form.data['host.computeResouceID']}" />', tle.getWorkspacePane()); return false;">
                                <span id = "l10n_vmConfiguration_browse">
                                <bean:message key = "vmConfiguration.browse"/> </span>
                            </td>
                        </tr>

                         <tr>
                            <td>
                               &nbsp;
                            </td>
                            <td colspan="2">
                              <c:out value="${wizard.form.data['defaultDatastore.freespace']}" />
                              <bean:message key ="vmDetails.tab.summary.related.datastores.free"/>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                &nbsp;
                            </td>

                            <td>
                                <span id = "l10n_wizard_hardware_diskCapacity_datastore_freespace">
                                &nbsp;&nbsp;
                                <html:text styleId = "freespace"  property = "property(diskCapacpity.freespace)"
                                           style = "border:0px;"/> </span>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class = "fieldset">
                   <span id = "l10n_wizard_hardware_diskCapacity_file_options" class = "legend">
                    <bean:message key = "wizard.hardware.diskCapacity.file.options"/> </span>
                    <table class = "ctrlGrp" border = "0" cellspacing = "0" cellpadding = "0">
                      <tr>
                         <td class = "bulletCtrl">
                            <c:set var="cb" value="${wizard.form.data['diskCapacity.allocateSpaceNow']}"/>

                           <c:choose>
                              <c:when test="${cb == 'Yes'}">
                                 <input type="checkbox" id="allocateSpaceNow" onclick="selectionChanged();" checked="1">
                              </c:when>

                              <c:otherwise>
                                 <input type="checkbox" id="allocateSpaceNow" onclick="selectionChanged();">
                              </c:otherwise>
                           </c:choose>
                         </td>
                         <td align = "left">
                             <span id = "l10n_wizard_hardware_diskCapacity_allocate_space_now">
                             <bean:message key = "wizard.hardware.diskCapacity.allocate.space.now"/></span>
                         </td>
                      </tr>
                         <tr>
                            <td>
                            </td>

                            <td wrap = "true">
                                <span id = "l10n_wizard_hardware_diskCapacity_allocate_space_now_desc">
                                <bean:message key = "wizard.hardware.diskCapacity.allocate.space.now.desc"/></span>
                            </td>
                        </tr>
                        <tr>
                            <td colpsan = "2">&nbsp;</td>
                        </tr>
                        <tr>
                            <td class = "bulletCtrl">
                               <c:set var="cb" value="${wizard.form.data['diskCapacity.splitDisk']}"/>


                              <c:choose>
                              <c:when test="${cb == 'Yes'}">
                                 <input type="checkbox" id="splitDisk" onclick="selectionChanged();" checked="1">
                              </c:when>

                              <c:otherwise>
                                 <input type="checkbox" id="splitDisk" onclick="selectionChanged();">
                              </c:otherwise>
                              </c:choose>

                            </td>

                            <td>
                                <span id = "l10n_wizard_hardware_diskCapacity_split_disk">
                                <bean:message key = "wizard.hardware.diskCapacity.split.disk"/></span>
                            </td>
                        </tr>
                        <tr>
                            <td colpsan = "2">&nbsp;</td>
                        </tr>
                    </table>
                </div>

                <div class = "fieldset">
                   <span id = "l10n_wizard_hardware_diskCapacity_adapter" class = "legend">
                   <bean:message key = "wizard.hardware.diskCapacity.adapter"/></span>
                   <table class = "ctrlGrp" border = "0" cellspacing = "0" cellpadding = "0">
                        <tr>
                            <td colspan = "3">
                                <span id = "l10n_wizard_hardware_diskCapacity_adapter_desc">
                                <bean:message key = "wizard.hardware.diskCapacity.adapter.desc"/></span>
                            </td>
                        </tr>
                         <tr>
                            <td class = "bulletCtrl">

                                <html:radio property="property(adapter.name)" value="IDE"
					                   styleId="IDE" styleClass="radioCtrl" />
                            </td>

                            <td align="left">
                                <span id = "l10n_wizard_hardware_diskCapacity_adapter_ide">
                                <bean:message key = "wizard.hardware.diskCapacity.adapter.ide"/></span>
                                 <c:if test="${wizard.form.data['adapter.name'] eq 'IDE'}" >
                                  <bean:message key = "wizard.hardware.diskCapacity.adapter.recommended"/>
                                 </c:if>
                                </td>
                        </tr>

                         <tr>
                            <td class = "bulletCtrl">
                                <html:radio property="property(adapter.name)" value="SCSI"
					                   styleId="SCSI" styleClass="radioCtrl" />

                            </td>

                            <td align="left">
                                <span id = "l10n_wizard_hardware_diskCapacity_adapter_scsi">
                                <bean:message key = "wizard.hardware.diskCapacity.adapter.scsi"/></span>
                                <c:if test="${wizard.form.data['adapter.name'] eq 'SCSI'}" >
                                  <bean:message key = "wizard.hardware.diskCapacity.adapter.recommended"/>
                                 </c:if>
                            </td>
                            <td>
                        </tr>
                   </table>
                <div>

                <html:hidden property="property(diskCapacity.allocateSpaceNow)" styleId="_allocateSpaceNow"/>
                <html:hidden property="property(diskCapacity.splitDisk)" styleId="_splitDisk"/>

            </div>
             <script type="text/javascript">
               function selectionChanged(){
                  document.getElementById("_allocateSpaceNow").value = "No";
                  document.getElementById("_splitDisk").value = "No";

                  if (document.getElementById("allocateSpaceNow").checked){
                     document.getElementById("_allocateSpaceNow").value = "Yes";
                  }
                   if (document.getElementById("splitDisk").checked){
                     document.getElementById("_splitDisk").value = "Yes";
                  }
               }
            </script>
        </html:form>
    </body>
</html>
