<%@ taglib uri="/tags/c" prefix="c" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ page import="com.vmware.webcenter.wizard.Constants" %>
<%@ page isELIgnored="false" %>
<c:set var="WIZARDVO_KEY" value="<%= Constants.WIZARDVO_KEY %>" scope="page" />
<c:set var="wizard" value="${sessionScope[WIZARDVO_KEY]}" scope="page" />

<html>
   <head>
      <link rel="stylesheet" type="text/css" href="css/default.css" />
      <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
      <![endif]-->
      <link rel="stylesheet" type="text/css" href="css/wizard/newVM.css" />

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
		<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
			<jsp:param name="packages" value="xua,win,drag" />
		</jsp:include>
      <script type="text/javascript" src="js/wizard/common.js"></script>
		<script type="text/javascript" src="js/wizard/validate.js"></script>
		<script type="text/javascript">


			function handleChangeFamily() {
				var radios = document.getElementsByName("property(guestOS.family)");
				for (var i = 0; i < radios.length; i++) {
					var visible = radios[i].checked;
					$("osSelect_" + i).style.display = visible ? "" : "none";
				}
			}
         function init() {

	        <c:if test="${!wizard.form.valid}">
	           handleValidationDialog(tle.getWorkspacePane());
	        </c:if>
	      }
		</script>
   </head>
   <body onload="syncContentsToStep('<bean:write name="<%= Constants.STEP_KEY %>" property="name" />'); handleChangeFamily();init();">
      <div class="titlebar">
         <span class="sectionTitle"><bean:message key="wizard.addVM.step.guestOS.name" /></span>
      </div>
      <div class="subhead"><bean:message key="wizard.addVM.step.guestOS.desc" /></div>
      <html:form action="wzrdNext" method="POST">
         <div class="window pane">
            <fieldset>
               <legend><bean:message key="wizard.addVM.step.guestOS.name"/></legend>
               <table cellpadding="0" cellspacing="0" border="0">
                  <c:forEach items="${wizard.view.OSDescriptors}" var="entry" varStatus="status">
                     <tr valign="top">
                        <td><html:radio property="property(guestOS.family)" value="${entry.key}" styleId="${entry.key}Family" styleClass="radioCtrl" onclick="handleChangeFamily();" /></td>
                        <td>
                           <div><label for="<c:out value="${entry.key}" />Family">
                                   <c:if test="${entry.key eq 'windowsGuest'}">
                                      <bean:message key="wizard.addVM.step.guestOS.microsoft"/>
                                   </c:if>
                                    <c:if test="${entry.key eq 'netwareGuest'}">
                                       <bean:message key="wizard.addVM.step.guestOS.netware"/>
                                   </c:if>
                                    <c:if test="${entry.key eq 'solarisGuest'}">
                                      <bean:message key="wizard.addVM.step.guestOS.solaris"/>
                                   </c:if>
                                    <c:if test="${entry.key eq 'linuxGuest'}">
                                      <bean:message key="wizard.addVM.step.guestOS.linux"/>
                                   </c:if>
                                   <c:if test="${entry.key eq 'otherGuestFamily'}">
                                     <bean:message key="wizard.addVM.step.guestOS.other"/>
                                   </c:if>                                                                                                                                         
                                </label>
                           </div>
                           <div>
                              <html:select styleId="osSelect_${status.index}" property="property(guestOS.${entry.key}OS)">
                                 <c:forEach items="${entry.value}" var="descriptor">
                                    <html:option value="${descriptor.id}"><c:out value="${descriptor.fullName}" /></html:option>
                                 </c:forEach>
                              </html:select>
                           </div>
                        </td>
                     </tr>
                  </c:forEach>
               </table>
            </fieldset>
         </div>
      </html:form>
   </body>
</html>
