<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.WzrdVMSingleHostView,
                 com.vmware.webcenter.util.SortCriteria" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="selectedId" value="${requestScope['lunID']}" />

<bean:parameter id="sortColumns" name="sortColumns" value="<%= WzrdVMSingleHostView.RDM_DEVICE %>"/>
<bean:parameter id="sortOrder" name="sortOrder" value="<%= SortCriteria.SORT_ORDER_DSC %>"/>

<browserPane page="<c:out value='${wzrdVMSingleHostView.targetLuns.currentPageNumber}' />"
             total="<c:out value='${wzrdVMSingleHostView.targetLuns.totalSize}' />">
   <cols sort="<c:out value='${sortColumns}' />" dir="<c:out value='${sortOrder}' />">
      <col name="<%= WzrdVMSingleHostView.RDM_DEVICE %>"
           display="<fmt:message key='wizard.hardware.virtualDisk.mappedLUN.colHeader.device' bundle='${messageResources}' />"
           canSort="true"
           widest="true"/>

      <col name="<%= WzrdVMSingleHostView.RDM_CAPACITY %>"
           display="<fmt:message key='wizard.hardware.virtualDisk.mappedLUN.colHeader.capacity' bundle='${messageResources}' />"
           canSort="true"/>

      <col name="<%= WzrdVMSingleHostView.RDM_AVAILABLE %>"
           display="<fmt:message key='wizard.hardware.virtualDisk.mappedLUN.colHeader.available' bundle='${messageResources}' />"
           canSort="true"/>

      <col name="<%= WzrdVMSingleHostView.RDM_TARGET_ID %>"
           display="<fmt:message key='wizard.hardware.virtualDisk.mappedLUN.colHeader.targetId' bundle='${messageResources}' />"
           canSort="true"/>

      <col name="<%= WzrdVMSingleHostView.RDM_LUN %>"
           display="<fmt:message key='wizard.hardware.virtualDisk.mappedLUN.colHeader.lun' bundle='${messageResources}' />"
           canSort="true"/>
   </cols>

   <nodes>
      <c:forEach var="lun" items="${wzrdVMSingleHostView.targetLuns.currentPage}">
        <node id="<c:out value='${lun.uid}'/>" iconClass="virtualDisk-16x16">
           <col><cell><c:out value="${lun.canonicalName}" /></cell></col>
           <col><cell><c:out value="${lun.capacity}" /></cell></col>
           <col><cell><c:out value="${lun.avaliable}" /></cell></col>
           <col><cell><c:out value="${lun.targetId}" /></cell></col>
           <col><cell><c:out value="${lun.lunNo}" /></cell></col>
           <attrs>
             <attr name="canonicalName" value="<c:out value='${lun.canonicalName}' />"/>
             <attr name="devName" value="<c:out value='${lun.devName}' />"/>
             <attr name="capacity" value="<c:out value='${lun.avaliable}' />"/>
           </attrs>
        </node>
      </c:forEach>
   </nodes>

   <attrs>
      <attr name="viewId" value="<c:out value='${wzrdVMSingleHostView.ID}' />"/>
   </attrs>
    <c:if test="${!empty selectedId}">
      <selections>
         <selection id="<c:out value='${selectedId}' />" />
      </selections>
   </c:if>
   </browserPane>
