<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ page import="com.vmware.webcenter.control.action.VmDirectAction" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>

<c:set var="BEAN_CONTEXT_USER" value="<%= com.vmware.webcenter.view.viewhelper.Constants.BEAN_CONTEXT_USER %>" scope="page" />
<c:set var="contextUser" value="${sessionScope[BEAN_CONTEXT_USER]}" scope="page" />

<bean:parameter name="<%= VmDirectAction.PARAM_NAME_VM_ID %>" id="vmId" value="null"/>

<html:html locale="true">
 <head>
  <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
  <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
  <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
    <jsp:param name="packages" value="xua,win" />
  </jsp:include>
  <link rel="stylesheet" type="text/css" href="css/default.css" />
  <!--[if IE]>
   <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
  <![endif]-->
  <style>
   div.url {
     margin-top: 4px;
     margin-bottom: 4px;
     padding: 6px 8px 6px 8px;
     border: solid 1px #b8cfe6;
     background-color: #f2f9ff;
   }
  </style>
  <script type="text/javascript" src="js/base64.js"></script>
  <script language="JavaScript" type="text/javascript">
    var rawFqdnSection = null;
    var wbrFqdnSection = null;
    var wbrPathSection = null;
    <%-- Note: pageContext.request.scheme does not report the correct protocol due to the reverse proxy. --%>
    var protocol = location.protocol;
    var serverPort = location.port;
    function handleBodyLoad() {
       tle.toggleModal(true);
       setupHelp("<bean:message bundle="helpFiles" key="help.vm.bookmark"/>");
       rawFqdnSection = "<c:out value="${pageContext.request.serverName}"/>";
       if (!isNull(serverPort) && serverPort != "") {
          if (protocol == "http:" && serverPort != "80") {
             rawFqdnSection += ":" + serverPort;
          } else if (protocol == "https:" && serverPort != "443") {
             rawFqdnSection += ":" + serverPort;
          }
       }
  
       wbrFqdnSection = insertWordBreak(rawFqdnSection, '.');
       wbrPathSection = insertWordBreak("<c:out value="${pageContext.request.contextPath}"/>", '/');

       handleCheckboxSelection();
    }

    function handleCheckboxSelection() {
       var ui = 0;
       if (document.forms[0].rcView.checked) {
          ui |= <%= VmDirectAction.TABS_DISABLE %>;
       } else {
          ui |= <%= VmDirectAction.TABS_SHOW %>;
       }
       
       if (document.forms[0].svView.checked) {
          ui |= <%= VmDirectAction.INVENTORY_DISABLE %>;
       } else {
          ui |= <%= VmDirectAction.INVENTORY_SHOW %>;
       }
       
       var queryStringBase64 = 
          toBase64("<%= VmDirectAction.PARAM_NAME_WSURL %>=${contextUser.wsUrl}" +
                   "&<%= VmDirectAction.PARAM_NAME_VM_ID %>=<c:out value='${vmId}' />" +
                   "&<%= VmDirectAction.PARAM_NAME_UI %>=" + ui);
       <%-- Attach a suffix to the VMdirect URL to verify whether the user has entered the URL to its entirety. --%>
       queryStringBase64 += "<%= VmDirectAction.QUERY_STRING_SUFFIX %>";
       var wbrQuerySection = insertWordBreak(queryStringBase64, '');
       
       document.getElementById("bmURLTxt").innerHTML = protocol + "//<wbr>" + 
          wbrFqdnSection + wbrPathSection + "/<wbr>vmDirect.do?<wbr>view=<wbr>" + wbrQuerySection;
    }
    
    function handleButtonClick(strBrowser){
       if (document.getElementById("dialog") != null){
          document.getElementById("dialog").style.display="none";
       }
       tle.toggleModal(false);
       tle.getWorkspacePane().onTabSelect(strBrowser);
    }
    
    <%--
      insertWordBreak --
         Inserts word break immediately after encountering the 
         break-point value. If the break-point-string is
         not specified then a word break will be inserted after
         every character in the original string:
    --%>
    function insertWordBreak(originalString, breakPoint) {
       var retval = "";
       var oStringArr = originalString.split(breakPoint);
       var oStringLen = oStringArr.length - 1; // Prevent adding a wbr after the last word.
       
       for (i = 0; i < oStringLen; i++) {
          retval += oStringArr[i] + breakPoint + "<wbr>";
       }
       retval += oStringArr[i];
       return retval;
    }
  </script>
 </head>
 <body onload="handleBodyLoad();" onunload="resetHelp();">
  <div class="dialog half" id="dialog">
   <%-- Begin titlebar --%>
   <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="vm-16x16 icon"></div></td>
        <td width="100%">
          <span id="l10n_vmBookmark_header" name="l10n_vmBookmark_header" class="title">
            <bean:message key="wizard.vmDirect.window.title"/>
          </span>
        </td>
        <td>
         <div class="close-12x12 icon" title="<bean:message key="vmConfiguration.button.cancel"/>"
            onclick="document.forms[0].btnClose.click()">
         </div>
        </td>
      </tr>
    </table>
   </div>
  <%-- End titlebar --%>
  <div class="window">
   <div style="padding-bottom:10px"><bean:message key="wizard.vmDirect.section.instructions" /></div>
    <form>
     <div class="fieldset"> <%-- Begin User Interface Feature --%>
      <span class="legend"><bean:message key="wizard.vmDirect.section.userInterfaceFeature.heading" /></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
       <tr><td colspan="2"><div class="description"><bean:message key="wizard.vmDirect.section.userInterfaceFeature.subheading" /></div></td></tr>
       <tr>
        <td class="bulletCtrl"><input onclick="handleCheckboxSelection();" type="checkbox" name="rcView" class="checkboxCtrl" checked="true"/></td>
        <td>
         <label class="title"><bean:message key="wizard.vmDirect.section.userInterfaceFeature.checkbox.remoteConsoleView.heading" /></label>
         <div class="description"><bean:message key="wizard.vmDirect.section.userInterfaceFeature.checkbox.remoteConsoleView.subheading" /></div>
        </td>
       </tr>
       <tr>
        <td class="bulletCtrl"><input onclick="handleCheckboxSelection();" type="checkbox" name="svView" class="checkboxCtrl" checked="true"/></td>
        <td>
         <label class="title"><bean:message key="wizard.vmDirect.section.userInterfaceFeature.checkbox.singleVmView.heading" /></label>
         <div class="description"><bean:message key="wizard.vmDirect.section.userInterfaceFeature.checkbox.singleVmView.subheading" /></div>
        </td>
       </tr>
       <tr>
        <td class="bulletCtrl" style="padding-top:2px"><img src="imx/information-12x12.png" /></td>
        <td><div class="description"><bean:message key="wizard.vmDirect.section.userInterfaceFeature.note" /></div></td>
       </tr>
      </table>
     </div> <%-- End User Interface Feature --%>
     
     <div class="fieldset">  <%-- Begin Generated URL --%>
      <span class="legend"><bean:message key="wizard.vmDirect.section.generatedURL.heading" /></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
       <tr><td><div class="description" style="padding-top:2px"><bean:message key="wizard.vmDirect.section.generatedURL.subheading" /></div></tr></td>
       <tr>
        <td>
         <div class="url">
          <div id="bmURLTxt" class="description"></div>
         </div>
        </td>
       </tr>
      </table>
     </div> <%-- End Generated URL --%>
     
     <div class="commandButtons">
      <input onclick="handleButtonClick('<%= Constants.TAB_VM_SUMMARY %>');" type="button" value="<bean:message key="wizard.vmDirect.commandButton.value" />" class="buttonCtrl" id="btnClose">
     </div>
    </form>
  </div>  <%-- window --%>
 </body>
</html:html>
