/*
 * Copyright 2005 VMware, Inc.  All rights reserved. -- VMware Confidential 
 */

/* NOTICE: this javascript is not to be referenced directly! Include the corresponding
 * /WEB-INF/jsp/bars/toolbarJs.jsp instead. The JSP includes a reference to the
 * power operations (powerOpJs.jsp) needed for this script to work.
 */

function Toolbar () {
// private:

   var ICON_STATE_NORMAL   = 0;
   var ICON_STATE_SELECTED = 1;
   var ICON_STATE_DISABLED = 2;
   var ICON_STATE_TRANSIENT = 3;
   
   //for MKS Menu Items
   var DISABLED = 1;
   var ENABLED = 0;
   
   var categories = ["toolbarMenus", "toolbarIcons", "upperCurve"];
   var categoryElements = {};


   var powerIcons = ["powerOff", "suspend", "powerOn", "reset",
                     "poweringOff", "suspending", "poweringOn"];
   var powerIconElements = {};

   var powerStates = {
      "powerOn"      : {"powerOff"     : ICON_STATE_NORMAL,
                        "suspend"      : ICON_STATE_NORMAL,
                        "powerOn"      : ICON_STATE_SELECTED,
                        "reset"        : ICON_STATE_NORMAL },
      "powerOff"     : {"powerOff"     : ICON_STATE_SELECTED,
                        "suspend"      : ICON_STATE_DISABLED,
                        "powerOn"      : ICON_STATE_NORMAL,
                        "reset"        : ICON_STATE_DISABLED },
      "suspend"      : {"powerOff"     : ICON_STATE_DISABLED,
                        "suspend"      : ICON_STATE_SELECTED,
                        "powerOn"      : ICON_STATE_NORMAL,
                        "reset"        : ICON_STATE_DISABLED },
      "poweringOn"   : {"powerOff"     : ICON_STATE_DISABLED,
                        "suspend"      : ICON_STATE_DISABLED,
                        "powerOn"      : ICON_STATE_TRANSIENT,
                        "reset"        : ICON_STATE_DISABLED },
      "poweringOff"  : {"powerOff"     : ICON_STATE_TRANSIENT,
                         "suspend"     : ICON_STATE_DISABLED,
                         "powerOn"     : ICON_STATE_DISABLED,
                         "reset"       : ICON_STATE_DISABLED },
      "suspending"   : { "powerOff"    : ICON_STATE_DISABLED,
                         "suspend"     : ICON_STATE_TRANSIENT,
                         "powerOn"     : ICON_STATE_DISABLED,
                         "reset"       : ICON_STATE_DISABLED }
                     
   }  
   
   powerStates.reset = powerStates.powerOn;
   
   var currentState = "";
   var _powerStatesMap  = null;
   var _powerActionsMap = null;
   var FULLSCREEN = "fullscreen";
   var _mksControls = null;
   var mksIcons = [ "fullscreen" ];
   var mksCtrls = { "fullscreen" : ICON_STATE_DISABLED };
   var mksMenuCtrls = { "fullscreen" : DISABLED, "sendCAD" : DISABLED };
   var mksIconElements = {};

// public:

   /**
    * init --
    *     Initialize the tool bar buttons.
    *
    * @params powerStatesMap
    *      Maps VMODL power states to local power commands.
    * @params powerActionsMap
    *      Maps local power commands to action class power commands.
    */
   this.init = function (powerStatesMap, powerActionsMap) {
      _powerStatesMap  = powerStatesMap;
      _powerActionsMap = powerActionsMap;
      for (var i = 0; i < powerIcons.length; i++) {
         powerIconElements[powerIcons[i]] = powerIcons[i];
      }
      for (var i = 0; i < mksIcons.length; i++) {
         mksIconElements[mksIcons[i]] = mksIcons[i];
      }
      for (var i = 0; i < categories.length; i++) {
         categoryElements[categories[i]] = categories[i];
      }
   }
   
   /**
    * hide --
    *     Makes the toolbar appear or disappear. 
    *
    * @params toggle
    *     boolean flag if set to true will hide the toolbar.
    */
   this.hide = function (toggle) {
      vpx.xua.setStyle("toolbarNormal", "display", (toggle ? "none" : ""));
      vpx.xua.setStyle("toolbarModal", "display", (toggle ? "" : "none"));
   }

   /**
    * disablePowerStates --
    *     Disables all the power bar buttons. 
    *     The try-catch is because powerIconElements now includes the icons
    *     for transient states, which are not elements in the page.
    */
   this.disablePowerStates = function() {
      currentState = "";
      for (var icon in powerIconElements) {
         try {
            vpx.xua.setAttribute(powerIconElements[icon], "class", "icon disabled");
         } catch (e) {            
         }
      }
   }
   
   /**
    * disableIcons --
    *     Disables all the icons on the toolbar. Including the power state icons
    *     and the MKS control icons.
    *
    */
   this.disableIcons = function() {
      this.disablePowerStates();
      this.disableMKSControls(true);
   }

   /**
    * isCurrentState --
    *      Checks whether the passed in power state is the same
    *      as the selected power state on the toolbar.
    *
    * @param state 
    *      The power state of the selected VM.
    * @return 
    *      true if the power state is the same as the selected state.
    */
   this.isCurrentState = function(state) {      
      return currentState == _powerStatesMap[state];
   }

   /**
    * doPowerOpIfPermitted --
    *     Performs the requested power operation if and only if the 
    *     operation is permitted. That is, if the button clicked is
    *     either disabled or selected then the button-click event will
    *     be ignored.
    *
    * @params op 
    *      The requested power operation.
    */
    this.doPowerOpIfPermitted = function(op) {
      var target;
      if (currentState.length <= 0) {
         return;
      }
      
             
      //switch here from the command to the target state
      //TODO: Are these necessary after the toolbar is set to use the actual power ops, and not 'defaultPowerOps' ?
      switch(op){
         case 'defaultPowerOff':
         case 'shutDown':
            target = 'powerOff';
            break;
         case 'defaultSuspend':
            target = 'suspend';
            break;
         case 'defaultReset':
         case 'reboot':
            target = 'reset';
            break;
         default:
            target = op;
      }

     if (powerStates[currentState][target] == ICON_STATE_NORMAL) {
        doPowerOp(_powerActionsMap[op]);
     }
   }
   
   function findPowerIconElement(powerState, iconState) {
      for (var icon in powerStates[powerState]) {
         if (powerStates[powerState][icon] == iconState) {
            return powerIconElements[icon];
         }
      }
      return null;
   }
   
   /**
    * setupIcons_Internal --
    *     Enable, disable, select, and throb the power state icons.
    */
   function setupIcons_Internal (name, value) {
      var command = null;
      switch (name) {
         case 'overallPowerStatus':
            currentState = _powerStatesMap[value];
            
            // "_overallPowerStatus"  is a hidden field in toolbar.jsp. This was
            // introduced for QA automation purposes only. 
            // TODO - Remove the hidden varaible after QA testing.
            document.getElementById("_overallPowerStatus").value = currentState;
             
            var powerIconElement = findPowerIconElement(currentState, ICON_STATE_TRANSIENT);
            if (powerIconElement != null) {
               vpx.xua.setAttribute(powerIconElement, "class", "icon transient");
            } else {
               // This is the target state. 
               vpx.xua.setAttribute(powerIconElements[currentState], "class", "icon selected");
            }
            break;
         case "PowerOffVM":
            command = "powerOff";
            break;
         case "PowerOnVM":
            command = "powerOn";
            break;
         case "SuspendVM":
            command = "suspend";
            break;
         case "ResetVM":
            command = "reset";
            break;
         default:
            break;
      }
	    
      if (command != null) {
         // The server will request the clients to disable all the operations
         // if there is a running task. However, the client does not really have
         // to respect server's wish because both the transient and the selected
         // states are harmless therefore the user cannot perform the operation 
         // by clicking on the icons.
         if (powerStates[currentState][command] != ICON_STATE_TRANSIENT &&
             powerStates[currentState][command] != ICON_STATE_SELECTED) {
            if (value == "true") {
               powerStates[currentState][command] = ICON_STATE_DISABLED;
               vpx.xua.setAttribute(powerIconElements[command], "class", "icon disabled");
            } else {
               powerStates[currentState][command] = ICON_STATE_NORMAL;
               vpx.xua.setAttribute(powerIconElements[command], "class", "icon");
            }
         }
      }
   }   
   
   this.setupIcons = function (powerState, powerOff, powerOn, suspend, reset) {
      setupIcons_Internal("overallPowerStatus", powerState);
      setupIcons_Internal("PowerOnVM", powerOn ? "true" : "false");
      setupIcons_Internal("PowerOffVM", powerOff ? "true" : "false");
      setupIcons_Internal("SuspendVM", suspend ? "true" : "false");
      setupIcons_Internal("ResetVM", reset ? "true" : "false");
   }
   
   this.updateToolbar = function(change) {
      switch(change.property) {
         case 'powerOffType':
         case 'powerOffPreset':
            this.updateToolbarPowerOff(change.value);
            break;
         case 'resetType':
         case 'resetPreset':
            this.updateToolbarReset(change.value);
            break;
         default:
            setupIcons_Internal(change.property, change.value);
            break;
      }
   }
   
   /**
    * setupMenus --
    *     Takes the current powerstates as bool arguments and enables or disable
    *     the menu and the toolbar operations.
    *    
    *     The bool arguements are true if the menu item is to be disabled
    */
   this.setupMenus = function (powerOff, powerOn, suspend, reset, shutdownGuest, restartGuest) {
      disableVMMenuItem("powerOn", powerOn);
      disableVMMenuItem("powerOff", powerOff);
      disableVMMenuItem("suspend", suspend);
      disableVMMenuItem("reset", reset);
      disableVMMenuItem("shutdownGuest", shutdownGuest);
      disableVMMenuItem("restartGuest", restartGuest); 
   }   
   
   /**
    * updateVMMenu --
    *    Takes a command to be disabled on the VMmenu.
    */
   this.updateVMMenu = function(change) {
      var command = null;
      switch(change.property){
         case "PowerOffVM":
            command = "powerOff";
            break;
         case "PowerOnVM":
            command = "powerOn";
            break;
         case "SuspendVM":
            command = "suspend";
            break;
         case "ResetVM":
            command = "reset";
            break;
         case "ShutdownGuest":
            command = "shutdownGuest";
            break;
         case "RebootGuest":
            command = "restartGuest";
            break;
         default:
            break;
      }    
      
      if(command != null){
         //disableVMMenuItem requires a bool, but change.value is passing a string
         if(change.value == "false") {
            disableVMMenuItem(command, false);           
         } else {
            disableVMMenuItem(command, true);           
         }
      }
   }  
        
   /**
    * setMKSControls --
    *      Perform mks operations on this object.       
    *
    * @params mksControl
    *      The wrapper object.
    */
   this.setMKSControls = function(mksControls) {
      _mksControls = null;
      _mksControls = mksControls;
   }

   /**
    * disableMKSControls --
    *      Activates/Deactivates controls pertaining to MKS.         
    *
    * @params disable
    *      Flag to enable or diable mks controls.
    */
   this.disableMKSControls = function(disable) {
      for (var icon in mksCtrls) {
         if (disable) {
            mksCtrls[icon] = ICON_STATE_DISABLED;
            vpx.xua.setAttribute(mksIconElements[icon], "class", "icon disabled");
         } else {
            mksCtrls[icon] = ICON_STATE_NORMAL;
            vpx.xua.setAttribute(mksIconElements[icon], "class", "icon");
         }
      }
      
      for (var item in mksMenuCtrls) {
         if (disable) {
            mksMenuCtrls[item] = DISABLED;
            disableVMMenuItem(item, true);
         } else {
            mksMenuCtrls[item] = ENABLED;
            disableVMMenuItem(item, false);
         }
      } 
   }

   /**
    * doMksOp --
    *     Performs the requested mks operation if and only if the 
    *     operation is permitted. That is, if the button clicked is
    *     disabled or if the controller does not exist then the 
    *     button-click event will be ignored.
    *
    * @params op 
    *      The requested mks operation.
    */
   this.doMksOp = function(op) {
      if (_mksControls != null) {
         if (mksCtrls[op] == ICON_STATE_NORMAL) {
            switch (op) {
               case FULLSCREEN :
                  _mksControls.enterFullScreen();
                  break;
            }
         } else if (mksMenuCtrls[op] == ENABLED) {
            switch (op) {
               case "sendCAD" :
                  _mksControls.sendCAD();
                  break;
            }
         }
      }
   }
   
   /**
    * Changes the type of power off the toolbar power off button calls.
    * If arguments are invalid, the button is defaulted to a hard power off.
    */
    
    this.updateToolbarPowerOff = function(powerOffType, powerOffPreset) {
       var newOp = null;
       if (powerOffType == virtualMachinePowerOpType_Preset) {
          if (powerOffPreset == virtualMachinePowerOpType_Soft) {
             newOp = "shutDown";
          } else {
             //powerOff type is preset to hard power off
             newOp = "powerOff";
          }
       } else if (powerOffType == virtualMachinePowerOpType_Soft) {
          //power off type is soft power off
          newOp = "shutDown";
       } else {
          //power off type is hard power off. This is the default action.
          newOp = "powerOff";
       }            
       
       var newJs = "javascript:toolbar.doPowerOpIfPermitted('" + newOp + "');"
       var powerOffLink = vpx.xua.getElement("powerOff").parentNode;
       vpx.xua.setAttribute(powerOffLink, "href", newJs);
       
    }
    
    /**
    * Changes the type of reset the toolbar reset button calls.
    * If arguments are invalid, the button is defaulted to a hard reset.
    *
    */
    
    this.updateToolbarReset = function(resetType, resetPreset) {
    
       var newOp = null;
       if (resetType == virtualMachinePowerOpType_Preset) {
          if (resetPreset == virtualMachinePowerOpType_Soft) {
             newOp = "reboot";
          } else {
             //reset type is preset to hard reset
             newOp = "reset";
          }
       } else if (resetType == virtualMachinePowerOpType_Soft) {
          //reset type is soft reboot
          newOp = "reboot";
       } else {
          //reset type is hard reset. This is the default action.
          newOp = "reset";
       }   
       var newJs = "javascript:toolbar.doPowerOpIfPermitted('" + newOp + "');"
       var resetLink = vpx.xua.getElement("reset").parentNode;
       vpx.xua.setAttribute(resetLink, "href", newJs);
    }
    
    
}
var toolbar = null;
