function ChangeSet(){
   this.arrChanges = new Array();
   
   this.addChange = ChangeSet_addChange;
   this.clearChanges = ChangeSet_clearChanges;
   this.getChanges = ChangeSet_getChangeSet;
   
   this.toString = ChangeSet_toString;
}

function ChangeSet_addChange(objChange){
   if (objChange != null){
      this.arrChanges[this.arrChanges.length] = objChange;
   }
}

function ChangeSet_clearChanges(){
   this.arrChanges = null;
   this.arrChanges = new Array();
}

function ChangeSet_getChangeSet(){
   return (this.arrChanges.length != 0) ? this.arrChanges : null;
}

function ChangeSet_toString(){
   var strDesc = "";
   if (this.arrChanges.length==0) {
      strDesc += "No Changes";
   } else {
      for (var i=0; i < this.arrChanges.length; i++){
         strDesc += "\n\nChange " + i + ": ";
         strDesc += "\n" + this.arrChanges[i].toString();
      }
   } 
   return strDesc;
}

/* -------------------------------------------------------------------------- */

function Change(strItemId, strType, strPropertyName, strValue){
   this.id = strItemId;
   this.type = strType;
   this.propertyName = strPropertyName;
   this.value = strValue;
   
   this.getId = Change_getId;
   this.getType = Change_getType;
   this.getPropertyName = Change_getPropertyName;
   this.getValue = Change_getValue;
   
   this.toString = Change_toString;
}

function Change_getId(){
   return this.id;
}

function Change_getType(){
   return this.type;
}

function Change_getPropertyName(){
   return this.propertyName;
}

function Change_getValue(){
   return this.value;
}

function Change_toString(){
   var strDesc = "";
   strDesc += "\nID: " + this.id;
   strDesc += ";Type: " + this.type;
   strDesc += ";Property Name: " + this.propertyName;
   strDesc += ";New Value: " + this.value;
   return strDesc;
}