var canInteractConnect = true;
var poweredOn = false;

function disableStatusSettings (boolConOnly) {
  document.getElementById("connected").disabled = true;
  document.getElementById("l10n_vmConfiguration_device_status_connected").className = "disabled";
  if (!(boolConOnly == true)) {
    document.getElementById("connectAtPowerOn").disabled = true;
    document.getElementById("l10n_vmConfiguration_device_status_connectPowerOn").className = "disabled";
  }
}

function toggleDriveSource(){

  var boolDevice = document.getElementById("device").checked;
  var boolIso = document.getElementById("iso").checked;
  var boolHostMedia = document.getElementById("hostMedia").checked;

  document.forms[0]["deviceLocation"].disabled = !boolDevice;
  document.getElementById("deviceLocationLabel").className = boolDevice ? "" : "disabled";

  document.getElementById("emulate").disabled = !boolDevice;
  document.getElementById("emulateLabel").className = boolDevice ? "" : "disabled";

  document.getElementById("passthru").disabled = !boolDevice;
  document.getElementById("passthruLabel").className = boolDevice ? "" : "disabled";
  
  if (document.getElementById("exclusive")) {  
    document.getElementById("exclusive").disabled = !boolDevice;  
    document.getElementById("exclusiveLabel").className = boolDevice ? "" : "disabled";  
  }   

  if (boolDevice) {
    document.getElementById("passthru").checked = !document.getElementById("emulate").checked;
    if (document.getElementById("exclusive")) {  
        document.getElementById("exclusive").disabled = document.getElementById("emulate").checked;  
    }      
    if ( (hostPassthrough == "") && boolHostMedia) {
      document.getElementById("passthru").disabled = true;
      document.getElementById("passthruLabel").className = "disabled";
      document.getElementById("emulate").checked = true;
      if (document.getElementById("exclusive")) {  
        document.getElementById("exclusive").disabled = true;  
        document.getElementById("exclusiveLabel").className = "disabled";  
      }  
    }
  }

   document.getElementById("isoLocationLabel").className = boolIso ? "" : "disabled";
   document.forms[0]["isoLocation"].disabled = !boolIso;

   // Since the file input changes the color as a single property, changing the class
   // afterwards would not effect it. First remove any color specified in earlier steps.
   document.getElementById("browseIso").style.color="";
   document.getElementById("browseIso").className = boolIso ? "browse" : "browse disabled";

   setBrowseSrc();
}

function toggleEmulationType() {  
   if (document.getElementById("exclusive")) {  
      var atapiEmulation = document.getElementById("emulate").checked;  
      document.getElementById("exclusive").disabled = atapiEmulation;  
      document.getElementById("exclusiveLabel").className = !atapiEmulation ? "" : "disabled";  
   }  
}  


function toggleMedia(){
   var boolClientMedia = document.getElementById("clientMedia").checked;
   if (canInteractConnect) {
      document.getElementById("connectAtPowerOnLabel").className = !boolClientMedia ? "" : "disabled";
      document.forms[0]["connectAtPowerOn"].disabled = boolClientMedia;
   }

   document.getElementById("iso").disabled = boolClientMedia;
   document.getElementById("l10n_vmConfiguration_device_connection_isoImage").className = !boolClientMedia ? "" : "disabled";

   if (boolClientMedia) {
      if (canInteractConnect) {
         document.forms[0]["connectAtPowerOn"].checked = false;
      }
      if(poweredOn) {
        document.getElementById("iso").disabled = false;
        document.getElementById("l10n_vmConfiguration_device_connection_isoImage").className = "";
      } else {
        document.getElementById("device").checked = true;
      }
   }
   toggleDriveSource();

   setBrowseSrc();
}

function setIdeNode(strNodeValue){
   document.getElementById("ideNode").value = strNodeValue;
}

function setBrowseSrc(){
   var browse = document.getElementById("browseIso");
   if(!document.getElementById("iso").checked){
      browse.href = "javascript:;";
      initFileInput(true);
   } else {
      if (document.getElementById("clientMedia").checked){
         initFileInput();
         browse.href = "javascript:vpx.xua.getElement('fileinput').click();";
      } else {
         initFileInput(true);
         browse.href = "javascript:handleOpenDialog();";
      }
   }
}

// When the browsing is not client browsing, the file input functionality should not
// be invoked. Setting its display to none does not acheive the affect needed.
// KISS - a clear flag was introduced. When file input is not needed, move it
// out of the screen.

function initFileInput(boolClear) {
   var io = vpx.xua.getElement("isoLocation");
   var lo = vpx.xua.getElement("browseIso");
   var fo = vpx.xua.getElement("file");
   
   if (boolClear == true){
      vpx.xua.setPosition(fo, -500, -500);
      return;
   }
   
   if (vpx.xua.ie == false) {
      vpx.xua.setOpacity(fo, 0);
      vpx.xua.setZ(io, 2);
   } else {
      vpx.xua.setStyle(fo, "visibility", "hidden");
   }
   
   vpx.xua.setPosition(fo, vpx.xua.getPosition(lo).x  + vpx.xua.getDimension(lo).w - vpx.xua.getDimension(fo).w, vpx.xua.getPosition(io).y, 1);
}

function disableMedia(){
  document.getElementById("l10n_vmConfiguration_device_media_hostMedia").className = "disabled";
  document.getElementById("l10n_vmConfiguration_device_media_hostMedia_expl").className = "disabled";
  document.getElementById("hostMedia").disabled = true;

  document.getElementById("l10n_vmConfiguration_device_media_clientMedia").className = "disabled";
  document.getElementById("l10n_vmConfiguration_device_media_clientMedia_expl").className = "disabled";
  document.getElementById("clientMedia").disabled = true;
}

function disableVirtualDevice() {
  document.getElementById("l10n_vmConfiguration_virtualDevice").className = "legend disabled";
  document.getElementById("l10n_vmConfiguration_virtualDevice_node_ide").className = "disabled";
  document.forms[0].ideNode.disabled = true;
}

function disableConnection() {
  document.getElementById("l10n_vmConfiguration_device_connection").className = "legend disabled";
  document.getElementById("l10n_vmConfiguration_device_connection_physicalDrive").className = "disabled";
  document.getElementById("deviceLocationLabel").className = "disabled";
  document.getElementById("device").disabled = true;
  document.forms[0].deviceLocation.disabled = true;

  document.getElementById("passthru").disabled = true;
  document.getElementById("passthruLabel").className = "disabled";
  document.getElementById("emulate").disabled = true;
  document.getElementById("emulateLabel").className = "disabled";

  document.getElementById("l10n_vmConfiguration_device_connection_isoImage").className = "disabled";
  document.getElementById("isoLocationLabel").className = "disabled";
  document.getElementById("iso").disabled = true;
  document.getElementById("isoLocation").disabled = true;
  document.getElementById("browseIso").className = "browse disabled";
  document.getElementById("browseIso").href = "javascript:;";
  
  if (document.getElementById("exclusive")) {  
    document.getElementById("exclusive").disabled = true;  
    document.getElementById("exclusiveLabel").className = "disabled";  
  }  

}

function disableAllStatusSettings() {
  document.getElementById("l10n_vmConfiguration_device_status").className = "legend disabled";
  disableStatusSettings();
}

/* what is block-commented out in the function body is used for customizing the native file browser */
function disableBrowse() {
  initFileInput(true);
  document.getElementById("browseIso").style.color = "";
  document.getElementById("browseIso").className = "browse disabled";
  document.getElementById("browseIso").href = "javascript:;";
}

function disableAll(){
  disableMedia();
  disableAllStatusSettings();
  disableConnection();
  disableVirtualDevice();
  disableBrowse();
}

/* what is commented out in the function body is used for customizing the native file browser */
function clientDeviceLock(boolLock, boolHasPriv){
  if (boolLock == true) {
    initFileInput(true);
    document.getElementById("clientDeviceLock").style.display = "";
    document.getElementById("noLock").style.display = "none";
    if (boolHasPriv != null && boolHasPriv == false) {
      document.getElementById("l10n_vmConfiguration_device_status_connected_clientDevice_lock_expl").className = "disabled";
      document.getElementById("a_disconnect").href = "javascript:;";
      document.getElementById("l10n_vmConfiguration_device_status_connected_clientDevice_disconnect").className = "disabled";
      document.getElementById("a_moreInfo").href = "javascript:;";
      document.getElementById("l10n_vmConfiguration_moreInfo").className = "disabled";
    }
  } else {
    document.getElementById("clientDeviceLock").style.display = "none";
    document.getElementById("noLock").style.display = "";
  }
}

function disableClientMedia(){
  document.getElementById("hostMedia").checked = true;
  document.getElementById("clientMedia").disabled = true;
  document.getElementById("ttl_clientMedia").className = "title disabled";
  document.getElementById("desc_clientMedia").className = "description disabled";
}

function handleOpenDialog() {
   var rootUrl = "datastoreBrowserSetup.do?type=cdDvd";
   var rs = new vpx.win.RootSpec(new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, rootUrl));

   var msgBox = new vpx.win.Frame(null /* contentSpec */, null /* frameSpec */, rs, self);

   msgBox.listen("ready", function (o) {
      o.setPlacementPolicy(o.PLACEMENT_POLICY_CENTER);
      o.setModal(true);
      o.open();
   });

   msgBox.listen("okay", respond.bind(msgBox));

   msgBox.init();
}

function respond() {
  if (this.selectedItem != null) {
    document.getElementById("isoLocation").value=this.selectedItem;
  }
}

function nodeToMksNode(strNode) {
  return "ide" + strNode.substring(0,strNode.lastIndexOf(":"));
}
