function toggleIndp(){
   var boolIndp = document.getElementById("independent").checked;
   document.getElementById("persistent").disabled = !boolIndp;
   document.getElementById("l10n_vmConfiguration_hd_diskMode_persistent_label").className = (boolIndp) ? "" : "disabled";
   document.getElementById("l10n_vmConfiguration_hd_diskMode_persistent_desc").className = (boolIndp) ? "" : "disabled";
   document.getElementById("nonPersistent").disabled = !boolIndp;
   document.getElementById("l10n_vmConfiguration_hd_diskMode_nonPersistent_label").className = (boolIndp) ? "" : "disabled";
   document.getElementById("l10n_vmConfiguration_hd_diskMode_nonPersistent_desc").className = (boolIndp) ? "" : "disabled";
   if (boolIndp && !document.getElementById("persistent").checked
     && !document.getElementById("nonPersistent").checked) {
     document.getElementById("persistent").checked = true;
   }
}

function unlockScsiCtrl(){
   document.getElementById("lockedScsi").style.display = "none";
   document.getElementById("unlockedScsi").style.display = "";
}

function toggleScsiCtrl(boolLock){
   document.getElementById("lockedScsi").style.display = boolLock ? "" : "none";
   document.getElementById("unlockedScsi").style.display = boolLock ? "none" : "";
}

function setCompatibility(){
  if (document.getElementById("physical").checked) {
    disableCompV();
    disableDiskMode();
  } else {
    disableCompP();
  }
}

function disableDiskImage() {
  if (document.getElementById("fldSet_DiskImage") == null) {
    return;
  }
  document.getElementById("l10n_vmConfiguration_hd_virtual_diskImage").className = "legend disabled";
  document.getElementById("lbl_datastore").className = "disabled";
  document.getElementById("vl_datastore").className = "disabled";
  document.getElementById("lbl_fileName").className = "disabled";
  document.getElementById("vl_fileName").className = "disabled";
  document.getElementById("lbl_capacity").className = "disabled";
  document.getElementById("vl_capacity").className = "disabled";
}

function disableLunDisk() {
  if (document.getElementById("fldSet_systemLUN") == null) {
    return;
  }
  document.getElementById("l10n_vmConfiguration_hd_sysLun").className = "legend disabled";
  document.getElementById("lbl_tgtDevice").className = "disabled";
  document.getElementById("vl_tgtDevice").className = "disabled";
  document.getElementById("lbl_capacity").className = "disabled";
  document.getElementById("vl_capacity").className = "disabled";
}

function disableMetadata() {
  if (document.getElementById("fldSet_metadata") == null) {
    return;
  }
  document.getElementById("l10n_vmConfiguration_hd_metadata").className = "legend disabled";
  document.getElementById("lbl_datastore").className = "disabled";
  document.getElementById("vl_datastore").className = "disabled";
  document.getElementById("lbl_fileName").className = "disabled";
  document.getElementById("vl_fileName").className = "disabled";
}

function disableCompatibility() {
  if (document.getElementById("fldSet_compatibility") == null) {
    return;
  }
  document.getElementById("l10n_vmConfiguration_hd_rdm_comptability").className = "legend disabled";
  disableCompP();
  disableCompV();
}

function disableDiskMode() {
  document.getElementById("l10n_vmConfiguration_hd_diskMode").className = "legend disabled";
  if (document.getElementById("independent") != null) {
    document.getElementById("independent").disabled = true;
    document.getElementById("lbl_independent").className = "title disabled";
    document.getElementById("desc_independent").className = "description disabled";
    document.getElementById("persistent").disabled = true;
    document.getElementById("lbl_persistent").className = "title disabled";
    document.getElementById("desc_persistent").className = "description disabled";
    document.getElementById("nonPersistent").disabled = true;
    document.getElementById("lbl_nonPersistent").className = "title disabled";
    document.getElementById("desc_nonPersistent").className = "description disabled";
  } else {
    document.getElementById("persistent").disabled = true;
    document.getElementById("lbl_persistent").className = "title disabled";
    document.getElementById("desc_persistent").className = "description disabled";
    document.getElementById("nonPersistent").disabled = true;
    document.getElementById("lbl_nonPersistent").className = "title disabled";
    document.getElementById("desc_nonPersistent").className = "description disabled";
    document.getElementById("undoable").disabled = true;
    document.getElementById("lbl_undoable").className = "title disabled";
    document.getElementById("desc_undoable").className = "description disabled";
    document.getElementById("append").disabled = true;
    document.getElementById("lbl_append").className = "title disabled";
    document.getElementById("desc_append").className = "description disabled";
  }
}

function disableVirtualDevice(){
  /* Since users cannot modify the scsi controller when the virtual device
      is disabled, the lock message and the link will not be presented.
     No need to deal with disabling the elements that relate to the lock message.
  */
  document.getElementById("l10n_vmConfiguration_virtualDevice").className = "legend disabled";
  document.getElementById("scsiNode").disabled = true;
  document.getElementById("lbl_scsiNode").className = "disabled";
}

function disableCompP(){
  document.getElementById("physical").disabled = true;
  document.getElementById("lbl_physical").className = "title disabled";
  document.getElementById("desc_physical").className = "description disabled";
}

function disableCompV(){
  document.getElementById("virtual").disabled = true;
  document.getElementById("lbl_virtual").className = "title disabled";
  document.getElementById("desc_virtual").className = "description disabled";
}

function disableAll() {
  disableDiskImage();
  disableLunDisk();
  disableMetadata();
  toggleScsiCtrl(false);
  disableVirtualDevice();
  disableCompatibility();
  disableDiskMode();
}