function toggleConnection() {

   var boolPhysical = document.getElementById("physicalConnection").checked;
   var boolFile = document.getElementById("fileConnection").checked;
   var boolPipe = document.getElementById("pipeConnection").checked;

   document.getElementById("physicalPortLabel").className = boolPhysical ? "" : "disabled";
   document.forms[0].physicalLocation.disabled = !boolPhysical;

   document.getElementById("filePortLabel").className = boolFile ? "" : "disabled";
   document.forms[0].fileLocation.disabled = !boolFile;
   document.getElementById("browseFile").className = boolFile ? "browse" : "browse disabled";


   document.getElementById("pipePortLabel").className = boolPipe ? "" : "disabled";
   document.getElementById("nearEndTypeLabel").className = boolPipe ? "" : "disabled";
   document.getElementById("farEndTypeLabel").className = boolPipe ? "" : "disabled";
   document.forms[0].pipeLocation.disabled = !boolPipe;
   document.forms[0].nearEndType.disabled = !boolPipe;
   document.forms[0].farEndType.disabled = !boolPipe;

   setBrowse();

}

function disableConnectionSettings() {
  
  document.getElementById("l10n_vmConfiguration_device_connection").className = "legend disabled";

	document.getElementById("title_physicalConnection").className = "title disabled";
  document.getElementById("physicalConnection").disabled = true;
  document.getElementById("title_fileConnection").className = "title disabled";
  document.getElementById("fileConnection").disabled = true;
  document.getElementById("title_pipeConnection").className = "title disabled";
	document.getElementById("pipeConnection").disabled = true;

  document.getElementById("physicalPortLabel").className = "disabled";
  document.forms[0].physicalLocation.disabled = true;

  document.getElementById("filePortLabel").className = "disabled";
  document.forms[0].fileLocation.disabled = true;
  document.getElementById("browseFile").className = "browse disabled";
  document.getElementById("browseFile").href = "javascript:;";

  document.getElementById("pipePortLabel").className = "disabled";
  document.getElementById("nearEndTypeLabel").className = "disabled";
  document.getElementById("farEndTypeLabel").className = "disabled";
  document.forms[0].pipeLocation.disabled = true;
  document.forms[0].nearEndType.disabled = true;
  document.forms[0].farEndType.disabled = true;

}

function disableIOMode() {
  document.getElementById("l10n_vmConfiguration_serialPort_ioMode").className = "legend disabled";
	document.forms[0].yieldOnPollDisabled.value = "disabled";
	document.getElementById("yieldOnPoll").disabled = true;
	document.getElementById("title_yieldOnPoll").className = "title disabled";
	document.getElementById("l10n_vmConfiguration_serialPort_ioMode_yield_expl").className = "disabled";
}

function disableStatusSettings (boolConOnly) {
  document.getElementById("connected").disabled = true;
  document.getElementById("l10n_vmConfiguration_device_status_connected").className = "disabled";
  if (!(boolConOnly == true)) {
    document.getElementById("connectAtPowerOn").disabled = true;
    document.getElementById("l10n_vmConfiguration_device_status_connectPowerOn").className = "disabled";
  }
}

function disableAllStatusSettings(){
  document.getElementById("l10n_vmConfiguration_device_status").className = "legend disabled";
  disableStatusSettings();
}

function disableAll() {
	disableAllStatusSettings();
	disableConnectionSettings();
	disableIOMode();
}

function setBrowse() {
  var boolFile = document.getElementById("fileConnection").checked;
  var aBrowse = document.getElementById("browseFile");
  if (boolFile == true) {
    aBrowse.className = "browse";
    aBrowse.href = "javascript:handleOpenDialog();";
  } else {
    aBrowse.className = "browse disabled";
    aBrowse.href = "javascript:;";
  }
}

function handleOpenDialog() {
   var rootUrl = "datastoreBrowserSetup.do?type=serial";
   var rs = new vpx.win.RootSpec(new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, rootUrl));

   var msgBox = new vpx.win.Frame(null /* contentSpec */, null /* frameSpec */, rs, self);

   msgBox.listen("ready", function (o) {
      o.setPlacementPolicy(o.PLACEMENT_POLICY_CENTER);
      o.setModal(true);
      o.open();
   });

   msgBox.listen("okay", respond.bind(msgBox));

   msgBox.init();
}

function respond() {
  if (this.selectedItem != null) {
    document.getElementById("fileLocation").value=this.selectedItem;
  }
}