var _workspaceTitle, _workspaceTabs, _workspaceDetails,
   _workspaceTitleHeight, _workspaceTabsHeight,
   _minWidthOffset, _minHeightOffset;

function initEntityDetails(strEntityType, strEntityName, strTabName){
   if (strTabName!=null) {
      switchTab(strTabName);
   }
   setTitleBar(strEntityType, strEntityName);
}

function setTitleBar(strEntityType, strEntityName) {
   var titleFrame = vpx.xua.viewport.getView(_workspaceTitle);
   try {
      titleFrame.setTitleBar(strEntityType, strEntityName, "alarmOkay");
   } catch (e) {
      initPage();
      window.setTimeout(("setTitleBar('" + strEntityType +"', '" + strEntityName + "')"),100);
   }
}

function setTitleIcon(entityType) {
   var titleFrame = vpx.xua.viewport.getView(_workspaceTitle);
   try {
      titleFrame.setTitleIcon(entityType);
   } catch (e) {
      initPage();
      window.setTimeout("setTitleIcon('" + entityType + "')", 100);
   }
}

function setTitleLabel(entityName) {
   var titleFrame = vpx.xua.viewport.getView(_workspaceTitle);
   try {
      titleFrame.setTitleLabel(entityName);
   } catch (e) {
      initPage();
      window.setTimeout("setTitleLabel('" + entityName + "')", 100);
   }
}

function setTitleAlarm(state){
   var titleFrame = vpx.xua.viewport.getView(_workspaceTitle);
   try {
      titleFrame.setAlarmState(state);
   } catch (e) {
      initPage();
      window.setTimeout(("setTitleAlarm('" + state + "')"),100);
   }
}

function setTitleBarLoading(){
   var titleFrame = vpx.xua.viewport.getView(_workspaceTitle);
   try {
      titleFrame.setTitleBarLoading();
   } catch (e) {
      // do nothing - the title bar is not there
   }
}

function switchTab(strTabName){
   try {
      vpx.xua.viewport.getView(_workspaceTabs).syncTabs(strTabName);
   } catch (e) {
      initPage();
      window.setTimeout(("switchTab('" + strTabName +"')"),100);
   }
}

function onTabSelect(strTabName){
   setTitleBarLoading();
   vpx.xua.viewport.getView(_workspaceDetails).location.href = tabUrls[strTabName];
}

function initMinWidthAndHeightOffsets() {
   var b = document.body;

   if (! isDefined(_minWidthOffset)) {
      _minWidthOffset =
	 parseInt(vpx.xua.getStyle(b, "paddingLeft"), 10) +
	 parseInt(vpx.xua.getStyle(b, "paddingRight"), 10) +
	 parseInt(vpx.xua.getStyle(b, "borderLeftWidth"), 10) +
	 parseInt(vpx.xua.getStyle(b, "borderRightWidth"), 10);
   }

   if (! isDefined(_minHeightOffset)) {
      _minHeightOffset =
	 parseInt(vpx.xua.getStyle(b, "paddingTop"), 10) +
	 parseInt(vpx.xua.getStyle(b, "paddingBottom"), 10) +
	 parseInt(vpx.xua.getStyle(b, "borderTopWidth"), 10) +
	 parseInt(vpx.xua.getStyle(b, "borderBottomWidth"), 10);
   }
}

function resizeWorkspace() {
   initMinWidthAndHeightOffsets();

   var minWidth = vpx.xua.viewport.getWidth(self) - _minWidthOffset;

   var titleDim = vpx.xua.setDimension(_workspaceTitle, minWidth,
      _workspaceTitleHeight);
   var tabsDim = vpx.xua.setDimension(_workspaceTabs, minWidth,
      _workspaceTabsHeight);

   var minHeight = vpx.xua.viewport.getHeight(self) - _minHeightOffset;

   if (vpx.xua.getStyle(_workspaceTitle, "display") != "none") {
      minHeight -= titleDim.h;
   }

   if (vpx.xua.getStyle(_workspaceTabs, "display") != "none") {
      minHeight -= tabsDim.h;
   }

   vpx.xua.setDimension(_workspaceDetails, minWidth, minHeight);
   return true;
}

function initPage() {
   _workspaceTitle = $("workspaceTitle");
   _workspaceTabs = $("workspaceTabs");
   _workspaceDetails = $("workspaceDetails");
   if (! isDefined(_workspaceTitleHeight)) {
      _workspaceTitleHeight =
	 parseInt(vpx.xua.getStyle(_workspaceTitle, "height"), 10);
   }
   _workspaceTabsHeight =
      parseInt(vpx.xua.getStyle(_workspaceTabs, "height"), 10);

   vpx.xua.setStyle(_workspaceTabs, "display",
      (tle.viewSettings.tabsVisible ? "block" : "none"));
   vpx.xua.setStyle(_workspaceDetails, "display", "block");

   setTimeout(resizeWorkspace, 0);
   if (vpx.xua.ie) {
      // XXX: IE routinely does not fire resize events when the workspace frame
      // is resized at the same time the browser window is resized.
      vpx.xua.event.listen(self, "resize", resizeWorkspace);

      // In the VMDirect case the navigation pane may not exist.
      var browsersPane = tle.getBrowsersPane();
      if (isDefined(browsersPane)) {
         vpx.xua.event.listen(browsersPane, "resize", resizeWorkspace);
      }
   } else {
      vpx.xua.event.listen(window, "resize", resizeWorkspace);
   }
}

vpx.xua.event.listen(self, "load", initPage);

function initTitle() {
   var wsTitle = $("workspaceTitle");
   if (isDefined(wsTitle)) {
      if (! isDefined(_workspaceTitleHeight)) {
	 _workspaceTitleHeight =
	    parseInt(vpx.xua.getStyle(wsTitle, "height"), 10);
      }

      initMinWidthAndHeightOffsets();

      var minWidth = vpx.xua.viewport.getWidth(self) - _minWidthOffset;
      var minHeight = vpx.xua.viewport.getHeight(self) - _minHeightOffset;

      vpx.xua.setDimension(wsTitle, minWidth, minHeight);
   } else {
      setTimeout(initTitle, 1);
   }
}
initTitle();
