var isRefreshAllowed;

/**
 * Sets the window-scoped flag that specifies whether a page refresh is legal
 * in the current context.  If the state is changing such that a refresh is now
 * legal, the parent window will be notified so that it may refresh this window
 * if it is waiting on such action.
 *
 * @param b boolean
 *    true to flag the page as allowing refreshes; false to disallow
 */

function setAllowRefresh(b) {
   if (window.isRefreshAllowed == b) {
      return;
   }
   window.isRefreshAllowed = b;
   if (b) {
      __notifyRefreshAllowed();
   }
}


/**
 * Notifies the parent frame that a tab refresh is now allowed.  If the parent
 * frame has does not implement the appropriate callback, nothing happens.
 */

function __notifyRefreshAllowed() {
   var p = window.parent;
   if (isDefined(p.tabRefreshAllowed) && isFunction(p.tabRefreshAllowed)) {
      p.tabRefreshAllowed();
   }
}


/**
 * Initializes the refresh control system by setting the flag to
 * <code>true</code> and registering page teardown handlers.
 */

function __initRefreshControl() {
   vpx.xua.event.listen(window, "unload", __teardownRefreshControl);
   setAllowRefresh(true);
}


/**
 * Tears down the page refresh control by setting the flag to false.
 */

function __teardownRefreshControl() {
   setAllowRefresh(false);
   vpx.xua.event.ignore(window, "unload", __teardownRefreshControl);
}


__initRefreshControl();
