// general functions for switching tabs

var currentTab = null;
allTabs = null;
              
function clickTab(strTabName){
   var tab = $("detailsView_tabs_" + strTabName);
   if (isDefined(tab)) {
      var links = tab.getElementsByTagName("a");
      for (var i = 0; i < links.length; i++) {
         links[i].blur();
      }
   }
   
   if (!strTabName || "detailsView_tabs_" + strTabName == currentTab || !isFunction(clickTab.caller)) {
      //Don't try to change tabs if the tab doesn't exist,
      //or it is the currently selected tab already. 
      //Also, ignore the call from the <a> tag to prevent duplicate calls for 
      //   the same click.
      return;
   }
   
   syncTabs(strTabName);   
   
   // Execute the remaining items asynchronously so syncTabs() will trigger
   // repaint immediately.
   setTimeout(
      function () {
         var ws = vpx.xua.viewport.getPage.call(tle.getWorkspacePane(),
            "workspaceDetails");
	 if (isDefined(ws.body)) {
	    vpx.xua.setStyle(ws.body, "display", "none");
	 }
         window.parent.setTitleBarLoading();
         window.parent.onTabSelect(strTabName); 
      }, 0);
   }

function syncTabs(strTabName){
   if (!strTabName || strTabName == currentTab){
      return;
   }

   if(currentTab != null){
     unHighlightTab(currentTab);
   }
   try{
      currentTab = "detailsView_tabs_" + strTabName;
      highlightTab(currentTab);
   } catch (e) {
      currentTab = null;
      throw e;
   }
}

function highlightTab(strTabName){
   var tab = vpx.xua.getElement(strTabName);
   if (isNull(tab)) {
      return;
   }
   vpx.xua.removeClass(tab, 'detailsTab');
   vpx.xua.addClass(tab, 'detailsTabSelected');
}

function unHighlightTab(strTabName){
   var tab = vpx.xua.getElement(strTabName);
   if (isNull(tab)) {
         return;
   }
   vpx.xua.removeClass(tab, 'detailsTabSelected');
   vpx.xua.addClass(tab, 'detailsTab');
}

/**
 * Shows/Hides tabs on the VM detail page.
 *
 * @param show
 *      If true display the tabs else hide them.
 * @param tabs
 *      The tabs to be shown or to be hidden.
 *      If null then all the tabs in the page will
 *      be shown or hidden depending on the first
 *      argument.
 */
 
function toggle(show, tabs) {
   if (tabs == null || tabs == undefined || tabs.length <= 0) {
      showTabs(show, allTabs); // Do the deed for all the tabs in the page.
      return;
   }
   
   // Do the action only for the requested tabs.
   showTabs(!show, allTabs);
   showTabs(show, tabs);
}

/**
 * Shows/Hides tabs on the VM detail page.
 *
 * @param show
 *      If true display the tabs else hide them.
 * @param tabs
 *      The tabs to be shown or to be hidden.
 */
 
function showTabs(show, tabs) {
   if (tabs == null || tabs == undefined) {
      return;
   }
   
   for (var i = 0; i < tabs.length; i++) {
      showTab(show, tabs[i]);
   }
}

/**
 * Shows/Hides tab on the VM detail page.
 *
 * @param show
 *      If true displays the tab else hide it.
 * @param tabId
 *      The Id of the tab to be shown or to be hidden.
 */
 
function showTab(show, tabId) {
   var tab = document.getElementById("detailsView_tabs_" + tabId);
   if (isNull(tab)) {
      return;
   }
   tab.style.display = show ? "" : "none";
}

/**
 * Disables a tab on the VM detail page
 *
 * @param strTabName
 *      the tab ID
 */

function disableTab(strTabName) {
   unHighlightTab("detailsView_tabs_" + strTabName);
   //disable the <a> tags
   var td = document.getElementById("detailsView_tabs_" + strTabName);
   if (isNull(td)) {
      return;
   }
   var a = td.getElementsByTagName('a')[0];
   var div = td.getElementsByTagName('div')[0];
   var span = a.getElementsByTagName('span')[0];

   if (a != null && div != null && span != null ) {  
      div.onclick = function() { div.firstChild.blur(); };
      a.href='javascript:;';      
      vpx.xua.addClass(span, 'disabled');// disable the text
   }
}


/**
 * Enables a tab on the VM detail page (without highlighting it!) and sets its url
 *
 * @param strTabName
 *      the tab ID
 * @param strUrl
 *      the url to browse to when clicked
 */

function enableTab(strTabName, strUrl) {
   //enable the <a> tag
   var td = document.getElementById("detailsView_tabs_" + strTabName);
   if (isNull(td)) {
      return;
   }
   var a = td.getElementsByTagName('a')[0];
   var div = td.getElementsByTagName('div')[0];
   var span = a.getElementsByTagName('span')[0];
   
   if (a != null && div != null && span != null ) {
      vpx.xua.removeClass(span, 'disabled'); // enable the text
      //Restore the Div's onclick function (same as strURL minus the 'javascript:')
      div.onclick = function() { eval(strUrl.substring(11)); };
      a.href=strUrl;
   }
}

/** 
 * Disables all tabs on the VM detail page
 */
function disableAllTabs() {
   if (allTabs == null || allTabs == undefined) {
      return;
   }
   for (var i = 0; i < allTabs.length; i++) {
      disableTab(allTabs[i]);
   }
}
