var selectedElement = null;
var shadedElement = null;

/**
 * Runs setup code that can only be run once the html page body has loaded
 * completely.
 */
function handleBodyLoad(dialog) {
   tle.syncView();

   var c = vpx.context.curr;
   var heightPolicy = vpx.browser.Browser.HEIGHT_POLICY.USER;
   if (! isNull(dialog) && dialog == 'recentAlarms') {
      heightPolicy = vpx.browser.Browser.HEIGHT_POLICY.FIT;
   } else {
      window.parent.switchTab(c.TAB_NAME);
      window.parent.setTitleIcon("VM");
   }
   c.xmlSpec = new vpx.net.XmlSpec(c.XML_ACTION);
   c.xmlSpec.setAttribute(c.PARAM_NAME_ENTITY_ID, c.ENTITY_ID);
   c.xmlSpec.setAttribute("tabName", c.TAB_NAME);
   c.paginator = new vpx.browser.Paginator($("paginatorContainer"));
   c.browser = new vpx.browser.Browser($("browserContainer"), c.PAGE_SIZE, heightPolicy, true);
   c.paginator.setProvider(c.browser);
   if (!isNull(dialog) && dialog == 'tasks') {
     c.browser.registerListener(vpx.browser.EVENT.SELECTION, handleSelectionChanged);
   }
   c.browser.registerListener(vpx.browser.EVENT.SORT, handleSort);
   c.browser.registerListener(vpx.browser.EVENT.PAGE, handlePage);
   c.browser.registerListener(vpx.browser.EVENT.DATA, handleDataProcessed);
   c.browser.requestData(c.xmlSpec);
}

/**
 * Runs cleanup code that prepares the page to be safely destroyed.
 */
function handleBodyUnload() {
   var c = vpx.context.curr;

   if (c.updatesRunning) {
      vpx.log.info("Task Browser: Stopping updates");
      tle.ignoreUpdates(c.updatesId);
      c.updatesRunning = false;
   }
}

/**
 * Handles the event of the current Task browser's selected item having
 * changed.  It notifies the workspace pane of the selection.
 *
 * @param browser vpx.browser.Browser
 *    The object that fired the event
 */
function handleSelectionChanged(browser) {

   var c = vpx.context.curr;
   var frameId = c.FRAME_ID;
   if (isNull(frameId)) {
      return;
   }

   var selected = browser.getSelected()[0];
   if (isNull(selected)){
      return;
   }

   var slctdId = selected.getId();
   var action = c.SELECTION_ACTION + "?" + c.PARAM_NAME_SLCT_ID + "=" + escape(slctdId);
   c.xmlSpec.setAttribute(c.PARAM_NAME_SLCT_ID, slctdId);

   var viewId = c.xmlSpec.getAttribute(c.PARAM_NAME_VIEW_ID);
   if (!isNull(viewId)) {
      action += "&" + c.PARAM_NAME_VIEW_ID + "=" + escape(viewId);
      c.xmlSpec.setAttribute(c.PARAM_NAME_VIEW_ID, viewId);
   }

   window.frames[frameId].location.replace(action);
}

/**
 * Handles a GUI sort event for the current Task browser.  It issues a
 * sorting action command to the browser's xml spec and re-requests browser
 * data.
 *
 * @param browser vpx.browser.Browser
 *    The object that fired the event
 * @param column vpx.browser.Column
 *    The column being sorted on
 * @param sortOrder const String
 *    The sort type (e.g. vpx.browser.SORT.ASC)
 */
function handleSort(browser, column, sortOrder) {
   var c = vpx.context.curr;

   c.xmlSpec.setAttribute(c.PARAM_NAME_SORT_COL, column.getName());
   c.xmlSpec.setAttribute(c.PARAM_NAME_SORT_DIR, sortOrder);
   browser.requestData(c.xmlSpec);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_SORT_COL);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_SORT_DIR);
}

/**
 * Handles a GUI page event for the current Task browser.  It
 * issues the corresponding page action command to the browser's xml spec
 * and re-requests browser data.
 *
 * @param browser vpx.browser.Browser
 *    The object that fired the event
 * @param pageType const String
 *    The page command (e.g. vpx.browser.PAGE.FIRST)
 */
function handlePage(browser, pageType) {
   var c = vpx.context.curr;

   switch (pageType) {
      case vpx.browser.PAGE.PREV:
          c.xmlSpec.setAttribute(c.PARAM_NAME_PAGE, c.DC_PREV_PAGE);

          break;

      case vpx.browser.PAGE.NEXT:
          c.xmlSpec.setAttribute(c.PARAM_NAME_PAGE, c.DC_NEXT_PAGE);

          break;

      default: throw new Error("Unsupported page type: " + pageType);
   }

   browser.requestData(c.xmlSpec);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_PAGE);
}

/**
 * Handles the completion of data processing for the current Task
 * browser.  It turns on the updates agent for the browser's backing view
 * if the agent has not already been started.  This must be done after the
 * browser has processed data because we don't know the viewId until the
 * browser xml sets it as a response attribute.
 *
 * @param browser vpx.browser.Browser
 *    The object that fired the event
 * @param xmlSpec vpx.net.XmlSpec
 *    The xml spec used to request the data
 */
function handleDataProcessed(browser, xmlSpec) {
   var c = vpx.context.curr;

   var key = "viewId";

   if (! c.updatesRunning && xmlSpec.hasAttribute(key)) {
      c.updatesRunning = true;
      var viewId = xmlSpec.getAttribute(key);
      vpx.log.info("Task Browser: Turning on updates for viewId " + viewId);
      c.updatesId = tle.listenForUpdates(viewId, "VmAlarmListView/VmTasksListView", processUpdates);

   }
}

/**
 * Processes updates to the current Task browser's backing view.
 *
 * @param agent vpx.updates.Agent
 *    The agent that fired the event
 * @param refresh boolean
 *    true if a full refresh is required; false otherwise
 * @param changeSets Object[]
 *    An array of changeSet objects, each having the
 *    following attributes:
 *       id      : String
 *       type    : String
 *       changes : Object[] {property:String, value:String}
 */
function processUpdates(agent, refresh, changeSets) {
   var c = vpx.context.curr;

   vpx.log.info("received update: (refresh=" + refresh + ")");

   if (refresh) {
      c.browser.requestData(c.xmlSpec);
      return;
   }

   else{

      if (changeSets == null || changeSets.length == 0){
         return;
      }

      for (var i = 0; i < changeSets.length; i++) {
         var changeSet = changeSets[i];

         for (var j = 0; j < changeSet.changes.length; j++) {
            var change = changeSet.changes[j];
            var node = c.browser.getNodeById(changeSet.id);
            var column = c.browser.getColByName(change.property);

              if (!isNull(node) && !isNull(column)) {

                  var className = "<div class=\"loading-9x9 icon\"/>";
                  if (change.property == "state") {

                     if (change.value == 'success' ||change.value == 'queued') {
                         className = "<div class=\"okay-12x12 icon\"/>";
                     } else if (change.value == 'error') {
                         className = "<div class=\"error-12x12 icon\"/>";
                     }
                     var value = "<table><tr><td>"+ className + "</td><td>" + change.value + "</td></tr></table>";
                     node.setCellHtml(column, j, value);
                  }
              }
         }
      }
   }
}

function highlightSelection(currElement) {
   if (selectedElement != null) {
      selectedElement.className = "blank";
   }

   selectedElement = currElement;

   if (currElement != null) {
      selectedElement.className = "highlight";
   }
}

function toggleShade(elementID) {
   var o = $(elementID);

   if (hasCssClass(o, "shaded")) {
      remCssClass(o, "shaded");
   } else{
      addCssClass(o, "shaded");
   }
}

function getCssClasses(o) {
   var s = vpx.xua.getAttribute(o, "class");
   return s ? s.split(" ") : [];
}

function setCssClasses(o, classes) {
   vpx.xua.setAttribute(o, "class", classes.join(" "));
}

function remCssClass(o, cssClass) {
   var classes = getCssClasses(o);

   for (var i = 0; i < classes.length; i++) {
      if (classes[i] == cssClass) {
         classes.splice(i, 1);
         setCssClasses(o, classes);
         return classes;
      }
   }

   return classes;
}

function addCssClass(o, cssClass) {
   var classes = getCssClasses(o);

   for (var i = 0; i < classes.length; i++) {
      if (classes[i] == cssClass) {
         return classes;
      }
   }

   classes.push(cssClass);
   setCssClasses(o, classes);

   return classes;
}

function hasCssClass(o, cssClass) {
   var classes = getCssClasses(o);

   for (var i = 0; i < classes.length; i++) {
      if (classes[i] == cssClass) {
         return true;
      }
   }

   return false;
}
