var selectedElement = null;
var shadedElement = null;

function highlightSelection(currElement){
   if (selectedElement != null){
     selectedElement.className = "blank";
   }

   selectedElement = currElement;
   if (currElement != null) {
      selectedElement.className = "highlight";
	}
}

function toggleShade(elementID){
   var o = $(elementID);
   if (hasCssClass(o, "shaded")) {
      remCssClass(o, "shaded");
   } else {
      addCssClass(o, "shaded");
   }
}

function getCssClasses(o) {
   var s = vpx.xua.getAttribute(o, "class");
   return s ? s.split(" ") : [];
}

function setCssClasses(o, classes) {
   vpx.xua.setAttribute(o, "class", classes.join(" "));
}

function remCssClass(o, cssClass) {
   var classes = getCssClasses(o);

   for (var i = 0; i < classes.length; i++) {
      if (classes[i] == cssClass) {
         classes.splice(i, 1);
         setCssClasses(o, classes);
         return classes;
      }
   }

   return classes;
}

function addCssClass(o, cssClass) {
   var classes = getCssClasses(o);

   for (var i = 0; i < classes.length; i++) {
      if (classes[i] == cssClass) {
         return classes;
      }
   }

   classes.push(cssClass);
   setCssClasses(o, classes);

   return classes;
}

function hasCssClass(o, cssClass) {
   var classes = getCssClasses(o);

   for (var i = 0; i < classes.length; i++) {
      if (classes[i] == cssClass) {
         return true;
      }
   }

   return false;
 }

function handleBodyLoad(){
   var c = vpx.context;
   window.parent.switchTab(c.TAB_NAME);
   window.parent.setTitleIcon("VM");

   tle.syncView();

   c.xmlSpec = new vpx.net.XmlSpec(c.XML_ACTION);
   c.xmlSpec.setAttribute(c.PARAM_NAME_ENTITY_ID, c.ENTITY_ID);
   c.paginator = new vpx.browser.Paginator($("paginatorContainer"));
   c.browser = new vpx.browser.Browser($("browserContainer"), c.PAGE_SIZE,
      vpx.browser.Browser.HEIGHT_POLICY.USER, true);
   c.paginator.setProvider(c.browser);

   c.browser.registerListener(vpx.browser.EVENT.SELECTION, handleSelectionChanged);
   c.browser.registerListener(vpx.browser.EVENT.SORT, handleSort);
   c.browser.registerListener(vpx.browser.EVENT.PAGE, handlePage);
   c.browser.registerListener(vpx.browser.EVENT.DATA, handleDataProcessed);
   c.browser.requestData(c.xmlSpec);

   setTimeout(handleResize, 0);
   vpx.xua.event.listen(self, "resize", handleResize);
}

function handleBodyUnload(){
   var c = vpx.context;

   if (c.updatesRunning){
      vpx.log.info("Event Browser: Stopping updates");
      tle.ignoreUpdates(c.updatesId);
      c.updatesRunning = false;
   }
}

function handleDataProcessed(browser, xmlSpec){
   var c = vpx.context;
   var key = c.PARAM_NAME_VIEW_ID;
   if (! c.updatesRunning && xmlSpec.hasAttribute(key)){
      c.updatesRunning = true;
      var viewId = xmlSpec.getAttribute(key);
      vpx.log.info("Event Browser: Turning on updates for viewId " + viewId);
      c.updatesId = tle.listenForUpdates(viewId, "VmEventsTabView", processUpdates);

   }
}

function handleSelectionChanged(browser){
   var c = vpx.context;
   var frameId = c.FRAME_ID;
   if (isNull(frameId)) {
      return;
   }

   var selected = browser.getSelected()[0];
   if (isNull(selected)){
      return;
   }

   var slctdId = selected.getId();
   var action = c.SELECTION_ACTION + "?" + c.PARAM_NAME_SLCT_ID + "=" + escape(slctdId);
   c.xmlSpec.setAttribute(c.PARAM_NAME_SLCT_ID, slctdId);

   var viewId = c.xmlSpec.getAttribute(c.PARAM_NAME_VIEW_ID);
   if (!isNull(viewId)) {
      action += "&" + c.PARAM_NAME_VIEW_ID + "=" + escape(viewId);
      c.xmlSpec.setAttribute(c.PARAM_NAME_VIEW_ID, viewId);
   }

   window.frames[frameId].location.replace(action);
}

function handleSort(browser, column, sortOrder){
   var c = vpx.context;
   c.xmlSpec.setAttribute(c.PARAM_NAME_SORT_COL, column.getName());
   c.xmlSpec.setAttribute(c.PARAM_NAME_SORT_DIR, sortOrder);
   browser.requestData(c.xmlSpec);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_SORT_COL);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_SORT_DIR);
}

function handlePage(browser, pageType){
   var c = vpx.context;
   switch (pageType){
      case vpx.browser.PAGE.PREV:
          c.xmlSpec.setAttribute(c.PARAM_NAME_PAGE, c.DC_PREV_PAGE);
          break;
      case vpx.browser.PAGE.NEXT:
          c.xmlSpec.setAttribute(c.PARAM_NAME_PAGE, c.DC_NEXT_PAGE);
          break;
      default: throw new Error("Unsupported page type: " + pageType);
   }

   browser.requestData(c.xmlSpec);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_PAGE);
}

function processUpdates(agent, refresh, changeSets){
   var c = vpx.context;
   vpx.log.info("Event Browser: received update: (refresh=" + refresh + ")");
   if (refresh){
      c.browser.requestData(c.xmlSpec);
      return;
   } else{
      vpx.log.warn("Event Browser: Update is being ignored");
   }
}


function handleResize() {
   var tbh = vpx.xua.getHeight("listTitlebar");
   var pch = vpx.xua.getHeight("paginatorContainer");
   var dch = vpx.xua.getHeight("details");
   var off = vpx.xua.getY("list") * 4;
   var height = vpx.xua.viewport.getHeight(self);

   vpx.xua.setHeight("browserContainer", height - dch - tbh - pch - off);
}
