function getCssClasses(o) {
   var s = vpx.xua.getAttribute(o, "class");
   return s ? s.split(" ") : [];
}

function setCssClasses(o, classes) {
   vpx.xua.setAttribute(o, "class", classes.join(" "));
}

function remCssClass(o, cssClass) {
   var classes = getCssClasses(o);

   for (var i = 0; i < classes.length; i++) {
      if (classes[i] == cssClass) {
         classes.splice(i, 1);
         setCssClasses(o, classes);
         return classes;
      }
   }

   return classes;
}

function addCssClass(o, cssClass) {
   var classes = getCssClasses(o);

   for (var i = 0; i < classes.length; i++) {
      if (classes[i] == cssClass) {
         return classes;
      }
   }

   classes.push(cssClass);
   setCssClasses(o, classes);

   return classes;
}

function hasCssClass(o, cssClass) {
   var classes = getCssClasses(o);

   for (var i = 0; i < classes.length; i++) {
      if (classes[i] == cssClass) {
         return true;
      }
   }

   return false;
 }

function toggleShadeState(idStr) {
   var o = $(idStr);
   if (hasCssClass(o, "shaded")) {
      remCssClass(o, "shaded");
   } else {
      addCssClass(o, "shaded");
   }
}

function toggleShadeIcon(o) {
   if (hasCssClass(o, "collapsed")) {
      remCssClass(o, "collapsed");
      addCssClass(o, "expanded");
   } else {
      remCssClass(o, "expanded");
      addCssClass(o, "collapsed");
   }
}

     